﻿USE [Provided]
SET NOCOUNT ON;
PRINT('Script working...');
GO
exec sp_MSforeachtable "declare @name nvarchar(max); set @name = parsename('?', 1); exec sp_MSdropconstraints @name";
GO
exec sp_MSforeachtable "drop table ?";
GO
BEGIN TRANSACTION Trans1;
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Action](
	[ActionID] [int] NOT NULL,
	[ActionName] [nvarchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[ActionType] [int] NULL,
	[BeginDate] [datetime] NOT NULL,
	[endDate] [datetime] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[ActionID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ActionTypes](
	[ActionTypeID] [int] NOT NULL,
	[ActionType] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[BeginDate] [datetime] NOT NULL,
	[endDate] [datetime] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[ActionTypeID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Addon](
	[BeginDate] [datetime] NOT NULL,
	[EndDate] [datetime] NOT NULL,
	[Code] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Interval] [int] NOT NULL,
	[IntervalType] [int] NOT NULL,
	[Area] [int] NOT NULL,
	[MinimumInterval] [int] NOT NULL,
	[MaximumMultiplier] [int] NOT NULL,
	[GroupID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[QuestionTypeID] [int] NOT NULL,
	[NumYes] [int] NOT NULL,
	[NumNo] [int] NOT NULL,
	[Facility] [bit] NULL,
	[MaxYes] [int] NOT NULL,
	[MaxNo] [int] NOT NULL,
	[ServiceType] [int] NOT NULL,
	[VarianceValue] [tinyint] NOT NULL
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[AddonFor](
	[BeginDate] [datetime] NOT NULL,
	[EndDate] [datetime] NOT NULL,
	[Addon] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Base] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Areas](
	[BeginDate] [datetime] NOT NULL,
	[EndDate] [datetime] NOT NULL,
	[AreaID] [int] NOT NULL,
	[Description] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
 CONSTRAINT [PK_Areas] PRIMARY KEY CLUSTERED 
(
	[AreaID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[AuditTrailArea](
	[AreaID] [int] NOT NULL,
	[AreaName] [nvarchar](25) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[BeginDate] [datetime] NOT NULL,
	[endDate] [datetime] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[AreaID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Carriers](
	[CarrierID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[BeginDate] [datetime] NOT NULL,
	[EndDate] [datetime] NOT NULL,
	[CarrierNumber] [int] NULL,
	[LocalityNumber] [int] NULL,
	[State] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[FeeScheduleArea] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[Counties] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
 CONSTRAINT [PK_Carriers] PRIMARY KEY CLUSTERED 
(
	[CarrierID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[CPTCodes](
	[MasterID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[New] [bit] NOT NULL,
	[Established] [bit] NOT NULL,
	[TypicalTimeSpent] [int] NULL,
	[Description] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[BeginDate] [datetime] NULL,
	[EndDate] [datetime] NULL,
	[Code] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[ServiceTypeID] [int] NULL,
	[SubServiceTypeID] [int] NULL,
	[KeyComponents] [int] NULL,
	[HistoryLevel] [int] NULL,
	[ExamLevel] [int] NULL,
	[DecisionLevel] [int] NULL,
	[AgeLow] [int] NULL,
	[AgeHigh] [int] NULL,
	[TimeLow] [int] NULL,
	[TimeHigh] [int] NULL,
	[QuestionTypeID] [int] NULL,
	[NumYes] [int] NULL,
	[NumNo] [int] NULL,
	[TypicalClinical] [int] NOT NULL,
	[AppropriateHistoryExam] [bit] NOT NULL,
	[MaxYes] [int] NOT NULL,
	[MaxNo] [int] NOT NULL,
	[VarianceValue] [tinyint] NOT NULL,
 CONSTRAINT [PK_CPTCodes] PRIMARY KEY CLUSTERED 
(
	[MasterID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[CPTRubrics](
	[RubricID] [int] NOT NULL,
	[ParentRubricID] [int] NULL,
	[LowRange] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[HiRange] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[Description] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
 CONSTRAINT [PK_CPTRubrics] PRIMARY KEY CLUSTERED 
(
	[RubricID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DatabaseVersion](
	[Version] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[SubVersion] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[Version] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DiagnosisCodes](
	[MasterID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Description] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[BeginDate] [datetime] NULL,
	[EndDate] [datetime] NULL,
	[Code] [nvarchar](20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[version] [int] NOT NULL,
 CONSTRAINT [PK_DiagnosisCodes] PRIMARY KEY CLUSTERED 
(
	[MasterID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ElementTypes](
	[ElementTypesID] [int] NOT NULL,
	[Type] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
 CONSTRAINT [PK_ElementTypes] PRIMARY KEY CLUSTERED 
(
	[ElementTypesID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ExamElements](
	[subsystemID] [int] NOT NULL,
	[MasterID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Shaded] [bit] NOT NULL,
	[HelpText] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[BeginDate] [datetime] NULL,
	[EndDate] [datetime] NULL,
	[ExamElementID] [int] NULL,
	[ExamTypeID] [int] NULL,
	[SystemAreaID] [int] NULL,
	[DisplayOrder] [int] NULL,
	[Description] [nvarchar](150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[Area] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[Clarification] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
 CONSTRAINT [PK_ExamElements] PRIMARY KEY CLUSTERED 
(
	[MasterID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ExamGuideline](
	[ExamGuidelineID] [int] NOT NULL,
	[Description] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
PRIMARY KEY CLUSTERED 
(
	[ExamGuidelineID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ExamSystemAreas](
	[SystemAreaID] [int] NOT NULL,
	[SystemArea] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[HelpText] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
 CONSTRAINT [PK_ExamSystemAreas] PRIMARY KEY CLUSTERED 
(
	[SystemAreaID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ExamTypes](
	[ExamTypeID] [int] NOT NULL,
	[ExamType] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[SortOrder] [smallint] NULL,
	[HelpText] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[SystemAreaKey] [nvarchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[ExamGuidelineID] [int] NOT NULL,
 CONSTRAINT [PK_ExamTypes] PRIMARY KEY CLUSTERED 
(
	[ExamTypeID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[GPCI](
	[CarrierID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[BeginDate] [datetime] NOT NULL,
	[EndDate] [datetime] NOT NULL,
	[GPCIID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Work GPCI] [numeric](18, 4) NULL,
	[PracticeGPCI] [numeric](18, 4) NULL,
	[MalPracticeGPCI] [numeric](18, 4) NULL,
 CONSTRAINT [PK_GPCI] PRIMARY KEY CLUSTERED 
(
	[GPCIID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HistoryCompletePFSH](
	[MasterID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Established] [bit] NOT NULL,
	[BeginDate] [datetime] NULL,
	[EndDate] [datetime] NULL,
	[ServiceTypeID] [int] NULL,
 CONSTRAINT [PK_HistoryCompletePFSH] PRIMARY KEY CLUSTERED 
(
	[MasterID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HistoryElements](
	[HistoryElementID] [int] NOT NULL,
	[TypeID] [int] NULL,
	[Element] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[HelpText] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
 CONSTRAINT [PK_HistoryElements] PRIMARY KEY CLUSTERED 
(
	[HistoryElementID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HistoryIntervalServices](
	[MasterID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Established] [bit] NOT NULL,
	[BeginDate] [datetime] NULL,
	[EndDate] [datetime] NULL,
	[ServiceTypeID] [int] NULL,
	[SubServiceTypeID] [int] NULL,
 CONSTRAINT [PK_HistoryIntervalServices] PRIMARY KEY CLUSTERED 
(
	[MasterID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[historyScreen](
	[historyScreenID] [int] NOT NULL,
	[HistoryScreenType] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[HelpText] [varchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
PRIMARY KEY CLUSTERED 
(
	[historyScreenID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HistoryTypes](
	[TypeID] [int] NOT NULL,
	[HistoryType] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[HelpText] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[HistoryScreenID] [int] NOT NULL,
 CONSTRAINT [PK_HistoryTypes] PRIMARY KEY CLUSTERED 
(
	[TypeID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[IntervalTypes](
	[BeginDate] [datetime] NOT NULL,
	[EndDate] [datetime] NOT NULL,
	[TypeID] [int] NOT NULL,
	[Description] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[MDMElements](
	[ElementID] [int] NOT NULL,
	[TypeID] [int] NOT NULL,
	[Description] [nvarchar](500) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[DisplayOrder] [int] NOT NULL,
 CONSTRAINT [PK_MDMElements] PRIMARY KEY CLUSTERED 
(
	[ElementID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[MDMTypes](
	[TypeID] [int] NOT NULL,
	[Type] [nvarchar](200) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
 CONSTRAINT [PK_MDMTypes] PRIMARY KEY CLUSTERED 
(
	[TypeID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[MedicalNecessityQuestions](
	[MasterID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Question] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[BeginDate] [datetime] NULL,
	[EndDate] [datetime] NULL,
	[Number] [int] NULL,
 CONSTRAINT [PK_MedicalNecessityQuestions] PRIMARY KEY CLUSTERED 
(
	[MasterID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Modifiers](
	[MasterID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Description] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[BeginDate] [datetime] NULL,
	[EndDate] [datetime] NULL,
	[Modifier] [nvarchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
 CONSTRAINT [PK_Modifiers] PRIMARY KEY CLUSTERED 
(
	[MasterID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[NationalBilledData](
	[MasterID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[ProcedureCode] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[SpecialtyCode] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[AllowedServices] [float] NULL,
	[BeginDate] [datetime] NULL,
	[EndDate] [datetime] NULL,
	[ID] [int] NULL,
 CONSTRAINT [PK_NationalBilledData] PRIMARY KEY CLUSTERED 
(
	[MasterID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[OtherQuestions](
	[MasterID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Question] [nvarchar](510) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[BeginDate] [datetime] NULL,
	[EndDate] [datetime] NULL,
	[Number] [int] NULL,
	[Continue] [bit] NULL,
	[ServiceType] [int] NULL,
	[QuestionTypeId] [int] NOT NULL,
 CONSTRAINT [PK_OtherQuestions] PRIMARY KEY CLUSTERED 
(
	[MasterID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PasswordSettings](
	[PasswordSettingID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[PasswordSettingName] [nvarchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[PasswordSettingValue] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Selected] [bit] NULL,
 CONSTRAINT [PK_PasswordSettings] PRIMARY KEY CLUSTERED 
(
	[PasswordSettingID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Procedures](
	[MasterID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Description] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[BeginDate] [datetime] NULL,
	[EndDate] [datetime] NULL,
	[Code] [nvarchar](15) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
 CONSTRAINT [PK_Procedures] PRIMARY KEY CLUSTERED 
(
	[MasterID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[QuestionTypes](
	[MasterID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[QuestionTypeID] [int] NOT NULL,
	[QuestionType] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Description] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[BeginDate] [datetime] NULL,
	[EndDate] [datetime] NULL,
	[ServiceTypeID] [int] NULL,
	[Priority] [bit] NOT NULL,
 CONSTRAINT [PK_QuestionTypes] PRIMARY KEY CLUSTERED 
(
	[MasterID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[QuestionValidation](
	[MasterID] [int] NOT NULL,
	[QuestionTypeID] [int] NOT NULL,
	[ServiceTypeID] [int] NULL,
	[BeginDate] [datetime] NOT NULL,
	[EndDate] [datetime] NOT NULL,
	[Priority] [tinyint] NOT NULL,
	[ValidationMask] [int] NOT NULL,
	[ComparisonType] [tinyint] NOT NULL,
	[Success] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[Fail] [varchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[NoValidationMask] [int] NOT NULL,
	[UnansweredBlank] [bit] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[MasterID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ReportOptions](
	[ReportOptionID] [int] NOT NULL,
	[ReportID] [int] NULL,
	[SortOrderID] [int] NULL,
	[Option] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[ParameterName] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
 CONSTRAINT [PK_ReportOptions] PRIMARY KEY CLUSTERED 
(
	[ReportOptionID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Reports](
	[ReportID] [int] NOT NULL,
	[SortOrderID] [int] NULL,
	[TypeID] [int] NULL,
	[Name] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[SampleReportName] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[columns] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[defaults] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[special] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
 CONSTRAINT [PK_Reports] PRIMARY KEY CLUSTERED 
(
	[ReportID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[RiskElements](
	[ElementID] [int] NOT NULL,
	[UserAdded] [bit] NOT NULL,
	[CategoryID] [int] NULL,
	[LevelID] [int] NULL,
	[Description] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
 CONSTRAINT [PK_RiskElements] PRIMARY KEY CLUSTERED 
(
	[ElementID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[RVU](
	[RVUID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[BeginDate] [datetime] NOT NULL,
	[EndDate] [datetime] NOT NULL,
	[NonFacilityPracticeExpense] [float] NULL,
	[NonFacilityTotal] [float] NULL,
	[Code] [nvarchar](5) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[Mod] [nvarchar](3) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[StatusCode] [nvarchar](1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[Work] [float] NULL,
	[FacilityPracticeExpense] [float] NULL,
	[Malpractice] [float] NULL,
	[FacilityTotal] [float] NULL,
 CONSTRAINT [PK_RVU] PRIMARY KEY CLUSTERED 
(
	[RVUID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[RVUConversion](
	[BeginDate] [datetime] NOT NULL,
	[EndDate] [datetime] NOT NULL,
	[Conversion] [float] NOT NULL,
 CONSTRAINT [PK_RVUConversion] PRIMARY KEY CLUSTERED 
(
	[BeginDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ServiceTypes](
	[MasterID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[ServiceType] [nvarchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[HelpText] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[BeginDate] [datetime] NULL,
	[EndDate] [datetime] NULL,
	[ServiceTypeID] [int] NULL,
	[ParentId] [int] NULL,
	[HistoryScreenID] [int] NOT NULL,
	[ServiceLevel] [int] NOT NULL,
	[TimeTypeID] [tinyint] NOT NULL,
 CONSTRAINT [PK_ServiceTypes] PRIMARY KEY CLUSTERED 
(
	[MasterID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Specialties](
	[OfficeID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[Specialty] [nvarchar](255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[BeginDate] [datetime] NULL,
	[EndDate] [datetime] NULL,
	[SpecialtyID] [varchar](10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
 CONSTRAINT [PK_Specialties] PRIMARY KEY CLUSTERED 
(
	[OfficeID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[SubServiceTypes](
	[MasterID] [nvarchar](50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[TypeID] [int] NULL,
	[Type] [nvarchar](100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[HelpText] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[BeginDate] [datetime] NULL,
	[EndDate] [datetime] NULL,
	[ID] [int] NULL,
	[HistoryScreenID] [int] NOT NULL,
 CONSTRAINT [PK_SubServiceTypes] PRIMARY KEY CLUSTERED 
(
	[MasterID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (1, N'Opened', 1, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (2, N'Closed', 1, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (3, N'Edited', 2, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (4, N'Created', NULL, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (5, N'Sent To', NULL, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (6, N'Received From', NULL, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (7, N'Merged from', NULL, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (8, N'Deleted', 2, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (9, N'Added', 2, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (10, N'Removed', 2, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (11, N'Started', NULL, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (12, N'Stopped', NULL, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (13, N'Succeeded', 4, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (14, N'Failed', 4, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (15, N'Failed-Concurrent', 4, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (16, N'Archived', 2, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (17, N'Moved To Deleted', 2, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (18, N'Restored Archived', 2, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (19, N'Restored Deleted', 2, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (20, N'Imported', 2, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (21, N'Exported', 1, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[Action] ([ActionID], [ActionName], [ActionType], [BeginDate], [endDate]) VALUES (22, N'Failed to Delete', 4, CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[ActionTypes] ([ActionTypeID], [ActionType], [BeginDate], [endDate]) VALUES (1, N'Viewed', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[ActionTypes] ([ActionTypeID], [ActionType], [BeginDate], [endDate]) VALUES (2, N'Edited', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[ActionTypes] ([ActionTypeID], [ActionType], [BeginDate], [endDate]) VALUES (3, N'Merged', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[ActionTypes] ([ActionTypeID], [ActionType], [BeginDate], [endDate]) VALUES (4, N'Attempted', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
GO
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', 30, 4, 0, 16, 1, N'1', -1, -1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', 30, 4, 0, 38, 1, N'1', -1, -1, -1, NULL, -1, -1, -1, 2)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', 30, 4, 0, 53, 1, N'1', -1, -1, -1, NULL, -1, -1, -1, 3)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90840', 30, 1, 0, 75, 0, N'3600', -1, -1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2021-12-31T23:59:00.000' AS DateTime), N'99292', 30, 1, 0, 75, 0, N'1600', -1, -1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', 30, 5, 0, 30, 1, N'2', 7, 0, 1, NULL, -1, 1, 3300, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99355', 30, 5, 0, 75, 0, N'2', -1, -1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', 30, 5, 0, 30, 1, N'3', 7, 1, 0, NULL, 1, -1, 3300, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99357', 30, 5, 0, 75, 0, N'3', -1, -1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2017-03-31T23:59:00.000' AS DateTime), N'99359', 30, 1, 0, 75, 0, N'2500', -1, -1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2017-04-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99359', 30, 1, 0, 75, 2, N'2500', -1, -1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99467', 30, 1, 0, 75, 0, N'3020', -1, -1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99486', 30, 1, 0, 46, 0, N'3030', -1, -1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99489', 30, 1, 0, 75, 0, N'4300', -1, -1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99498', 30, 1, 0, 46, 0, N'4500', -1, -1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2021-12-31T23:59:00.000' AS DateTime), N'99489', 30, 1, 0, 90, 0, N'4350', -1, -1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90785', 0, 6, 0, 0, 0, N'5', 3, 1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90863', 0, 6, 0, 0, 0, N'6', 4, 1, -1, NULL, -1, -1, 35003545, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2016-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99415', 30, 5, 0, 45, 1, N'99415', 5, 1, 0, 0, 1, 0, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2016-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99416', 30, 5, 0, 75, 0, N'99415', 5, 1, -1, 0, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2016-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', 30, 5, 0, 30, 1, N'2', 5, 0, 1, NULL, 0, 1, 1000, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2016-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', 30, 5, 0, 30, 1, N'3', -1, -1, -1, NULL, -1, -1, 1100, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2015-12-31T23:59:00.000' AS DateTime), N'99354', 30, 5, 0, 30, 1, N'2', -1, -1, -1, NULL, -1, -1, 1000, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2015-12-31T23:59:00.000' AS DateTime), N'99356', 30, 5, 0, 30, 1, N'3', -1, -1, -1, NULL, -1, -1, 1100, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', 30, 5, 0, 30, 1, N'3', -1, -1, -1, NULL, -1, -1, 13001700, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', 30, 5, 0, 30, 1, N'3', -1, -1, -1, NULL, -1, -1, 13001800, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', 30, 5, 0, 30, 1, N'3', -1, -1, -1, NULL, -1, -1, 2100, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', 30, 5, 0, 30, 1, N'3', -1, -1, -1, NULL, -1, -1, 2300, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', 30, 5, 0, 30, 1, N'3', -1, -1, -1, NULL, -1, -1, 1200, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', 30, 5, 0, 30, 1, N'3', -1, -1, -1, NULL, -1, -1, 2000, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99494', 30, 5, 0, 16, 0, N'4375', -1, -1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2020-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99458', 20, 1, 0, 40, 0, N'99458', -1, -1, -1, NULL, -1, -1, 29509700, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2020-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'G2058', 20, 1, 0, 40, 2, N'G2058', -1, -1, -1, NULL, -1, -1, 43509500, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2021-12-31T23:59:00.000' AS DateTime), N'99439', 20, 1, 0, 40, 2, N'99439', -1, -1, -1, NULL, -1, -1, 43509500, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99417', 15, 5, 0, 15, 0, N'99417', 19, 0, 1, NULL, -1, -1, 1000, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99415', 30, 7, 0, 30, 1, N'99415', -1, -1, -1, 0, -1, -1, 1000, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99416', 30, 7, 0, 75, 0, N'99415', -1, -1, -1, 0, -1, -1, 1000, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2016-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99415', 30, 7, 0, 45, 1, N'99415', 5, 0, 0, 0, 1, 0, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2016-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99416', 30, 7, 0, 75, 0, N'99415', 5, 0, 0, 0, 1, 0, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'G2212', 15, 5, 0, 15, 0, N'G2212', 19, 1, 0, NULL, -1, -1, 1000, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2211', 0, 6, 0, 0, 1, N'G2211', 20, -1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', 30, 5, 0, 30, 1, N'2', -1, -1, -1, NULL, -1, -1, 4325, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99425', 30, 1, 0, 60, 0, N'99425', -1, -1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99427', 30, 1, 0, 60, 2, N'99427', -1, -1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99437', 30, 1, 0, 60, 0, N'99437', -1, -1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99439', 20, 1, 0, 40, 2, N'99439', -1, -1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99489', 30, 1, 0, 90, 0, N'99489', -1, -1, -1, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99292', 30, 1, 0, 104, 0, N'1600', 22, 1, 0, NULL, -1, -1, 1600, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99292', 30, 1, 0, 75, 0, N'1600', 22, 0, 1, NULL, -1, -1, 1600, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99417', 15, 5, 0, 15, 0, N'99417', -1, -1, -1, NULL, -1, -1, 13001700, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99417', 15, 5, 0, 15, 0, N'99417', 10, 9, 1, NULL, -1, -1, 4325, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99417', 15, 5, 0, 15, 0, N'99417', 28, 0, 1, NULL, -1, -1, 2300, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99418', 15, 5, 0, 15, 0, N'99418', -1, -1, -1, NULL, -1, -1, 13001800, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99418', 15, 5, 0, 15, 0, N'99418', 28, 0, 1, NULL, -1, -1, 12001175, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99418', 15, 5, 0, 15, 0, N'99418', 28, 0, 1, NULL, -1, -1, 12001300, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99418', 15, 5, 0, 15, 0, N'99418', 28, 0, 1, NULL, -1, -1, 12001400, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99418', 15, 5, 0, 15, 0, N'99418', 28, 0, 1, NULL, -1, -1, 20002780, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99418', 15, 5, 0, 15, 0, N'99418', 28, 0, 1, NULL, -1, -1, 20002900, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0316', 15, 5, 0, 15, 0, N'G0316', 28, 1, 0, NULL, -1, -1, 12001175, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0316', 15, 5, 0, 15, 0, N'G0316', 28, 1, 0, NULL, -1, -1, 12001300, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0316', 15, 5, 0, 15, 0, N'G0316', 28, 1, 0, NULL, -1, -1, 12001400, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0317', 15, 5, 0, 15, 0, N'G0317', 28, 1, 0, NULL, -1, -1, 20002780, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0317', 15, 5, 0, 15, 0, N'G0317', 28, 1, 0, NULL, -1, -1, 20002900, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0318', 15, 5, 0, 15, 0, N'G0318', 28, 1, 0, NULL, -1, -1, 2300, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2212', 15, 5, 0, 15, 0, N'G2212', 10, 10, 0, NULL, -1, -1, 4325, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99417', 15, 5, 0, 15, 0, N'99417', 28, 0, 1, NULL, 0, -1, 1000, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2212', 15, 5, 0, 15, 0, N'G2212', 28, 1, 0, NULL, -1, -1, 1000, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99292', 30, 1, 0, 60, 0, N'1600', 29, 4, 0, NULL, -1, -1, 16002300, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', 0, 6, 0, 0, 1, N'99459', 30, 1, 0, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99417', 15, 5, 0, 15, 0, N'99417', -1, -1, -1, NULL, -1, -1, 10501000, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99417', 15, 5, 0, 15, 0, N'99417', -1, -1, -1, NULL, -1, -1, 10502000, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0545', 0, 6, 0, 0, 1, N'G0545', 34, -1, -1, NULL, -1, -1, 1200, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0513', 30, 5, 0, 16, 1, N'G0513', 42, 1, 0, NULL, -1, -1, -1, 1)
INSERT [dbo].[Addon] ([BeginDate], [EndDate], [Code], [Interval], [IntervalType], [Area], [MinimumInterval], [MaximumMultiplier], [GroupID], [QuestionTypeID], [NumYes], [NumNo], [Facility], [MaxYes], [MaxNo], [ServiceType], [VarianceValue]) VALUES (CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0514', 30, 5, 0, 46, 0, N'G0513', 42, 1, 0, NULL, -1, -1, -1, 1)
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'90837')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99292', N'99291')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'90837')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99354', N'99201')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99354', N'99202')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99354', N'99203')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99354', N'99204')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99354', N'99205')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99354', N'99211')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99354', N'99212')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99354', N'99213')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99354', N'99214')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99354', N'99215')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99241')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99242')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99243')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99244')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99245')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99324')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99325')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99326')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99327')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99328')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99334')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99335')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99336')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99337')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99341')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99342')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99343')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99344')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99345')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99347')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99348')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99349')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99350')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99355', N'99354')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99218')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99219')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99220')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99224')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99225')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99226')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99221')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99222')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99223')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99231')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99232')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99233')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99234')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99235')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99236')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99251')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99252')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99253')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99254')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99255')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99304')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99305')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99306')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99307')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99308')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99309')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'99310')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99357', N'99356')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99359', N'99358')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99467', N'99466')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99486', N'99485')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99489', N'99487')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99489', N'99488')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'90833', N'99201')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99202')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99203')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99204')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99205')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99211')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99212')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99213')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99214')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99215')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99217')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99218')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99219')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99220')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99224')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99225')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99226')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99221')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99222')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99223')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99231')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99232')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99233')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99234')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99235')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99236')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99238')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99239')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99241')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99242')
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99243')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99244')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99245')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99251')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99252')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99253')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99254')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99255')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99304')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99305')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99306')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99307')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99308')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99309')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99310')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99315')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99316')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99318')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99324')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99325')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99326')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99327')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99328')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99334')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99335')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99336')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99337')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99341')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99342')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90833', N'99343')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99344')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99345')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99347')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99348')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99349')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90833', N'99350')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'90836', N'99201')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99202')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99203')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99204')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99205')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99211')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99212')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99213')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99214')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99215')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99217')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99218')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99219')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99220')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99224')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99225')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99226')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99221')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99222')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99223')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99231')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99232')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99233')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99234')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99235')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99236')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99238')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99239')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99241')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99242')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99243')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99244')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99245')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99251')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99252')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99253')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99254')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99255')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99304')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99305')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99306')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99307')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99308')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99309')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99310')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99315')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99316')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99318')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99324')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99325')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99326')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99327')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99328')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99334')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99335')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99336')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99337')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99341')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99342')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90836', N'99343')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99344')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99345')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99347')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99348')
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99349')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90836', N'99350')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'90838', N'99201')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99202')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99203')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99204')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99205')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99211')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99212')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99213')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99214')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99215')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99217')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99218')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99219')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99220')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99224')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99225')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99226')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99221')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99222')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99223')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99231')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99232')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99233')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99234')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99235')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99236')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99238')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99239')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99241')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99242')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99243')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99244')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99245')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99251')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99252')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99253')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99254')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99255')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99304')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99305')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99306')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99307')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99308')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99309')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99310')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99315')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99316')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99318')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99324')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99325')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99326')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99327')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99328')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99334')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99335')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99336')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99337')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99341')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99342')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90838', N'99343')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99344')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99345')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99347')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99348')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99349')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90838', N'99350')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90840', N'90839')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99498', N'99497')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90785', N'90833')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90785', N'90836')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90785', N'90838')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90785', N'90791')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90785', N'90792')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90785', N'90853')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90863', N'90832')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90863', N'90834')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90863', N'90837')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90785', N'90832')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90785', N'90834')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90785', N'90837')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2016-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99415', N'99201')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2016-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99415', N'99202')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2016-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99415', N'99203')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2016-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99415', N'99204')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2016-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99415', N'99205')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2016-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99415', N'99211')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2016-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99415', N'99212')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2016-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99415', N'99213')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2016-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99415', N'99214')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2016-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99415', N'99215')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2016-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99416', N'99415')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99494', N'99493')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99494', N'99492')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2020-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99458', N'99457')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2020-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'G2058', N'99490')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99439', N'99490')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99417', N'99205')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99417', N'99215')
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2212', N'99205')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2212', N'99215')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99202')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99203')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99204')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99205')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99212')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99213')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99214')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99215')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99242')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99243')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99244')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99245')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99383')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99384')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99385')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99386')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99387')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'99483')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99354', N'90847')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99356', N'90847')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99425', N'99424')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99427', N'99426')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99437', N'99491')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99417', N'99245')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99417', N'99345')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99417', N'99350')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99417', N'99483')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99418', N'99223')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99418', N'99233')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99418', N'99236')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99418', N'99255')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99418', N'99306')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99418', N'99310')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0316', N'99223')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0316', N'99233')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0316', N'99236')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0317', N'99306')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0317', N'99310')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0318', N'99345')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0318', N'99350')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2212', N'99483')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99292', N'')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99292', N'99292')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99393')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99394')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99395')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99396')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99459', N'99397')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2211', N'99202')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2211', N'99203')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2211', N'99204')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2211', N'99205')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2211', N'99211')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2211', N'99212')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2211', N'99213')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2211', N'99214')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2211', N'99215')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0545', N'99221')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0545', N'99222')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0545', N'99223')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0545', N'99231')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0545', N'99232')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0545', N'99233')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0545', N'99234')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0545', N'99235')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0545', N'99236')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0545', N'99238')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0545', N'99239')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99417', N'98003')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99417', N'98007')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99417', N'98011')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99417', N'98015')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0513', N'G0101')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0513', N'G0402')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0513', N'G0438')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0513', N'G0439')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0514', N'G0513')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2026-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2211', N'99341')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2026-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2211', N'99342')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2026-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2211', N'99344')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2026-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2211', N'99345')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2026-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2211', N'99347')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2026-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2211', N'99348')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2026-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2211', N'99349')
INSERT [dbo].[AddonFor] ([BeginDate], [EndDate], [Addon], [Base]) VALUES (CAST(N'2026-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2211', N'99350')
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[Areas] ([BeginDate], [EndDate], [AreaID], [Description]) VALUES (CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T00:00:00.000' AS DateTime), 1, N'Full Body Systemic')
INSERT [dbo].[Areas] ([BeginDate], [EndDate], [AreaID], [Description]) VALUES (CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T00:00:00.000' AS DateTime), 2, N'Head')
GO
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (1, N'Visits', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (2, N'Patients', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (3, N'Attending Providers', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (4, N'Requesting Providers', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (5, N'Residents', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (6, N'Risk Elements', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (7, N'Fee Schedules', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (8, N'Note Macros', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (9, N'Modifiers', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (10, N'Specialties', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (11, N'Payors', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (12, N'Users', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (13, N'Logins', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (14, N'Reports', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (15, N'VisitSummaries', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (16, N'Offices', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (17, N'Admin', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (18, N'Documents', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (19, N'Principals', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
INSERT [dbo].[AuditTrailArea] ([AreaID], [AreaName], [BeginDate], [endDate]) VALUES (20, N'Audit Prep', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime))
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'00ce2a0ff021413c88e1ec22d6d9a81b', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 5302, 99, N'MISSOURI ', N'REST OF STATE* ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'0108f8d32f46408b8ddbe7f3f9d302c2', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 10202, 99, N'GEORGIA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'010f78bcab5c411f9af609e8197cd011', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 2402, 99, N'WASHINGTON ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'01919f9cd41e43ddac23de2bca39bf0c', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 13202, 1, N'NEW YORK ', N'MANHATTAN', N'NEW YORK ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'01d1b02a3e86448eb8eac3b57d8327e6', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 13202, 3, N'NEW YORK ', N'POUGHKPSIE/N NYC SUBURBS', N'COLUMBIA, DELAWARE, DUTCHESS, GREENE, ORANGE, PUTNAM, SULLIVAN AND ULSTER')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'028fe7943342466f8b4ab78ecf7423ef', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 13282, 99, N'NEW YORK ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'034cf6604e9447fb8f96068fb68968da', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 10102, 0, N'ALABAMA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'036a74ffdf454de6a7b10279a0d719d7', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 4412, 20, N'TEXAS ', N'BEAUMONT', N'JEFFERSON ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'0380ba7ea478426e9df2fab640f5e8a7', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 11202, 1, N'SOUTH CAROLINA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'03f36a2b7c914df9825def69d59fa560', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 4412, 15, N'TEXAS ', N'GALVESTON', N'GALVESTON ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'04640b001c6c409497d3537e6fd57c16', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1212, 1, N'HAWAII/GUAM', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'04717b9721134703bab346408462ebd7', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 10102, 0, N'ALABAMA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'055317da049442a79938c8755def6e02', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 4312, 0, N'OKLAHOMA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'05ff879d886b4c4aba53ed6a2d6ed764', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 951, 0, N'WISCONSIN ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'069b98852e77447f9ce90c2994e2675e', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 12502, 99, N'PENNSYLVANIA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'0717c55eac944fb8a795a2c60fc53599', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 5302, 1, N'MISSOURI ', N'METROPOLITAN ST. LOUIS', N'JEFFERSON, ST. CHARLES, ST. LOUIS AND ST. LOUIS CITY')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'075507b1721a46c5912ad654c3c38ade', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 13282, 99, N'NEW YORK ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'080caafc1d9a4fd1bb2c5d85c2af8afd1', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1182, 18, N'CALIFORNIA', N'LOS ANGELES-LONG BEACH-ANAHEIM (LOS ANGELES CNTY)', N'LOS ANGELES /ORANGE CNTY')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'080caafc1d9a4fd1bb2c5d85c2af8afd2', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 5, N'CALIFORNIA', N'SAN FRANCISCO-OAKLAND-BERKELEY (SAN FRANCISCO CNTY/ALAMEDA/CONTR COSTA CNTY/SAN MATEO)', N'SAN FRANCISCO/ALAMEDA/CONTRA COSTA/SAN MATEO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'081126960f144a638ae5dfa63e287473', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 4212, 5, N'NEW MEXICO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'08e2f51e1e8d4685bce431a08c4d2fc6', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 1212, 1, N'HAWAII/GUAM', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'0912da07e4224e3291de4078e061dcc0', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 5302, 2, N'MISSOURI ', N'METROPOLITAN KANSAS CITY', N'CLAY, JACKSON AND PLATTE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'09153b657f3540718dce2decc78fcccf', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 14412, 1, N'RHODE ISLAND ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'0979ddad7484487aba06bf3a5d614952', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 13282, 99, N'NEW YORK ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'09cdb638bd954a748889227efd6ccd43', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 9102, 4, N'FLORIDA ', N'MIAMI', N'DADE AND MONROE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'0b17cfd8be574b11aba5e0d248de4e3b', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 12302, 1, N'MARYLAND ', N'BALTIMORE/SURR. CNTYS', N'ANNE ARUNDEL, BALTIMORE, BALTIMORE CITY, CARROLL, HARFORD AND HOWARD')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'0bd6b02c10e649d9bea82ab17a75da09', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 9202, 20, N'PUERTO RICO ', N'PUERTO RICO', N'ALL COUNTY EQUIVALENTS')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'0c685a18c4494da3a8d880fa491c6a63', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 14402, 1, N'RHODE ISLAND ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'0ca918df62e04055b781c14f5f6c96b5', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 4312, 0, N'OKLAHOMA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'0cc66f9b5dbd4374b291e146c9d2b404', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 11402, 16, N'WEST VIRGINIA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'0dd1054eb8b2447cb50bc5e086264998', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 2402, 99, N'WASHINGTON ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'0df98d1337de4212b24ec33892606320', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 10102, 0, N'ALABAMA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'0e2d5f36295c441491b7bd96eb0919af', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 3602, 21, N'WYOMING ', N'STATEWIDE ', N'')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'0f1f8ee228d44d88a731aa44179219f7', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2016-12-31T23:59:00.000' AS DateTime), 1182, 18, N'CALIFORNIA ', N'LOS ANGELES', N'LOS ANGELES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1002ae07f7174af6967a9885c14c76b3', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 4412, 28, N'TEXAS ', N'FORT WORTH', N'TARRANT ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'104e860b80184f85945bd2d76965e257', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 13202, 3, N'NEW YORK ', N'POUGHKPSIE/N NYC SUBURBS', N'COLUMBIA, DELAWARE, DUTCHESS, GREENE, ORANGE, PUTNAM, SULLIVAN AND ULSTER')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1074961420314f3ea60769321e98dc98', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 10202, 1, N'GEORGIA ', N'ATLANTA', N'BUTTS, CHEROKEE, CLAYTON, COBB, DEKALB, DOUGLAS, FAYETTE, FORSYTH, FULTON, GWINNETT, HENRY, NEWTON, PAULDING, ROCKDALE AND WALTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'10e6223ccc8d4074bf3a1e7c4a1a0c0f', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 13292, 4, N'NEW YORK', N'QUEENS', N'QUEENS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1106834200714ccb9792f1c33dde3bf2', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 2402, 99, N'WASHINGTON ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1178e765d500474ea49668fea2fea2c6', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 9102, 3, N'FLORIDA ', N'FORT LAUDERDALE', N'BROWARD, COLLIER, INDIAN RIVER, LEE, MARTIN, PALM BEACH, AND ST. LUCIE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1195d34ea3b04daa921b32818302f0e8', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 13292, 4, N'NEW YORK ', N'QUEENS', N'QUEENS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'12033f10c83b4792b717aaf0a219d0c1', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 4102, 1, N'COLORADO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'122cab0d893e450182d137a1fb355d94', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 1192, 18, N'CALIFORNIA ', N'LOS ANGELES', N'LOS ANGELES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'122fb95c18544bfdbe964180b407d242', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 1102, 6, N'CALIFORNIA ', N'SAN MATEO', N'SAN MATEO ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'132cb0a9768849c9a3a04782d1215c49', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 7202, 99, N'LOUISIANA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1684a721acf54595b8c4019c395b85e1', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 2202, 0, N'IDAHO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'16a1d53dfb154de493799cf1c8e1f486', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 2302, 99, N'OREGON ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1726a6089b704610b37de77f7052223b', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 13202, 3, N'NEW YORK ', N'POUGHKPSIE/N NYC SUBURBS', N'COLUMBIA, DELAWARE, DUTCHESS, GREENE, ORANGE, PUTNAM, SULLIVAN AND ULSTER')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'175d16f5b9dd4038bdfdd5b0a5371429', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 7102, 13, N'ARKANSAS ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'17f348c86c544680969fa57317bafdf0', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 11402, 16, N'WEST VIRGINIA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'182a99b7c0bf4096b4a1163886b73a6e', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 1192, 18, N'CALIFORNIA ', N'LOS ANGELES', N'LOS ANGELES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1899234e07364b8b908b77947552f58f', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 14212, 99, N'MASSACHUSETTS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'18bb266bb799436f932696cac1f9bfda', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 2202, 0, N'IDAHO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'18c112d6c1aa47d482a9126d26aa695b', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 12202, 1, N'DISTRICT OF COLUMBIA ', N'DC MD/VA SUBURBS', N'DISTRICT OF COLUMBIA; ALEXANDRIA CITY, ARLINGTON, FAIRFAX, FAIRFAX CITY, FALLS CHURCH CITY IN VIRGINIA; MONTGOMERY AND PRINCE GEORGES IN MARYLAND')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1965db56250342309bb6fab41e67ba83', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 9102, 99, N'FLORIDA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'198ab3d45a2e4ed5921514148083f262', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 14202, 99, N'MASSACHUSETTS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1995dfc72f4644a6973883cc69239fca', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 14402, 1, N'RHODE ISLAND ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'19bbf5b7249549b58ae0fa200459a718', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 1192, 26, N'CALIFORNIA ', N'ANAHEIM/SANTA ANA', N'ORANGE ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1a84e48b0ea64f72a7aca88c7c808620', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 4412, 15, N'TEXAS ', N'GALVESTON', N'GALVESTON ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1b51953f40554ea5a11f2d08bef5080e', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 5302, 1, N'MISSOURI ', N'METROPOLITAN ST. LOUIS', N'JEFFERSON, ST. CHARLES, ST. LOUIS AND ST. LOUIS CITY')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1b54c579ed344de5858bf713c58cf591', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 14102, 3, N'MAINE ', N'SOUTHERN MAINE ', N'CUMBERLAND AND YORK')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1bf902528f1d4e7b918bc60d5a2e17d0', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 12402, 1, N'NEW JERSEY ', N'NORTHERN NJ ', N'BERGEN, ESSEX, HUDSON, HUNTERDON, MIDDLESEX, MORRIS, PASSAIC, SOMERSET, SUSSEX, UNION AND WARREN')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1c51bf59684f48da89a7e53adf0a8bac', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 1202, 1, N'HAWAII/GUAM', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1c5c450d94ab40d59371e1a991f5360d', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 5302, 2, N'MISSOURI ', N'METROPOLITAN KANSAS CITY', N'CLAY, JACKSON AND PLATTE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1c931d09edc14a94ba97c79abb9abb32', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 4402, 15, N'TEXAS ', N'GALVESTON', N'GALVESTON ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1cada730766b4ad48c58b14045d7279d', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 8202, 1, N'MICHIGAN ', N'DETROIT', N'MACOMB, OAKLAND, WASHTENAW AND WAYNE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1cfa268a8e6846b59ea606bb745be592', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 14202, 1, N'MASSACHUSETTS ', N'METROPOLITAN BOSTON ', N'MIDDLESEX, NORFOLK AND SUFFOLK')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1d0ec9f8ac1148449b13a63f7963ff74', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 12402, 1, N'NEW JERSEY ', N'NORTHERN NJ ', N'BERGEN, ESSEX, HUDSON, HUNTERDON, MIDDLESEX, MORRIS, PASSAIC, SOMERSET, SUSSEX, UNION AND WARREN')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1e1990be87c8479ab89c8021977b79bb', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 6102, 16, N'ILLINOIS ', N'CHICAGO', N'COOK ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1e378e09ba454241aeb9eabab4f1b1e9', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 8202, 1, N'MICHIGAN ', N'DETROIT', N'MACOMB, OAKLAND, WASHTENAW AND WAYNE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1e6522fe4da94f99b980f58522e27e90', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 952, 15, N'ILLINOIS ', N'SUBURBAN CHICAGO', N'DUPAGE, KANE, LAKE AND WILL')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1eadc2cfd0c84579ac04356fdb639707', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 8202, 1, N'MICHIGAN ', N'DETROIT', N'MACOMB, OAKLAND, WASHTENAW AND WAYNE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'1ff049bd7749424a85ceb9f3cf93fbfc', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1312, 0, N'NEVADA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2020cc9f68c64a5483f73ebb0622447d', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 9202, 20, N'PUERTO RICO ', N'PUERTO RICO', N'ALL COUNTY EQUIVALENTS')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'209a7f33dd00409a851420c5d39fc50e', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 1102, 6, N'CALIFORNIA ', N'SAN MATEO', N'SAN MATEO ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'20f9e383ce13486987af541b21dbb423', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 3302, 1, N'NORTH DAKOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'212a90f5651d4d4e91691cf203fabbe6', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 99, N'CALIFORNIA ', N'REST OF STATE*', N'ALL OTHER COUNTIES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'21823728e846428eaaf70e8d0a739bb9', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 1192, 26, N'CALIFORNIA ', N'ANAHEIM/SANTA ANA', N'ORANGE ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'219348f4126844c38da8a5a9a35f9c44', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 4402, 20, N'TEXAS ', N'BEAUMONT', N'JEFFERSON ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'21d80bce24654057b3d72d0b2a56512c', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 5402, 0, N'NEBRASKA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'21e2b22926b34738851bb5fff0320e3f', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 14402, 1, N'RHODE ISLAND ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'22400a923ddc471588b4451992326a77', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 3202, 1, N'MONTANA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2241867810a944fa8faa60fad0f6ea93', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 13202, 2, N'NEW YORK ', N'NYC SUBURBS/LONG ISLAND', N'BRONX, KINGS, NASSAU, RICHMOND, ROCKLAND, SUFFOLK AND WESTCHESTER')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2347a612104f40d9a36deb38b17a9fba', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 2102, 1, N'ALASKA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'23fcd984808243a7ad94de09e486dd7f', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 7302, 0, N'MISSISSIPPI ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2477b082610d436686835444645b3189', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 4402, 99, N'TEXAS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'24e1e7714ba94cbeb766f9aef76c9101', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 7102, 13, N'ARKANSAS ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'24e3e0e067854984933f1db88327310e', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 4312, 0, N'OKLAHOMA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'250f8a6d8ff34c75a9cb5b2cce7a532d', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 5302, 99, N'MISSOURI ', N'REST OF STATE* ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'25248b132b3f4c6ebc2a92c8567b2f9d', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 9102, 99, N'FLORIDA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'252e2ce365e74fe9901fabfa4a674020', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 13202, 3, N'NEW YORK ', N'POUGHKPSIE/N NYC SUBURBS', N'COLUMBIA, DELAWARE, DUTCHESS, GREENE, ORANGE, PUTNAM, SULLIVAN AND ULSTER')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'25c6ec599ed44fc187dc53cadc1457cd', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), 10102, 0, N'ALABAMA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2608dafc452c40849e3c579abbaaa8aa', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 5202, 0, N'KANSAS ', N'STATEWIDE* ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'260d46f463a84e81a14937c962414258', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 1192, 26, N'CALIFORNIA ', N'ANAHEIM/SANTA ANA', N'ORANGE ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'264b7c3a98b5426da41371e0cfcf74f8', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 2302, 99, N'OREGON ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'26a647db1dbb4193a85ba3bc20f17e15', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 1102, 6, N'CALIFORNIA ', N'SAN MATEO', N'SAN MATEO ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'26b7789a07d94d5582042b0e3a4e9548', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 5302, 99, N'MISSOURI ', N'REST OF STATE* ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'27ad4d0d825a4779979141f166888198', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 1182, 26, N'CALIFORNIA ', N'ANAHEIM/SANTA ANA', N'ORANGE ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'295d395ecde944538222995b842e4870', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 9102, 99, N'FLORIDA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2a046c7018a144a9878f7f203ea603f5', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 5102, 0, N'IOWA ', N'STATEWIDE ', N'ALL COUNTIES ')
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2a64c4857f5d4734a86e9fa90cbfe1eb', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 13292, 4, N'NEW YORK ', N'QUEENS', N'QUEENS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2b8a6b9ba9a2440aac1843ec876e6eea', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 4402, 18, N'TEXAS ', N'HOUSTON', N'HARRIS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2b8b459a62044fecbae06b292d9c92a0', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 5302, 99, N'MISSOURI ', N'REST OF STATE*', N'ALL OTHER COUNTIES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2bc98ec58f2346fe9910b4b1d119c8a7', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 952, 16, N'ILLINOIS ', N'CHICAGO', N'COOK ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2bcb50c0065742fd97f4bc3bf1bd4a4e', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 14502, 50, N'VERMONT ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2bdbae8875714cb9926bbbaa400e5131', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 3102, 0, N'ARIZONA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2c37825d6c56498fac343526e709743d', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 14202, 1, N'MASSACHUSETTS ', N'METROPOLITAN BOSTON ', N'MIDDLESEX, NORFOLK AND SUFFOLK')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2cb9fc41a2e14a6e9720394324634350', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 6102, 15, N'ILLINOIS ', N'SUBURBAN CHICAGO', N'DUPAGE, KANE, LAKE AND WILL')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2cecac4b71ca4352b72f2667fd61593d', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 10302, 35, N'TENNESSEE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2d193b7396ed42a3b28760ce0ecca22f', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 954, 0, N'MINNESOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2d5e64ced984413990a1347a4cc2408c', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 12402, 99, N'NEW JERSEY ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2da1f3d12b844f99bd1eb920865e0de8', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), 10202, 99, N'GEORGIA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2dbd8d1392ca492a8317432157c7b08d', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 4412, 11, N'TEXAS ', N'DALLAS', N'DALLAS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2e0b75973053420794183158836a640d', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 12402, 99, N'NEW JERSEY', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'2ec3fa0cde4a457d96f7f23896dcef69', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 952, 16, N'ILLINOIS ', N'CHICAGO', N'COOK ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3131d171e4264219aaf50af3666b921a', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), 1112, 7, N'CALIFORNIA ', N'OAKLAND/BERKLEY', N'ALAMEDA AND CONTRA COSTA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3146405a165849dc88aa020fed0b4828', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 9102, 3, N'FLORIDA ', N'FORT LAUDERDALE', N'BROWARD, COLLIER, INDIAN RIVER, LEE, MARTIN, PALM BEACH, AND ST. LUCIE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3162f1785c434ba7a47dc0cc27183de2', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 12502, 1, N'PENNSYLVANIA ', N'METROPOLITAN PHILADELPHIA', N'BUCKS, CHESTER, DELAWARE, MONTGOMERY AND PHILADELPHIA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'327346a26c3c417b8edb8b49a09f06b7', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 10302, 35, N'TENNESSEE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3296add6aa724cbba907f5647c20b72f', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 12302, 99, N'MARYLAND ', N'REST OF STATE ', N'ALL OTHER COUNTIES EXCEPT MONTGOMERY AND PRINCE GEORGES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'33f7d9e1448543dfafd931692c6963be', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 4212, 5, N'NEW MEXICO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'34cfde3166254f90a0ffa556decbc86c', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 15102, 0, N'KENTUCKY ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'35f3d48be8004d539377f72074c14c9c', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 4402, 28, N'TEXAS ', N'FORT WORTH', N'TARRANT ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3653a807e4ad4ff1a44b5f1c0166f814', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 12402, 1, N'NEW JERSEY ', N'NORTHERN NJ ', N'BERGEN, ESSEX, HUDSON, HUNTERDON, MIDDLESEX, MORRIS, PASSAIC, SOMERSET, SUSSEX, UNION AND WARREN')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'365dda656fee465297b60520203faf68', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 14502, 50, N'VERMONT ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'377beb41b8c545b199a7dca1361dd7e0', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 1102, 5, N'CALIFORNIA ', N'SAN FRANCISCO', N'SAN FRANCISCO ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3791954e91864d06a2e02e3cee356339', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 2302, 1, N'OREGON ', N'PORTLAND', N'CLACKAMAS, MULTNOMAH AND WASHINGTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'37cee35c1e0e44929210b7e95baed854', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 13282, 99, N'NEW YORK', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'385e7091f78540dc9c81db68f6a32a26', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 1102, 5, N'CALIFORNIA ', N'SAN FRANCISCO', N'SAN FRANCISCO ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'38713f0c4acf43dab6d8ea01f19a0bcf', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 14502, 50, N'VERMONT ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3913c260d27441b9a9a99c4c192638b4', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 13202, 1, N'NEW YORK ', N'MANHATTAN', N'NEW YORK ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'39e360388cee43f393d2ad0feec0393a', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 4112, 1, N'COLORADO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3a4538a8d92b42979f6b2efa9657d776', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 1182, 17, N'CALIFORNIA ', N'VENTURA', N'VENTURA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3a72e6c371e2445da532cb0c682569db', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 2202, 0, N'IDAHO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3a752d6793684a3f81e773103998d22b', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 9102, 3, N'FLORIDA ', N'FORT LAUDERDALE', N'BROWARD, COLLIER, INDIAN RIVER, LEE, MARTIN, PALM BEACH, AND ST. LUCIE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3a7e89d8e4314725a7f319e26a99a181', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 12502, 1, N'PENNSYLVANIA ', N'METROPOLITAN PHILADELPHIA', N'BUCKS, CHESTER, DELAWARE, MONTGOMERY AND PHILADELPHIA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3a8247fa3a564a9cbeff578a1ca94290', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 12202, 1, N'DISTRICT OF COLUMBIA ', N'DC MD/VA SUBURBS', N'DISTRICT OF COLUMBIA; ALEXANDRIA CITY, ARLINGTON, FAIRFAX, FAIRFAX CITY, FALLS CHURCH CITY IN VIRGINIA; MONTGOMERY AND PRINCE GEORGES IN MARYLAND')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3b4bfc11949f4796856beac30d174440', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 8202, 99, N'MICHIGAN ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3bb72a939e80400fa689225e0bd266a8', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 4402, 15, N'TEXAS ', N'GALVESTON', N'GALVESTON ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3bc91e79a87a476bba397ad3d71a2c49', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 12502, 99, N'PENNSYLVANIA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3bfa2e7dbcf64025bb425f2d1c081727', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 14312, 40, N'NEW HAMPSHIRE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3c15d76a19c94f848ec3195e65c3745c', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 12402, 99, N'NEW JERSEY ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3c95d632aa104d6db3a18964eb2232c1', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 15102, 0, N'KENTUCKY ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3ca795381bd94272918ccdf4af55f2c4', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 4402, 9, N'TEXAS ', N'BRAZORIA', N'BRAZORIA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3cef1961d1ec42daa06a5ae34bfec860', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 13292, 4, N'NEW YORK ', N'QUEENS', N'QUEENS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3d2fa5a8b7844c90a60335eb14aa7315', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 12502, 1, N'PENNSYLVANIA ', N'METROPOLITAN PHILADELPHIA', N'BUCKS, CHESTER, DELAWARE, MONTGOMERY AND PHILADELPHIA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3d407cec66024c0d825c0bb03bf96f91', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 15102, 0, N'KENTUCKY ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3d9379e2fa814642acd6efae1e467c62', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 14112, 99, N'MAINE ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3e0260c89630430792952ba4f912f184', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 5202, 0, N'KANSAS ', N'STATEWIDE* ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3e1f95dbfb6844e6a67450068603c9c1', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 9102, 99, N'FLORIDA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3e4b91a912844e1583fb2899264e3914', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 12102, 1, N'DELAWARE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'3e7a322914e44868acb6e40611f30dc2', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 4402, 11, N'TEXAS ', N'DALLAS', N'DALLAS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'418175a64f5b4c81ab2d57ebb23ad014', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), 1112, 9, N'CALIFORNIA ', N'SANTA CLARA', N'SANTA CLARA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'41ee7af1277e4115bb294285ff0905c9', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 5102, 0, N'IOWA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4274a73f9eeb4da89b8c006119e160a6', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 10202, 99, N'GEORGIA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'42f864f4d166406188a63241fe78231e', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 12402, 99, N'NEW JERSEY ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'431459a88b3046788ec9b1b6a8b2835b', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 660, 0, N'KENTUCKY ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4315df81d45744e38a00d1b981a80a3a', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 1312, 0, N'NEVADA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'435e2ff07f934317bd677d0e9ea9aa6c', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 5302, 2, N'MISSOURI ', N'METROPOLITAN KANSAS CITY', N'CLAY, JACKSON AND PLATTE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'435fbe4bf21f49c0a9557c4d5cad670c', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 5302, 2, N'MISSOURI ', N'METROPOLITAN KANSAS CITY', N'CLAY, JACKSON AND PLATTE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'43891f58b8e84d82bed362664b2db0aa', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 10202, 99, N'GEORGIA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4398639dfea744b680932a463aab2587', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 6202, 0, N'MINNESOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'43fe1914ffff42d9a1912025a7f65f38', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 7302, 0, N'MISSISSIPPI ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'441a81ba0d7141d891c5ecf8ed58a6cd', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 3202, 1, N'MONTANA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'44819c4e48884aa79149d3bc226654d8', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 2202, 0, N'IDAHO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'44cad92a6194412d8d2c8476e38593dd', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 14102, 99, N'MAINE ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'451b86730a434fb49267acd1eae955e7', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 630, 0, N'INDIANA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4806bd0b7d0d485eaf83dd592a06efb1', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 9202, 50, N'VIRGIN ISLANDS ', N'VIRGIN ISLANDS ', N'ALL COUNTY EQUIVALENTS')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'48bfa2c4aef94697b7b49b8d513d44fd', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 14302, 40, N'NEW HAMPSHIRE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'48c401a1ba9e431e9f853e8df5ef4079', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 1192, 18, N'CALIFORNIA ', N'LOS ANGELES', N'LOS ANGELES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4909a6100cf0427c8c0b18962c7bc42d', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 5202, 0, N'KANSAS ', N'STATEWIDE* ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'49813129e77141a78617a1390f463fab', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 9102, 4, N'FLORIDA ', N'MIAMI', N'DADE AND MONROE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'49839bc7c49f47a7b1adde194f3d30c3', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 4412, 9, N'TEXAS ', N'BRAZORIA', N'BRAZORIA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'49a509613d9948e9b8b2b0a0d640f43a', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 4412, 9, N'TEXAS ', N'BRAZORIA', N'BRAZORIA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4a67f826f7a842098104715a1fab4e60', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 7202, 1, N'LOUISIANA ', N'NEW ORLEANS', N'JEFFERSON, ORLEANS, PLAQUEMINES AND ST. BERNARD')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4a6ef1465c714c2f89ed6178775934ef', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 2102, 1, N'ALASKA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4a90275dfe464567b5ab990d5c82322b', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 512, 0, N'MISSISSIPPI ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4ad78134e91f4380a0e0f1aad198ab4a', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 1182, 99, N'CALIFORNIA ', N'REST OF STATE*', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4b49bf7e2d334be2bd7fbbbc9997c146', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 4202, 5, N'NEW MEXICO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4b9bb586ee5e4c94a1ef0e1f5c03d92e', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 952, 15, N'ILLINOIS ', N'SUBURBAN CHICAGO', N'DUPAGE, KANE, LAKE AND WILL')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4beb21cf16a0441ea4537f01484551c0', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 12302, 1, N'MARYLAND ', N'BALTIMORE/SURR. CNTYS', N'ANNE ARUNDEL, BALTIMORE, BALTIMORE CITY, CARROLL, HARFORD AND HOWARD')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4c69fa826b0341eca42a5fe7c7ed70cf', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 9102, 4, N'FLORIDA ', N'MIAMI', N'DADE AND MONROE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4c7e4cbae83143cfb41a47c674f52bd3', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 2102, 1, N'ALASKA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4c9217902c0e432885b21117d3e347ff', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 2202, 0, N'IDAHO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4dce9572f3e54fd69e864b930dd26497', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 952, 12, N'ILLINOIS ', N'EAST ST. LOUIS', N'BOND, CALHOUN, CLINTON, JERSEY, MACOUPIN, MADISON, MONROE, MONTGOMERY, RANDOLPH, ST. CLAIR AND WASHINGTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4e35ba46a8f040e78ff2c62948ab8714', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 4412, 11, N'TEXAS ', N'DALLAS', N'DALLAS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4e61965f5e4a436ab352f416ae6dcb1d', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 951, 0, N'WISCONSIN ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4e6242ba5e974eb98e5a864cc51f042d', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 4402, 99, N'TEXAS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4efbe57bcdd5457b94a913bc9f2e7566', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 2402, 2, N'WASHINGTON ', N'SEATTLE (KING CNTY)', N'KING ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'4fa6c2902ca94d03a9bcd710f6622006', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 3602, 21, N'WYOMING ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'50336cd2917d48909f2712bd1ded61c3', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 11402, 16, N'WEST VIRGINIA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'50d2fc0b3df24312a40424ac2fdae642', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 9102, 4, N'FLORIDA ', N'MIAMI', N'DADE AND MONROE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'516becd9b0854dd4b08f2418c67cee7b', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 9202, 50, N'VIRGIN ISLANDS ', N'VIRGIN ISLANDS ', N'ALL COUNTY EQUIVALENTS')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'517fdc7483cd40ab8b6d85cfca29945b', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 1102, 7, N'CALIFORNIA ', N'OAKLAND/BERKLEY', N'ALAMEDA AND CONTRA COSTA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'51c8eb32adbf417ca17dce09836689b6', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 1102, 9, N'CALIFORNIA ', N'SANTA CLARA', N'SANTA CLARA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5219aa184e1c4d38b1209c5484d1c82e', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 10202, 1, N'GEORGIA ', N'ATLANTA', N'BUTTS, CHEROKEE, CLAYTON, COBB, DEKALB, DOUGLAS, FAYETTE, FORSYTH, FULTON, GWINNETT, HENRY, NEWTON, PAULDING, ROCKDALE AND WALTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'52427810aab64d1ca8b19829436d41a4', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 8202, 99, N'MICHIGAN ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'52f9795117564e36b413c5e4616a44dd', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 9202, 50, N'VIRGIN ISLANDS ', N'VIRGIN ISLANDS ', N'ALL COUNTY EQUIVALENTS')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'531c74ef1b72490784fa85bec98229a3', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 4412, 28, N'TEXAS ', N'FORT WORTH', N'TARRANT ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'535d541cd13342efb0740e36ca47e3bb', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 11502, 0, N'NORTH CAROLINA ', N'STATEWIDE ', N'ALL COUNTIES ')
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'53d99d7e06e941228d44ef156b9c7c41', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 1192, 18, N'CALIFORNIA ', N'LOS ANGELES', N'LOS ANGELES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'549f6947b142426086485825b1815b95', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 8102, 0, N'INDIANA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'54d904e0b1ee450a9c2bbcba30241218', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 7202, 99, N'LOUISIANA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'54da2dd2aa44409dab08a59b1143a75d', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 12302, 1, N'MARYLAND ', N'BALTIMORE/SURR. CNTYS', N'ANNE ARUNDEL, BALTIMORE, BALTIMORE CITY, CARROLL, HARFORD AND HOWARD')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'54db7c8353ba4a14a12ab7880a00b839', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 3402, 2, N'SOUTH DAKOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'554b70229b1e457abb51de22d4ac3139', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 951, 0, N'WISCONSIN ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'55cb60bed4bb4380bdc8d7609e2d3e7e', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 12302, 99, N'MARYLAND ', N'REST OF STATE ', N'ALL OTHER COUNTIES EXCEPT MONTGOMERY AND PRINCE GEORGES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'55e76dc3eefd49ed999c0d2dd7580ffb', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 13202, 2, N'NEW YORK ', N'NYC SUBURBS/LONG ISLAND', N'BRONX, KINGS, NASSAU, RICHMOND, ROCKLAND, SUFFOLK AND WESTCHESTER')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'56d6c49261584da0b82d89f44314cff1', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 512, 0, N'MISSISSIPPI ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'571e0da936ee49469b15c6bea999b4d9', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 12402, 1, N'NEW JERSEY ', N'NORTHERN NJ ', N'BERGEN, ESSEX, HUDSON, HUNTERDON, MIDDLESEX, MORRIS, PASSAIC, SOMERSET, SUSSEX, UNION AND WARREN')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'574e43d065a740058cddcda0749407fc', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 2302, 99, N'OREGON ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5753c39a37da459e90e9ab889354f1e7', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 12402, 1, N'NEW JERSEY ', N'NORTHERN NJ ', N'BERGEN, ESSEX, HUDSON, HUNTERDON, MIDDLESEX, MORRIS, PASSAIC, SOMERSET, SUSSEX, UNION AND WARREN')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5756b63b69bd4c019c1082f4dd907dee', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 4202, 5, N'NEW MEXICO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'585dbddda21a4ae5876ef362f2e9185e', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 7202, 99, N'LOUISIANA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'586749b6736048979d6e561fba76d23f', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 1192, 99, N'CALIFORNIA ', N'REST OF STATE*', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5895f2311b1d48c3a12773f9769dbbe6', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 6102, 99, N'ILLINOIS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'59b7292c3222450780aa76b1b0c5dbdf', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 14102, 3, N'MAINE ', N'SOUTHERN MAINE ', N'CUMBERLAND AND YORK')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5a624d1b5762432d92756971205d47fe', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 8202, 1, N'MICHIGAN ', N'DETROIT', N'MACOMB, OAKLAND, WASHTENAW AND WAYNE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5a7e37f19d804fa28c59826e4e8e1f9d', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 9202, 20, N'PUERTO RICO ', N'PUERTO RICO', N'ALL COUNTY EQUIVALENTS')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5ae86c8eea6941c78e0288fc7e98b1b2', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 13282, 99, N'NEW YORK ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5b438f38a10f45ff828bfee087bffa92', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 14102, 3, N'MAINE ', N'SOUTHERN MAINE ', N'CUMBERLAND AND YORK')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5b49e47194fc453d9eda8075a78c4464', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 13202, 2, N'NEW YORK ', N'NYC SUBURBS/LONG ISLAND', N'BRONX, KINGS, NASSAU, RICHMOND, ROCKLAND, SUFFOLK AND WESTCHESTER')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5b71c34e22d04a1ca9f9bdca0a50ccdc', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 9202, 50, N'VIRGIN ISLANDS ', N'VIRGIN ISLANDS ', N'ALL COUNTY EQUIVALENTS')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5ba2e821f557450781affae6f416435b', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 3302, 1, N'NORTH DAKOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5bd7134c767d4dee8bdaa47d857058de', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 14302, 40, N'NEW HAMPSHIRE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5c05c4d10aa8488cab7f13936796db26', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 5102, 0, N'IOWA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5c5e0879adf24e97bcdf4fb8a70bf259', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 2402, 2, N'WASHINGTON ', N'SEATTLE (KING CNTY)', N'KING ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5d298b288375408bbe65bc3ad5b142fb', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 4412, 11, N'TEXAS ', N'DALLAS', N'DALLAS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5d3216f79e634e9dbbe816e757d239e9', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 7202, 99, N'LOUISIANA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5d426e4a267b4b029c8a47eb9f095786', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 4412, 11, N'TEXAS', N'DALLAS', N'DALLAS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5d48e381b0e240d0ab509b25e374fa1e', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 15102, 0, N'KENTUCKY ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5eac14e1a0e346c69e4f9d470a482778', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 5302, 2, N'MISSOURI ', N'METROPOLITAN KANSAS CITY', N'CLAY, JACKSON AND PLATTE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5edb8b47c14b4edeb4e96459f91a025c', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 4412, 31, N'TEXAS ', N'AUSTIN', N'TRAVIS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5f0470eb735f4f1daf0ed9d65db1f94a', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 11502, 0, N'NORTH CAROLINA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5f7850c97e2144a48c6b65b14e9795c4', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 14202, 1, N'MASSACHUSETTS ', N'METROPOLITAN BOSTON ', N'MIDDLESEX, NORFOLK AND SUFFOLK')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5fcb9de904424f7995d23aea11342b82', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 2402, 2, N'WASHINGTON ', N'SEATTLE (KING CNTY)', N'KING ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'5ff746adb74f4af2a4fe77bf0556514d', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), 1112, 6, N'CALIFORNIA ', N'SAN MATEO', N'SAN MATEO ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'60245e079b144f41944cdf305de487e6', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 1302, 0, N'NEVADA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'60735bf6a510499c8a40dee34f00fe87', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 4402, 99, N'TEXAS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'60a0ade76f96486c984e6aac625c0faa', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 4412, 31, N'TEXAS ', N'AUSTIN', N'TRAVIS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'610352a92d0a4e40915c5c1edceadcca', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 9102, 4, N'FLORIDA ', N'MIAMI', N'DADE AND MONROE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'6110a23871de48dabceeda96419dbbdb', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 1102, 5, N'CALIFORNIA ', N'SAN FRANCISCO', N'SAN FRANCISCO ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'611dec6455d34ac89cca99f11cf4fde3', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), 10202, 1, N'GEORGIA ', N'ATLANTA', N'BUTTS, CHEROKEE, CLAYTON, COBB, DEKALB, DOUGLAS, FAYETTE, FORSYTH, FULTON, GWINNETT, HENRY, NEWTON, PAULDING, ROCKDALE AND WALTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'618fb029ebfa412ebb8b0bf374a122cb', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 954, 0, N'MINNESOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'62113ad159e84a449061e3ae744e19da', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 14512, 50, N'VERMONT ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'6235e05000b4436385f20bd65ad5ef0e', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 1102, 7, N'CALIFORNIA ', N'OAKLAND/BERKLEY', N'ALAMEDA AND CONTRA COSTA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'625cea1b03924612b94ca83d74b3f928', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 4402, 31, N'TEXAS ', N'AUSTIN', N'TRAVIS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'62fd385781c04ac9b51d1bfc44a51d60', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 8102, 0, N'INDIANA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'6383f437e244427a82596cc34cfffeb6', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 7202, 1, N'LOUISIANA ', N'NEW ORLEANS', N'JEFFERSON, ORLEANS, PLAQUEMINES AND ST. BERNARD')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'645b5c59288e439fa4058e797ea2df3c', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 14102, 3, N'MAINE ', N'SOUTHERN MAINE ', N'CUMBERLAND AND YORK')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'64637140f3e54750af060a322261d7ac', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 12402, 99, N'NEW JERSEY ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'65030cafd2d24a3783d5fe51aa2d42f3', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 7202, 1, N'LOUISIANA ', N'NEW ORLEANS', N'JEFFERSON, ORLEANS, PLAQUEMINES AND ST. BERNARD')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'656193006c5f4531888f930b6175a075', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 1102, 5, N'CALIFORNIA ', N'SAN FRANCISCO', N'SAN FRANCISCO ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'6574f3634b8f4852b028fafc0d11b47c', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 952, 12, N'ILLINOIS ', N'EAST ST. LOUIS', N'BOND, CALHOUN, CLINTON, JERSEY, MACOUPIN, MADISON, MONROE, MONTGOMERY, RANDOLPH, ST. CLAIR AND WASHINGTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'657e951f77374abeb43bad0af155b0ba', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 952, 12, N'ILLINOIS ', N'EAST ST. LOUIS', N'BOND, CALHOUN, CLINTON, JERSEY, MACOUPIN, MADISON, MONROE, MONTGOMERY, RANDOLPH, ST. CLAIR AND WASHINGTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'65bc444be1af49d48b2810c81f4d97a8', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 4412, 28, N'TEXAS ', N'FORT WORTH', N'TARRANT ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'65f19563a6b74d53b24b9b6a4c2865a7', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 4212, 5, N'NEW MEXICO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'66917aa33e9943a7b89f5928e18ed351', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 4412, 15, N'TEXAS ', N'GALVESTON', N'GALVESTON ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'66deedfc3de84335bac8de24506c2b05', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 5402, 0, N'NEBRASKA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'6712415e94d245b69d99d430860f7ade', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 12302, 1, N'MARYLAND ', N'BALTIMORE/SURR. CNTYS', N'ANNE ARUNDEL, BALTIMORE, BALTIMORE CITY, CARROLL, HARFORD AND HOWARD')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'67929b66a6204bbaaaf1744013e57132', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 2302, 99, N'OREGON ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'67d9afda2c064a1c83570c7be7a75b2b', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 1192, 17, N'CALIFORNIA ', N'VENTURA', N'VENTURA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'67dfaa838c574baebf06f621b38ce452', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 14502, 50, N'VERMONT ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'68139413c6ca406b88131c936535500a', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 13202, 3, N'NEW YORK ', N'POUGHKPSIE/N NYC SUBURBS', N'COLUMBIA, DELAWARE, DUTCHESS, GREENE, ORANGE, PUTNAM, SULLIVAN AND ULSTER')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'68d96e5925c041dd94b2bd00da5fec89', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 3202, 1, N'MONTANA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'698eb57af5854f5aa684cb5b6dfdfec1', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 12502, 1, N'PENNSYLVANIA ', N'METROPOLITAN PHILADELPHIA', N'BUCKS, CHESTER, DELAWARE, MONTGOMERY AND PHILADELPHIA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'6b13ce7ed8304bdc99aa00b09e1675ec', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 3502, 9, N'UTAH ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'6b4e361c68dc4dfc96fc1d2e5662bdcf', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 1102, 3, N'CALIFORNIA ', N'MARIN/NAPA/SOLANO', N'MARIN, NAPA, AND SOLANO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'6bd487e7640149f79517e9f494d9f292', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 4402, 31, N'TEXAS ', N'AUSTIN', N'TRAVIS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'6c39c3fadb294f1eb0212a6786987e0a', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 10202, 99, N'GEORGIA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'6d088da5b1604e82b41ec70cca5b958e', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 3102, 0, N'ARIZONA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'6da7fe3fc7134d78a2393f0bb1b93d11', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2016-12-31T23:59:00.000' AS DateTime), 1182, 17, N'CALIFORNIA ', N'VENTURA', N'VENTURA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'6dcc3763584145d6b62c9de8e9dc64d1', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 4412, 99, N'TEXAS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'6e8c8dea52064edda9db6710e803d433', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 3202, 1, N'MONTANA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'6f40a396109d4a0798d7a4d44aa9b672', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 11202, 1, N'SOUTH CAROLINA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7011fe5ee726445bb7f7896329c2f4ba', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 3102, 0, N'ARIZONA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'708a900d280640638b53d3d79686f8ac', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 9102, 4, N'FLORIDA ', N'MIAMI', N'DADE AND MONROE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'70dbc552eb024609a90cd4399457297f', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 2102, 1, N'ALASKA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'70fd304b701d44aebd3a2c372439843a', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 4402, 18, N'TEXAS ', N'HOUSTON', N'HARRIS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7119fdf052a3457bb1cdc30a15f95b51', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 14402, 1, N'RHODE ISLAND ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'71bed9a9254640cea78d0754e35e2b15', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 4402, 15, N'TEXAS ', N'GALVESTON', N'GALVESTON ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'71e0f332ddae4bd4bb562f7b34e29ac9', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 5202, 0, N'KANSAS ', N'STATEWIDE* ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'71f40ad0ffd64370997781bc2f0fe15f', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 4412, 28, N'TEXAS ', N'FORT WORTH', N'TARRANT ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'71f6cdc048254e6296736707b7ede817', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 835, 1, N'OREGON ', N'PORTLAND', N'CLACKAMAS, MULTNOMAH AND WASHINGTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'721012b0acbc4c8da7f5ed140ef47ed0', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 14502, 50, N'VERMONT ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7240a92ef71545cd9de14e964d267ef5', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 3402, 2, N'SOUTH DAKOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'72764e7815c74c4689767df405890ba8', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 1202, 1, N'HAWAII/GUAM', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7376bde270ca478aa163cc767df75a43', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 5302, 2, N'MISSOURI ', N'METROPOLITAN KANSAS CITY', N'CLAY, JACKSON AND PLATTE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'738b0af0130b4ac59772d1541971b10f', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 1102, 3, N'CALIFORNIA ', N'MARIN/NAPA/SOLANO', N'MARIN, NAPA, AND SOLANO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7428914f21e242009337f71c4df2baa5', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 2302, 1, N'OREGON ', N'PORTLAND', N'CLACKAMAS, MULTNOMAH AND WASHINGTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'744f0fcf54e64eca8eda423995c85d75', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 14502, 50, N'VERMONT ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'74b71385a75a4cb8901898b2d12b4446', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 1102, 7, N'CALIFORNIA ', N'OAKLAND/BERKLEY', N'ALAMEDA AND CONTRA COSTA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'750ace5b68f74f80be23ae04561c356d', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 11402, 16, N'WEST VIRGINIA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7516a7fca68e4785b366f2faf303a421', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 4302, 0, N'OKLAHOMA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'760267e8773847b198e4ebe38aff5df5', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 1102, 99, N'CALIFORNIA ', N'REST OF STATE*', N'ALL OTHER COUNTIES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'76cd55b98c0841efa0ec3f003f5dbf8a', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 1102, 7, N'CALIFORNIA ', N'OAKLAND/BERKLEY', N'ALAMEDA AND CONTRA COSTA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'770d722188774b4c901dc45d13150641', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 9102, 99, N'FLORIDA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7735ab7b670341c2bf31a3ff55289d21', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 15202, 0, N'OHIO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'795c95e7566c4fc69d9bae99b8ae2920', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 4302, 0, N'OKLAHOMA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'79cbe864a07846c4ac11e43fec91e220', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 12402, 1, N'NEW JERSEY ', N'NORTHERN NJ ', N'BERGEN, ESSEX, HUDSON, HUNTERDON, MIDDLESEX, MORRIS, PASSAIC, SOMERSET, SUSSEX, UNION AND WARREN')
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7a41491ed41647a2a03c855ecfaed840', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 520, 13, N'ARKANSAS ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7a9cb8b801cf4528928d5e4e03ff5804', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 831, 1, N'ALASKA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7aff17d3661a42d5959988c4d30606d8', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 10202, 1, N'GEORGIA ', N'ATLANTA', N'BUTTS, CHEROKEE, CLAYTON, COBB, DEKALB, DOUGLAS, FAYETTE, FORSYTH, FULTON, GWINNETT, HENRY, NEWTON, PAULDING, ROCKDALE AND WALTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7bb0053a654c4e83a4ccf5893b27a644', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 1302, 0, N'NEVADA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7bb48c7264394b04820a0ba9abaf67aa', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 1102, 99, N'CALIFORNIA ', N'REST OF STATE*', N'ALL OTHER COUNTIES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7c18e7dd12e0482c99aa8ebdfe6232c0', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 5402, 0, N'NEBRASKA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7c1d41c666434fdba1e3502f2df82655', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 11302, 0, N'VIRGINIA', N'STATEWIDE', N'ALL COUNTIES, EXCEPT ALEXANDRIA CITY, ARLINGTON, FAIRFAX, FAIRFAX CITY, AND FALLS CHURCH CITY')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7cc3fba0522c44168e10984ee06ab420', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 1102, 99, N'CALIFORNIA ', N'REST OF STATE*', N'ALL OTHER COUNTIES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7cd403aa24e843f78794c3848cdf515f', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 4102, 1, N'COLORADO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7d15b894226e4da0adfd4c85fa52d999', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 835, 99, N'OREGON ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7d3eeabd71224e1b9fbad399c570bdd3', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 13102, 0, N'CONNECTICUT ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7d5cb14a303c47dc8af60c942c60dcfa', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 9102, 99, N'FLORIDA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7e104bbff2dc45ac9b700976fbe304c8', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 9102, 3, N'FLORIDA ', N'FORT LAUDERDALE', N'BROWARD, COLLIER, INDIAN RIVER, LEE, MARTIN, PALM BEACH, AND ST. LUCIE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7eb7cf432984486fa5b9fb5c5ef97fac', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 952, 99, N'ILLINOIS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7ed63cc2c39646fe8cfffd130b6b3408', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 12102, 1, N'DELAWARE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7f31813c2dc84868a184463e676daf53', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 15202, 0, N'OHIO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7f5262b8d31c42f398891632db18e619', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 1102, 3, N'CALIFORNIA ', N'MARIN/NAPA/SOLANO', N'MARIN, NAPA, AND SOLANO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'7fadb1a7220241d5881442b0db3a6a7a', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 5302, 1, N'MISSOURI ', N'METROPOLITAN ST. LOUIS', N'JEFFERSON, ST. CHARLES, ST. LOUIS AND ST. LOUIS CITY')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'80aa7ad571df48b3a40191b58221960e', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 14302, 40, N'NEW HAMPSHIRE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'81618442bbb448e19d207b178ed06b1b', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 14302, 40, N'NEW HAMPSHIRE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8173f61bf069485da662838fb4e0eebe', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 952, 99, N'ILLINOIS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'81bd13599900434d90f8376ece31b6d4', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 1112, 6, N'CALIFORNIA ', N'SAN MATEO', N'SAN MATEO ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'81bf9dae7e6c474a90a6d230b63296ac', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 12202, 1, N'DISTRICT OF COLUMBIA ', N'DC MD/VA SUBURBS', N'DISTRICT OF COLUMBIA; ALEXANDRIA CITY, ARLINGTON, FAIRFAX, FAIRFAX CITY, FALLS CHURCH CITY IN VIRGINIA; MONTGOMERY AND PRINCE GEORGES IN MARYLAND')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'81e54312294e4f7dbb1223a94458faa2', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 9202, 20, N'PUERTO RICO ', N'PUERTO RICO', N'ALL COUNTY EQUIVALENTS')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8265601feaee4a34a8f283813899717c', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 3402, 2, N'SOUTH DAKOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'82d911a3eac145daaa9dc28b115ba2f1', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 10202, 99, N'GEORGIA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'82de6d65ecdf438faa933535043c9d89', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 3502, 9, N'UTAH ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'82e6e1469b2344c2ae9eda8f2d4b1341', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 952, 16, N'ILLINOIS ', N'CHICAGO', N'COOK ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'830d41b78ee94bc3af56c48cd24d3dda', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 4402, 28, N'TEXAS ', N'FORT WORTH', N'TARRANT ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'831dc9e980f74cb284e769d99ed511bf', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 13102, 0, N'CONNECTICUT ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'83d37fea47f0450d8155b714327b6f42', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 12102, 1, N'DELAWARE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8409799e18374038b0bb9ca0f942a432', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 954, 0, N'MINNESOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'84e8993e355246579b824f45ef1862f0', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 1192, 99, N'CALIFORNIA ', N'REST OF STATE*', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'85e2619f98eb4deca7111c3dd9827bec', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 10102, 0, N'ALABAMA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'861063dcae944067b1fad0c08733ac15', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 14102, 99, N'MAINE ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'86c5334608404157a2ece88ec8779bf0', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 1192, 99, N'CALIFORNIA ', N'REST OF STATE*', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'873b3c6e922e4a76bd9eefde60ba7b7b', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 1112, 99, N'CALIFORNIA ', N'REST OF STATE*', N'ALL OTHER COUNTIES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'87db7615e4bb4a63a54090ce4c5e8074', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 1192, 26, N'CALIFORNIA ', N'ANAHEIM/SANTA ANA', N'ORANGE ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'88fb5c659a8a48d686503bae4463f847', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 10102, 0, N'ALABAMA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8951a080c62e42228951d44d97839b65', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 4412, 31, N'TEXAS ', N'AUSTIN', N'TRAVIS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'895dc029c08440d1878ddc52786e93bc', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 1102, 6, N'CALIFORNIA ', N'SAN MATEO', N'SAN MATEO ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8abbedb582834f2ab18d963337fe00cd', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 1102, 9, N'CALIFORNIA ', N'SANTA CLARA', N'SANTA CLARA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8add79bdd81646b3a26ee2e58d1c35a2', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 11402, 16, N'WEST VIRGINIA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8b69411cc7d949e18e04248123bc0854', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 1112, 3, N'CALIFORNIA ', N'MARIN/NAPA/SOLANO', N'MARIN, NAPA, AND SOLANO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8bd13fab71f44e6d8b2c2f601b7ca938', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 13202, 1, N'NEW YORK ', N'MANHATTAN', N'NEW YORK ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8bf8aa2b0204431bb1b4af713396f4c5', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 3102, 0, N'ARIZONA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8c79c6467d374e62a5f1b347bb3a0a87', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 952, 16, N'ILLINOIS ', N'CHICAGO', N'COOK ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8d527159c9ea457dbc98cbe2a5d5b376', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 9202, 20, N'PUERTO RICO ', N'PUERTO RICO', N'ALL COUNTY EQUIVALENTS')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8d931494ea4a4819a4ebf22790f50a37', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 11402, 16, N'WEST VIRGINIA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8e51384ae786491cb56f4ee1022cead9', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 5102, 0, N'IOWA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8ec27b2d5a5645ab8f25a577fa74a6f0', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 3302, 1, N'NORTH DAKOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8f46ea6eecca41f2a8b070890cd84f2d', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 12202, 1, N'DISTRICT OF COLUMBIA ', N'DC MD/VA SUBURBS', N'DISTRICT OF COLUMBIA; ALEXANDRIA CITY, ARLINGTON, FAIRFAX, FAIRFAX CITY, FALLS CHURCH CITY IN VIRGINIA; MONTGOMERY AND PRINCE GEORGES IN MARYLAND')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8f7220a19cd24a66b585684fbd3d3858', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 3502, 9, N'UTAH ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8f7c0536f92b45398d1693f4a41c5221', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 13102, 0, N'CONNECTICUT ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8fb139946062464abde5f9d566587d6c', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 2402, 2, N'WASHINGTON ', N'SEATTLE (KING CNTY)', N'KING ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8fb1ab9cce1348518225e5a92933ecdf', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 3402, 2, N'SOUTH DAKOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'8ff68df81008406788bc6738afdbb8ef', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 14402, 1, N'RHODE ISLAND ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9001be27809a4ff6912056c47b3ebeef', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 15202, 0, N'OHIO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'907f98780536436e9b9104d0ad44c448', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 13202, 1, N'NEW YORK ', N'MANHATTAN', N'NEW YORK ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9104350e23e743d09c3057968a3f99f1', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 2302, 1, N'OREGON ', N'PORTLAND', N'CLACKAMAS, MULTNOMAH AND WASHINGTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9157365a92fd43f1a38f816136cde310', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 9202, 50, N'VIRGIN ISLANDS ', N'VIRGIN ISLANDS ', N'ALL COUNTY EQUIVALENTS')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9197dbe7f230480687c01aec46c27fc3', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 4412, 20, N'TEXAS ', N'BEAUMONT', N'JEFFERSON ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'91d7471cd5e749c686a63cf32b74dd0e', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 954, 0, N'MINNESOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'922a89c882824a5faf0002af5d4f4afe', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 14102, 3, N'MAINE ', N'SOUTHERN MAINE ', N'CUMBERLAND AND YORK')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'92a155b407d040b7834cfa8fcdd4b6f1', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 2302, 1, N'OREGON ', N'PORTLAND', N'CLACKAMAS, MULTNOMAH AND WASHINGTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'92d87d11b5ac47a487509fac54fc4299', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 7202, 99, N'LOUISIANA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9460e3d197b24b7c8440c94384ecb377', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 3202, 1, N'MONTANA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9470da0076094d4c906da1e82ec81909', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 12302, 1, N'MARYLAND ', N'BALTIMORE/SURR. CNTYS', N'ANNE ARUNDEL, BALTIMORE, BALTIMORE CITY, CARROLL, HARFORD AND HOWARD')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'953a05fc458145b1be002d44485f596a', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 952, 15, N'ILLINOIS ', N'SUBURBAN CHICAGO', N'DUPAGE, KANE, LAKE AND WILL')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'955206cf6660419bb74bd63616ae5705', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 10202, 1, N'GEORGIA ', N'ATLANTA', N'BUTTS, CHEROKEE, CLAYTON, COBB, DEKALB, DOUGLAS, FAYETTE, FORSYTH, FULTON, GWINNETT, HENRY, NEWTON, PAULDING, ROCKDALE AND WALTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'95872bbf17484331bc7d9cb487dc0348', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 1202, 1, N'HAWAII/GUAM', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'96331fd1922d41a7b6dbdffa14e7b734', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 10112, 0, N'ALABAMA', N'STATEWIDE', N'ALL COUNTIES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'96331fd1922d41a7b6dbdffa14e7b735', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 63, N'CALIFORNIA', N'SACRAMENTO-ROSEVILLE-FOLSOM', N'SACRAMENTO, PLACER, YOLO, EL DORADO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'96331fd1922d41a7b6dbdffa14e7b736', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1182, 72, N'CALIFORNIA', N'SAN DIEGO-CHULA VISTA-CARLSBAD', N'SAN DIEGO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'96331fd1922d41a7b6dbdffa14e7b737', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), 1112, 7, N'CALIFORNIA', N'SAN FRANCISCO-OAKLAND-BERKELEY (ALAMEDA/CONTRA COSTA CNTY)', N'ALAMEDA AND CONTRA COSTA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'96331fd1922d41a7b6dbdffa14e7b738', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 52, N'CALIFORNIA', N'SAN FRANCISCO-OAKLAND-BERKELEY (MARIN CNTY)', N'MARIN')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'96331fd1922d41a7b6dbdffa14e7b739', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), 1112, 5, N'CALIFORNIA', N'SAN FRANCISCO-OAKLAND-BERKELEY (SAN FRANCISCO CNTY)', N'SAN FRANCISCO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'96331fd1922d41a7b6dbdffa14e7b740', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), 1112, 6, N'CALIFORNIA', N'SAN FRANCISCO-OAKLAND-BERKELEY (SAN MATEO CNTY)', N'SAN MATEO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'96331fd1922d41a7b6dbdffa14e7b741', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 9, N'CALIFORNIA', N'SAN JOSE-SUNNYVALE-SANTA CLARA (SANTA CLARA CNTY)', N'SANTA CLARA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'96331fd1922d41a7b6dbdffa14e7b742', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1182, 73, N'CALIFORNIA', N'SAN LUIS OBISPO-PASO ROBLES', N'SAN LUIS OBISPO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'96331fd1922d41a7b6dbdffa14e7b743', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 67, N'CALIFORNIA', N'SANTA ROSA-PETALUMA', N'SONOMA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'96331fd1922d41a7b6dbdffa14e7b744', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 68, N'CALIFORNIA', N'STOCKTON', N'SAN JOAQUIN')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'96331fd1922d41a7b6dbdffa14e7b745', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 53, N'CALIFORNIA', N'VALLEJO', N'SOLANO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'96331fd1922d41a7b6dbdffa14e7b746', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 69, N'CALIFORNIA', N'VISALIA', N'TULARE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'96331fd1922d41a7b6dbdffa14e7b747', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 10212, 1, N'GEORGIA', N'ATLANTA', N'BUTTS, CHEROKEE, CLAYTON, COBB, DEKALB, DOUGLAS, FAYETTE, FORSYTH, FULTON, GWINNETT, HENRY, NEWTON, PAULDING, ROCKDALE AND WALTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'96331fd1922d41a7b6dbdffa14e7b748', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 10212, 99, N'GEORGIA', N'REST OF STATE', N'ALL OTHER COUNTIES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'96331fd1922d41a7b6dbdffa14e7b749', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 10312, 35, N'TENNESSEE', N'STATEWIDE', N'ALL COUNTIES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'966c10c284e549b4ae7234b4bf17bc5f', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 3602, 21, N'WYOMING ', N'STATEWIDE ', N'')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'96992c1138214c1498dc0f4edfb3cc5d', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 6102, 16, N'ILLINOIS ', N'CHICAGO', N'COOK ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9762d2acf63d4ad7b92277f15ab2dfdb', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 10302, 35, N'TENNESSEE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'979abd31f8b844df9e524dda5b341ec7', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 4402, 20, N'TEXAS ', N'BEAUMONT', N'JEFFERSON ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'979ea2ede21b489da962e17e7eb1bd8a', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 2102, 1, N'ALASKA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'97a94252c74a40e9b29ed04e79d23999', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 904, 0, N'VIRGINIA', N'STATEWIDE', N'ALL COUNTIES, EXCEPT ALEXANDRIA CITY, ARLINGTON, FAIRFAX, FAIRFAX CITY, AND FALLS CHURCH CITY')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'97cc3175104a48cab329bbbd1e635b2b', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 1192, 18, N'CALIFORNIA ', N'LOS ANGELES', N'LOS ANGELES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'97d411a337594ee5acec4d434db07a70', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 952, 12, N'ILLINOIS ', N'EAST ST. LOUIS', N'BOND, CALHOUN, CLINTON, JERSEY, MACOUPIN, MADISON, MONROE, MONTGOMERY, RANDOLPH, ST. CLAIR AND WASHINGTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'98df3f223e424b7ea2e5761a7338e358', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 952, 99, N'ILLINOIS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'98dfeaf0bf3e40b7a9074c3c26033669', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 13292, 4, N'NEW YORK ', N'QUEENS', N'QUEENS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'998cdb3eaaa24728ad8159d73ae91dac', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 3302, 1, N'NORTH DAKOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9a13a6b62498416e9afc7b08f5e754c9', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 4412, 18, N'TEXAS ', N'HOUSTON', N'HARRIS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9adf6b22305b4ceca078b6381a5a3709', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 3302, 1, N'NORTH DAKOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9afb8afa0eae442da864a7bbea71628b', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 8202, 1, N'MICHIGAN ', N'DETROIT', N'MACOMB, OAKLAND, WASHTENAW AND WAYNE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9b4d4810a99b41fa91d6a17497ac34f5', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 5202, 0, N'KANSAS ', N'STATEWIDE* ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9c31b166c0924b299520d9be3b4cf9f1', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 8202, 99, N'MICHIGAN ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9c47a990524a4c5da181353ee468ccc1', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 7102, 13, N'ARKANSAS ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9c5e9ab5778045b0a2762e757933d73c', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 5402, 0, N'NEBRASKA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9d02e856ecdf4f67a5f3b4fb6eeb2c8c', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 12502, 99, N'PENNSYLVANIA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9d2b812ae88b4e9e9968ea300c443e1f', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 5102, 0, N'IOWA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9daa25799cef44869beefbac2e2daa69', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 5102, 0, N'IOWA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9e2e5c30eb704016bfc8f5d5d5f182ef', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 4412, 18, N'TEXAS ', N'HOUSTON', N'HARRIS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9e8a31baec234fcb8b6de659bd85a7c5', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 14102, 99, N'MAINE ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9f0fa5617aaf489c969b0ed9314ac411', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 8102, 0, N'INDIANA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9f38265a079c425698183a3e4fb5e50b', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 12302, 99, N'MARYLAND ', N'REST OF STATE ', N'ALL OTHER COUNTIES EXCEPT MONTGOMERY AND PRINCE GEORGES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9f8cb6a72cc14ff9bf560fd43ad2c262', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 13282, 99, N'NEW YORK ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'9ff2b24d4c4c4f509d5fddd01dd42f69', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 12302, 99, N'MARYLAND ', N'REST OF STATE ', N'ALL OTHER COUNTIES EXCEPT MONTGOMERY AND PRINCE GEORGES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a00acc2462d94efda6a9272e50662831', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 3502, 9, N'UTAH ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a05be009febe4aba9696ff5402dbf1d8', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 4412, 18, N'TEXAS ', N'HOUSTON', N'HARRIS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a0caee8d7b214017879ac98e9fc4d8b3', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 4312, 0, N'OKLAHOMA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a0eadfa9ecda4d1e98e34c095c076cec', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 10102, 0, N'ALABAMA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a0fb16d06a894035829c940931978f93', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 2302, 99, N'OREGON ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a14fc1d0213f49f5b58f17eefd821c73', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 5535, 0, N'NORTH CAROLINA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a1813ac82e404bbbb299bc1ed97e2971', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 1202, 1, N'HAWAII/GUAM', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a227b9f221fa424380a8e6f78c367f4e', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 12502, 99, N'PENNSYLVANIA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a2a3a3d6c4d64ba9bf980d8664d1ea86', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 13202, 1, N'NEW YORK ', N'MANHATTAN', N'NEW YORK ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a2b7201a320f416c9970f9fe4bc5d1d5', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 10202, 1, N'GEORGIA ', N'ATLANTA', N'BUTTS, CHEROKEE, CLAYTON, COBB, DEKALB, DOUGLAS, FAYETTE, FORSYTH, FULTON, GWINNETT, HENRY, NEWTON, PAULDING, ROCKDALE AND WALTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a34edacc61234092b982e02155c0143c', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 11202, 1, N'SOUTH CAROLINA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a3941bf4730f455eb0b4cf4ba10a9e10', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 9202, 50, N'VIRGIN ISLANDS ', N'VIRGIN ISLANDS ', N'ALL COUNTY EQUIVALENTS')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a3f77e1c4b184cc1bd50b19861e3c1ab', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 1102, 9, N'CALIFORNIA ', N'SANTA CLARA', N'SANTA CLARA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a44a0580467b47899532646f675a0d1f', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 4202, 5, N'NEW MEXICO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a568b196eb5c4e21b4d4ce63265cf7e2', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 13202, 1, N'NEW YORK ', N'MANHATTAN', N'NEW YORK ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a5ebbbd569364fb5845ebeb4d1db2c76', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 8102, 0, N'INDIANA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a69bacb9a4c244aaaf3aa0546075a542', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 1182, 18, N'CALIFORNIA ', N'LOS ANGELES', N'LOS ANGELES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a6b8daf85c5343c2bc722523efd41fa7', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 1302, 0, N'NEVADA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a79489c7f5ff4c9cb1b329eb420d5f72', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 13202, 1, N'NEW YORK ', N'MANHATTAN', N'NEW YORK ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a8074f605008468a8988d7aff101b809', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 4112, 1, N'COLORADO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a86911fe8a93457798f4c1bd2b8fb218', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 12502, 99, N'PENNSYLVANIA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a8814b65907841769cac35d1a7f5506d', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 3402, 2, N'SOUTH DAKOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a8dd5ad0679742e4bc52bcd73e83f071', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 2402, 99, N'WASHINGTON ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a8de14b57ef140919d1823e30de257f7', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 880, 1, N'SOUTH CAROLINA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a9012eb84fad43c7b8a72b4631f32e82', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 11202, 1, N'SOUTH CAROLINA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a9200bd987ac4608854d540633ee1403', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 5302, 99, N'MISSOURI ', N'REST OF STATE*', N'ALL OTHER COUNTIES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'a9fbdbe937664bad8a0d00d9160a6c42', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 1102, 7, N'CALIFORNIA ', N'OAKLAND/BERKLEY', N'ALAMEDA AND CONTRA COSTA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'aa02cce696ad4e35ac237b3521776986', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 14402, 1, N'RHODE ISLAND ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ab2a10904e4242da8f1b036151302740', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 6202, 0, N'MINNESOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ab54835cb74845de94d691d018c5f6c8', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 14102, 99, N'MAINE ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ab9304d341ec4f67b5fbd197a6149342', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 6102, 12, N'ILLINOIS ', N'EAST ST. LOUIS', N'BOND, CALHOUN, CLINTON, JERSEY, MACOUPIN, MADISON, MONROE, MONTGOMERY, RANDOLPH, ST. CLAIR AND WASHINGTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ac1a466676594bbd873bbf8018d875a5', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 3102, 0, N'ARIZONA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ac8d54b84be04c47a2a5203f160c5d74', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 9202, 50, N'VIRGIN ISLANDS ', N'VIRGIN ISLANDS ', N'ALL COUNTY EQUIVALENTS')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ae4b822013c94269b2e6de2c42e2200b', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 4412, 18, N'TEXAS ', N'HOUSTON', N'HARRIS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'aeabecf1e42242e19d9a663c57743074', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 2402, 2, N'WASHINGTON ', N'SEATTLE (KING CNTY)', N'KING ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'af151e1b367d4431ba07b9ea85dc7ba0', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 1192, 17, N'CALIFORNIA ', N'VENTURA', N'VENTURA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'af5c4469348540dc881c6fc4e3758530', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 4412, 99, N'TEXAS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b05ef90784644d8a8c90c6442e1ac49a', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 3602, 21, N'WYOMING ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b136ed7ca7934dfe938219ee73a8a738', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 1102, 9, N'CALIFORNIA ', N'SANTA CLARA', N'SANTA CLARA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b198e2cb43bc409087757fd02c9ca4a4', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 2402, 99, N'WASHINGTON ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b1aa6dfa1d534a6fbaa04670f4369dc3', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 1202, 1, N'HAWAII/GUAM', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b1c1e43242f94be284e305be43ce4225', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 952, 15, N'ILLINOIS ', N'SUBURBAN CHICAGO', N'DUPAGE, KANE, LAKE AND WILL')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b2334c65ccbb427fbe6d276de361f19b', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 14202, 99, N'MASSACHUSETTS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b2661c568f034058af769968f079cca8', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 7202, 1, N'LOUISIANA ', N'NEW ORLEANS', N'JEFFERSON, ORLEANS, PLAQUEMINES AND ST. BERNARD')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b27520b1ad4b4fd7948ee95fa66d73ae', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 4112, 1, N'COLORADO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b276561b019e43e79ddc9fd76f56c4fe', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 12502, 1, N'PENNSYLVANIA ', N'METROPOLITAN PHILADELPHIA', N'BUCKS, CHESTER, DELAWARE, MONTGOMERY AND PHILADELPHIA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b2eecad369ad4521bb21b0c9970d2431', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 15102, 0, N'KENTUCKY ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b33f3c47b51b486dbd4363cbec8ea606', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 884, 16, N'WEST VIRGINIA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b344c6bfb9534209b2582c4f23bb7754', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 883, 0, N'OHIO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b389410ec9af4dfeaf41dc0eba72b23e', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 13292, 4, N'NEW YORK ', N'QUEENS', N'QUEENS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b3a4064651d84094b5c64dbc63581370', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 836, 2, N'WASHINGTON ', N'SEATTLE (KING CNTY)', N'KING ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b4985d683c3a4ae09960a79017c19835', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 5302, 99, N'MISSOURI ', N'REST OF STATE*', N'ALL OTHER COUNTIES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b4cb2fff44334dcdb5f9209d6bbdd203', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 13282, 99, N'NEW YORK ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b4e80a531e95424086e6d2d6b7852519', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 14202, 1, N'MASSACHUSETTS ', N'METROPOLITAN BOSTON ', N'MIDDLESEX, NORFOLK AND SUFFOLK')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b51608cb7d2b4bdfacf76a1a53d0a4eb', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 2302, 1, N'OREGON ', N'PORTLAND', N'CLACKAMAS, MULTNOMAH AND WASHINGTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b5594d77522f4bd3a29f254ca066e1b4', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 4412, 20, N'TEXAS ', N'BEAUMONT', N'JEFFERSON ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b56d91ac9b894ceca00d936ab22e9396', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 13202, 3, N'NEW YORK', N'POUGHKPSIE/N NYC SUBURBS', N'COLUMBIA, DELAWARE, DUTCHESS, GREENE, ORANGE, PUTNAM, SULLIVAN AND ULSTER')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b6aa2a1c985e451b9bcb69ae063ffe00', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 954, 0, N'MINNESOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b6ee6aee0ea646f6a6f7cc7157316596', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 15202, 0, N'OHIO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b7053c920ea14a45b56103a5cac5bd3a', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 1112, 9, N'CALIFORNIA ', N'SANTA CLARA', N'SANTA CLARA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b72aec25bdd24a28a3d7f3b93fb0bdc2', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 12402, 99, N'NEW JERSEY ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b78de423d9ec4acd9320deb34f0ce0d2', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 5202, 0, N'KANSAS ', N'STATEWIDE* ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b7b734e1499e463394bd73a2e6e992bd', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 3302, 1, N'NORTH DAKOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b806d01454bc4ffeb9235dde52be9e9e', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 14112, 3, N'MAINE ', N'SOUTHERN MAINE ', N'CUMBERLAND AND YORK')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b8ce79619f7b4629bb2561d10230d758', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 11302, 0, N'VIRGINIA', N'STATEWIDE', N'ALL COUNTIES, EXCEPT ALEXANDRIA CITY, ARLINGTON, FAIRFAX, FAIRFAX CITY, AND FALLS CHURCH CITY')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b8d7665a748446f585856f35c2b7649a', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 3502, 9, N'UTAH ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b8d8186ca95a4b4ea805b740ee758f5f', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 9102, 3, N'FLORIDA ', N'FORT LAUDERDALE', N'BROWARD, COLLIER, INDIAN RIVER, LEE, MARTIN, PALM BEACH, AND ST. LUCIE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'b93fc292ae2049c2aa2b9226488aab3b', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 7302, 0, N'MISSISSIPPI ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ba3f3568bc0545a09ad85eb42e024ccf', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 512, 0, N'MISSISSIPPI ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ba44bc72b3074635b4b0182a332b8f38', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 3202, 1, N'MONTANA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'bb4a584ccf764ed089a227f13041a6b3', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 4402, 20, N'TEXAS ', N'BEAUMONT', N'JEFFERSON ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'bcec5e2aaa2a451a9ed3778d024cfd7c', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 4412, 99, N'TEXAS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'bd0b0881042a401baf34132d3ea5f086', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 2402, 99, N'WASHINGTON ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'beb237b4c76045879ed3afa0dd98635a', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 5302, 1, N'MISSOURI ', N'METROPOLITAN ST. LOUIS', N'JEFFERSON, ST. CHARLES, ST. LOUIS AND ST. LOUIS CITY')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'bf277fbe4dd24a0b8b3cc39d08627684', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 13102, 0, N'CONNECTICUT ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'bf4493984a854310a5193e1e24e577d3', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 12302, 1, N'MARYLAND ', N'BALTIMORE/SURR. CNTYS', N'ANNE ARUNDEL, BALTIMORE, BALTIMORE CITY, CARROLL, HARFORD AND HOWARD')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'bf902b6e1a55413b8a1bff721761ea8e', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 4412, 31, N'TEXAS ', N'AUSTIN', N'TRAVIS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'bf9fa7536f5a4b68a50c0d6d73200ec0', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 2302, 1, N'OREGON ', N'PORTLAND', N'CLACKAMAS, MULTNOMAH AND WASHINGTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'bfd713abf7254c7baeadc1463138cef6', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 14302, 40, N'NEW HAMPSHIRE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c0484181b94f4d14b829238cb6ce2801', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 14302, 40, N'NEW HAMPSHIRE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c0ed1286e4414b1c857aa18b70e0e803', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 836, 99, N'WASHINGTON ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c118d475aaba47ad8b186b84a19c168a', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 14202, 1, N'MASSACHUSETTS ', N'METROPOLITAN BOSTON ', N'MIDDLESEX, NORFOLK AND SUFFOLK')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c1cad6101c4640ca8b692d26f6a071a7', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 13202, 3, N'NEW YORK ', N'POUGHKPSIE/N NYC SUBURBS', N'COLUMBIA, DELAWARE, DUTCHESS, GREENE, ORANGE, PUTNAM, SULLIVAN AND ULSTER')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c1ddee6737fc492595e6e4a29fdeb575', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 5402, 0, N'NEBRASKA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c24e157ed12449538f643d6c0dd58a76', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 528, 99, N'LOUISIANA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c287836081c54717b683ea5bcb7e553e', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 7302, 0, N'MISSISSIPPI ', N'STATEWIDE ', N'ALL COUNTIES ')
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c2e0ea4e856b4876a3b579a4dec502b5', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 14212, 1, N'MASSACHUSETTS ', N'METROPOLITAN BOSTON ', N'MIDDLESEX, NORFOLK AND SUFFOLK')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c2e8138be90b4277a6844588c484dec6', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 4212, 5, N'NEW MEXICO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c2f7b5090e4748fe93ae128df45944e7', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 4402, 18, N'TEXAS ', N'HOUSTON', N'HARRIS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c3ca692f3e154b7aab5f6125102b718a', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 953, 99, N'MICHIGAN ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c3d363a9c2d643e38bb17827a378b644', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 8202, 99, N'MICHIGAN ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c43b4ec16221435182b174271469610e', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 952, 99, N'ILLINOIS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c482d94defdf46afbb0643ac9fd1ef30', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 952, 15, N'ILLINOIS ', N'SUBURBAN CHICAGO', N'DUPAGE, KANE, LAKE AND WILL')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c49956f2e30447e99f20d70b612c175b', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 12202, 1, N'DISTRICT OF COLUMBIA ', N'DC MD/VA SUBURBS', N'DISTRICT OF COLUMBIA; ALEXANDRIA CITY, ARLINGTON, FAIRFAX, FAIRFAX CITY, FALLS CHURCH CITY IN VIRGINIA; MONTGOMERY AND PRINCE GEORGES IN MARYLAND')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c4f92bbf81dc4a13b36316b4816a0ad7', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 4112, 1, N'COLORADO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c598969ec90849efacd1812c52ee41a9', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 7102, 13, N'ARKANSAS ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c5cc52b9c84d4e1e95787153e2c80b53', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 12102, 1, N'DELAWARE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c61a163e1e6547d2b122f7aa0e1add16', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), 1112, 5, N'CALIFORNIA ', N'SAN FRANCISCO', N'SAN FRANCISCO ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c62282b2691140c4bc15d8e9a0451147', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 4412, 15, N'TEXAS ', N'GALVESTON', N'GALVESTON ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c6740ab6672e4ae0b5b4eeec76fcde36', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 4402, 28, N'TEXAS ', N'FORT WORTH', N'TARRANT ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c6933549f6ab4018b31668700d78a5d2', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 5302, 99, N'MISSOURI ', N'REST OF STATE* ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c7501b92bf7948f5b5c70d05d2018018', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 14202, 99, N'MASSACHUSETTS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c7ba734120074f0c98636826c7adc51c', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 2402, 2, N'WASHINGTON ', N'SEATTLE (KING CNTY)', N'KING ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c83d9fc90c284b118a097511dd6c00ae', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 12102, 1, N'DELAWARE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c8a3ecfda24e492190ee3a2bb8340ebf', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 5302, 1, N'MISSOURI ', N'METROPOLITAN ST. LOUIS', N'JEFFERSON, ST. CHARLES, ST. LOUIS AND ST. LOUIS CITY')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c95e78e80ad4481ba41d90f386c302ca', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 2302, 99, N'OREGON ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c963c23db9be45d98916f44bbdd0d32e', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 3502, 9, N'UTAH ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c9ecb90c8a354ee0b1b2e6dde06846a8', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 2202, 0, N'IDAHO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'c9f6cc01ea7a45b881aa2b20e2a83e1f', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 1192, 26, N'CALIFORNIA ', N'ANAHEIM/SANTA ANA', N'ORANGE ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ca60ccef8dbd44e79c106e5f7d048f16', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 952, 16, N'ILLINOIS ', N'CHICAGO', N'COOK ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ca7cb21890f947629cce06c8961cb1b2', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 3302, 1, N'NORTH DAKOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'cad6348eb70d4e15b4b6909eadd80e8b', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 4412, 20, N'TEXAS ', N'BEAUMONT', N'JEFFERSON ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'caf3e45210aa4b018a932eac413ca1f8', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 15202, 0, N'OHIO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'cb2e112da291450b8a2fcec9bf395ae0', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2016-12-31T23:59:00.000' AS DateTime), 1182, 26, N'CALIFORNIA ', N'ANAHEIM/SANTA ANA', N'ORANGE ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'cb9b8a0154734f559f3f63d8ab8f4499', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 13202, 2, N'NEW YORK ', N'NYC SUBURBS/LONG ISLAND', N'BRONX, KINGS, NASSAU, RICHMOND, ROCKLAND, SUFFOLK AND WESTCHESTER')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'cbacca9084e8467b97f1eb4e918ce774', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 5302, 1, N'MISSOURI ', N'METROPOLITAN ST. LOUIS', N'JEFFERSON, ST. CHARLES, ST. LOUIS AND ST. LOUIS CITY')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'cbe7f994055c441bbaabba159fffa3ff', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2016-12-31T23:59:00.000' AS DateTime), 5302, 99, N'MISSOURI ', N'REST OF STATE*', N'ALL OTHER COUNTIES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'cbf989bfd0474ed9b1dec78891a5f41e', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 12502, 99, N'PENNSYLVANIA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'cc1b88168a454e199e424ae8285c4a7e', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 14102, 3, N'MAINE ', N'SOUTHERN MAINE ', N'CUMBERLAND AND YORK')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'cc3062e78b9944ffb09e5a4a8d552221', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 13102, 0, N'CONNECTICUT ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'cc8dd85ce1c445718a8e522d70aa6217', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 7202, 99, N'LOUISIANA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'cc90648c6a484e59b074281e1eb944a9', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 3202, 1, N'MONTANA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ccd066de4ac94a36bcd7f24e7ac98729', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 951, 0, N'WISCONSIN ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'cce3ea35bcf24a0da21cbe4c555ccd71', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 13202, 2, N'NEW YORK', N'NYC SUBURBS/LONG ISLAND', N'BRONX, KINGS, NASSAU, RICHMOND, ROCKLAND, SUFFOLK AND WESTCHESTER')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'cd177bf916804da8aca48185612bad10', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 13202, 2, N'NEW YORK ', N'NYC SUBURBS/LONG ISLAND', N'BRONX, KINGS, NASSAU, RICHMOND, ROCKLAND, SUFFOLK AND WESTCHESTER')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'cd8a62b6339844acb23c55276f439b51', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 5402, 0, N'NEBRASKA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'cddca5ae7aa14c1f86c8d53ce3400d36', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 4402, 11, N'TEXAS ', N'DALLAS', N'DALLAS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ceb20512b7e34576ae783cfa7425c97c', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 3102, 0, N'ARIZONA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'cf43159820b547188bf0c59e33b93e13', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 4412, 9, N'TEXAS ', N'BRAZORIA', N'BRAZORIA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'cf9e26adf2634cacb0c3537eb3e66cd0', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 12102, 1, N'DELAWARE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd03a70b05fdc4c19b18dc564299e8501', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 1192, 17, N'CALIFORNIA ', N'VENTURA', N'VENTURA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd0bab16f0d3248ffbc5800539d55deac', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 4402, 9, N'TEXAS ', N'BRAZORIA', N'BRAZORIA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd1015ae269bf4f278dc196900ddd1c6e', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 10302, 35, N'TENNESSEE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd11cf6e398da4f309253bf62720e10cf', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 1112, 5, N'CALIFORNIA ', N'SAN FRANCISCO', N'SAN FRANCISCO ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd144b3c597e14907b0381f67257a736a', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 4402, 9, N'TEXAS ', N'BRAZORIA', N'BRAZORIA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd152ecbff47447e29bfea1360ddcadef', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 12502, 99, N'PENNSYLVANIA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd299a505d6824c9a8a179f5286b97c11', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 10202, 99, N'GEORGIA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd2bb8075c2d04d03b886ba5797211b77', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 2102, 1, N'ALASKA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd37910f412e343a8b42c325af15dc0ef', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 11202, 1, N'SOUTH CAROLINA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd42b176dd64d43a3b81412f18964448a', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 3402, 2, N'SOUTH DAKOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd4be52e111c148c1b9f17da20a04eb61', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 5130, 0, N'IDAHO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd4dcb8944057471e900d501a855839df', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 6302, 0, N'WISCONSIN ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd55666fde34141abb0e417dc199c37bd', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 5302, 2, N'MISSOURI ', N'METROPOLITAN KANSAS CITY', N'CLAY, JACKSON AND PLATTE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd56f0090deb9422d846cd383255e3e5a', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 1192, 17, N'CALIFORNIA ', N'VENTURA', N'VENTURA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd5af065ef413467892457cd394372c6a', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 3402, 2, N'SOUTH DAKOTA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd6513a22453b43c29b3aa92c3e0a5231', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 12202, 1, N'DISTRICT OF COLUMBIA ', N'DC MD/VA SUBURBS', N'DISTRICT OF COLUMBIA; ALEXANDRIA CITY, ARLINGTON, FAIRFAX, FAIRFAX CITY, FALLS CHURCH CITY IN VIRGINIA; MONTGOMERY AND PRINCE GEORGES IN MARYLAND')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd6d526151a5b4f3ea4dbbe4bd68bf0eb', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 14102, 99, N'MAINE ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd6e377853d5d4c198f5223fb489d1be2', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 951, 0, N'WISCONSIN ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd750381d7aea403b8aa169babf9c9bd5', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 952, 99, N'ILLINOIS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd7811548a5a24ed3befd8a902f47cf81', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 4412, 9, N'TEXAS ', N'BRAZORIA', N'BRAZORIA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd7945a6bde59428c91ab984318112909', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 14102, 99, N'MAINE ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd7b1671129d14376a8ba81dcbf14125e', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 6102, 99, N'ILLINOIS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd7f635c028f44d0b8fd9ad08a1f64c1f', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 953, 1, N'MICHIGAN ', N'DETROIT', N'MACOMB, OAKLAND, WASHTENAW AND WAYNE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd870bfe47806486c85ddc9d8c5856181', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 14202, 99, N'MASSACHUSETTS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd8c4ecee47044d6daf30ee34125ee49f', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 4102, 1, N'COLORADO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd8c90850b27b43fcba9e25f449e80feb', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 1102, 3, N'CALIFORNIA ', N'MARIN/NAPA/SOLANO', N'MARIN, NAPA, AND SOLANO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd8e705bde2ae47a8b1ad3ac3d73695d3', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 14202, 1, N'MASSACHUSETTS ', N'METROPOLITAN BOSTON ', N'MIDDLESEX, NORFOLK AND SUFFOLK')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd94a4b57ae36437ba5d53b3354572a69', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 7102, 13, N'ARKANSAS ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd95ef19dc6d647b2bdb93961daa8a31b', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 15202, 0, N'OHIO ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'd9f801eedd3f439aaec6e0172b1cc77d', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 11502, 0, N'NORTH CAROLINA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'da134920025c4e18a8ce518ca239b923', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 14202, 99, N'MASSACHUSETTS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'dad25fcf1e52472eb0254a8265e5ff4a', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 13202, 2, N'NEW YORK ', N'NYC SUBURBS/LONG ISLAND', N'BRONX, KINGS, NASSAU, RICHMOND, ROCKLAND, SUFFOLK AND WESTCHESTER')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'db01e160669e4910b4c125e5073d632f', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 6102, 15, N'ILLINOIS ', N'SUBURBAN CHICAGO', N'DUPAGE, KANE, LAKE AND WILL')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'db80634492c140d3a911114f9a80ef6a', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 7202, 1, N'LOUISIANA ', N'NEW ORLEANS', N'JEFFERSON, ORLEANS, PLAQUEMINES AND ST. BERNARD')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'dbfb524cdc814c1bba1ae3239a948fc7', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2016-12-31T23:59:00.000' AS DateTime), 1182, 99, N'CALIFORNIA ', N'REST OF STATE*', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'dd581f1cc563458da0dafdafcb366187', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 1102, 9, N'CALIFORNIA ', N'SANTA CLARA', N'SANTA CLARA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'dd971231c9674ea3be74c335a3165e45', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 1102, 6, N'CALIFORNIA ', N'SAN MATEO', N'SAN MATEO ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'debff5f0a20d410ab365df57d48c0623', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 15102, 0, N'KENTUCKY ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ded4cdceffd24eb6953522571f427ec5', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 952, 12, N'ILLINOIS ', N'EAST ST. LOUIS', N'BOND, CALHOUN, CLINTON, JERSEY, MACOUPIN, MADISON, MONROE, MONTGOMERY, RANDOLPH, ST. CLAIR AND WASHINGTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'df1ce37f8fb641fbadeb0faaa1de6b75', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 4402, 11, N'TEXAS ', N'DALLAS', N'DALLAS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'df3e7e20df544a6ca5bb65226f02bf59', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 12302, 99, N'MARYLAND ', N'REST OF STATE ', N'ALL OTHER COUNTIES EXCEPT MONTGOMERY AND PRINCE GEORGES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'df479ec8e8784c1083015d8b68a12909', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 1192, 99, N'CALIFORNIA ', N'REST OF STATE*', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'df59832b34d742eaa9c476e7968bba59', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 14202, 99, N'MASSACHUSETTS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'df61d6bf12524624b20651fbf47c76cd', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 1302, 0, N'NEVADA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'df6418ad44fd489eb57558b29347002e', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 9202, 20, N'PUERTO RICO ', N'PUERTO RICO', N'ALL COUNTY EQUIVALENTS')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'df87819497804ad1a8865a968fcd2edd', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 9202, 20, N'PUERTO RICO ', N'PUERTO RICO', N'ALL COUNTY EQUIVALENTS')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'e062f04941a4417bb6bfe8c5a39614ea', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 1102, 99, N'CALIFORNIA ', N'REST OF STATE*', N'ALL OTHER COUNTIES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'e11ee42e431a4f0885fe4e4c913edd97', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 9102, 4, N'FLORIDA ', N'MIAMI', N'DADE AND MONROE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'e20499fcf65447c3ad09a4172cfe1155', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 6302, 0, N'WISCONSIN ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'e365af5b56d74642b3ec3474a0789882', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 12102, 1, N'DELAWARE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'e3af14e65502432eb1565d46f8d79578', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 1102, 99, N'CALIFORNIA ', N'REST OF STATE*', N'ALL OTHER COUNTIES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'e432ff21f23348cd8b6d259fa39edc04', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 5102, 0, N'IOWA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'e44e03fc621b4eb490c028f9ae1276d4', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 1102, 3, N'CALIFORNIA ', N'MARIN/NAPA/SOLANO', N'MARIN, NAPA, AND SOLANO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'e485dbc682174dad96559f0649fbc590', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), 10302, 35, N'TENNESSEE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'e6351ff8e8fe49a089a6f350dd1d4faf', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 12302, 1, N'MARYLAND ', N'BALTIMORE/SURR. CNTYS', N'ANNE ARUNDEL, BALTIMORE, BALTIMORE CITY, CARROLL, HARFORD AND HOWARD')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'e694599e3d074ee28f275151591704ae', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 7102, 13, N'ARKANSAS ', N'STATEWIDE ', N'ALL COUNTIES ')
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'e6cac02db0074ec78daa8a68dbff3615', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 0, 0, N' ', N' ', N' ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'e71a923b2ab74182855f55330bbac77d', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 8202, 99, N'MICHIGAN ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'e72801cd84c44f9cb0b853201b929cde', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 3602, 21, N'WYOMING ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'e78947f5c5454c57b5bf60ce949b504d', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 12502, 1, N'PENNSYLVANIA ', N'METROPOLITAN PHILADELPHIA', N'BUCKS, CHESTER, DELAWARE, MONTGOMERY AND PHILADELPHIA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'e7f932f1e0ed48b092eea3c5b8a9958b', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 528, 1, N'LOUISIANA ', N'NEW ORLEANS', N'JEFFERSON, ORLEANS, PLAQUEMINES AND ST. BERNARD')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'e859df3c38254e0bac015be871a238b9', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 3602, 21, N'WYOMING ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'e8ace28cd8654d57ad59a8d2243903c3', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 1302, 0, N'NEVADA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'e9c43d257eb14fc5a1fc06ba73571fc9', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 10302, 35, N'TENNESSEE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ea0b6f8dbf554d0c81e6ef71d15e6457', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 8102, 0, N'INDIANA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ea97b6c91e3148ed945dd7d1b15b0c49', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 12202, 1, N'DISTRICT OF COLUMBIA ', N'DC MD/VA SUBURBS', N'DISTRICT OF COLUMBIA; ALEXANDRIA CITY, ARLINGTON, FAIRFAX, FAIRFAX CITY, FALLS CHURCH CITY IN VIRGINIA; MONTGOMERY AND PRINCE GEORGES IN MARYLAND')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'eb369e1ce3544ecf9b3d1993544b909b', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 12402, 99, N'NEW JERSEY ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'eb5e3b2f2cf74f5484ec52d5fc1fe9fb', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 11302, 0, N'VIRGINIA', N'STATEWIDE', N'ALL COUNTIES, EXCEPT ALEXANDRIA CITY, ARLINGTON, FAIRFAX, FAIRFAX CITY, AND FALLS CHURCH CITY')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'eba6fa4166bd47fba8e096462f9b82d0', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 10202, 1, N'GEORGIA ', N'ATLANTA', N'BUTTS, CHEROKEE, CLAYTON, COBB, DEKALB, DOUGLAS, FAYETTE, FORSYTH, FULTON, GWINNETT, HENRY, NEWTON, PAULDING, ROCKDALE AND WALTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ec23cc1f928641daa410fbfc9ff45e15', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 5302, 1, N'MISSOURI ', N'METROPOLITAN ST. LOUIS', N'JEFFERSON, ST. CHARLES, ST. LOUIS AND ST. LOUIS CITY')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ed08eac6eb30429c9bce3e8c779692ce', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 10302, 35, N'TENNESSEE ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'edbeb672ee7c44bf9953314bfbdb7b2b', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 4402, 31, N'TEXAS ', N'AUSTIN', N'TRAVIS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ee724a1bf093430d86aa244ba2214f1d', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 11302, 0, N'VIRGINIA', N'STATEWIDE', N'ALL COUNTIES, EXCEPT ALEXANDRIA CITY, ARLINGTON, FAIRFAX, FAIRFAX CITY, AND FALLS CHURCH CITY')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'eebe17f4b21148f2b4ea0d073c917f98', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 8202, 99, N'MICHIGAN ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'eef1f1a104a943a0adccc575a8380c9d', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 5302, 99, N'MISSOURI ', N'REST OF STATE*', N'ALL OTHER COUNTIES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ef18d3d856de4ae0b4293a5d336ec20d', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 1192, 17, N'CALIFORNIA ', N'VENTURA', N'VENTURA ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'f1601cd0db68403fb6ab7699f7a6b83a', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 13292, 4, N'NEW YORK ', N'QUEENS', N'QUEENS ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'f2c803a8906c4f4aa660c62784a3426a', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 3602, 21, N'WYOMING ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'f3900dbb6b2844ca97ffbafea4d67e43', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 12302, 99, N'MARYLAND ', N'REST OF STATE ', N'ALL OTHER COUNTIES EXCEPT MONTGOMERY AND PRINCE GEORGES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'f44aa7255db04171a554f985661bec3b', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 11502, 0, N'NORTH CAROLINA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'f48ca1cfb4754cdea7b9ea36e7f67fea', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 3102, 0, N'ARIZONA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'f5b16aefbe9e45c6a4ae3bdae1e0104a', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 3502, 9, N'UTAH ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'f5b525fc1d9948e9a5a4dfc96b4ac386', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2016-12-31T23:59:00.000' AS DateTime), 1112, 3, N'CALIFORNIA ', N'MARIN/NAPA/SOLANO', N'MARIN, NAPA, AND SOLANO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'f5cab2de5dad4bf4aa22d9884c346cb5', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 8202, 1, N'MICHIGAN ', N'DETROIT', N'MACOMB, OAKLAND, WASHTENAW AND WAYNE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'f615300fb15a4215b2dd773c1229c030', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 8102, 0, N'INDIANA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'f70643d64b95479191b9c0a0c907fb90', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 6102, 12, N'ILLINOIS ', N'EAST ST. LOUIS', N'BOND, CALHOUN, CLINTON, JERSEY, MACOUPIN, MADISON, MONROE, MONTGOMERY, RANDOLPH, ST. CLAIR AND WASHINGTON')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'f7249ac8dc9e4e5dbd7bc4bf39747b69', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 4302, 0, N'OKLAHOMA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'f7f1ecd1ed424a289c5584019bae6761', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 11302, 0, N'VIRGINIA', N'STATEWIDE', N'ALL COUNTIES, EXCEPT ALEXANDRIA CITY, ARLINGTON, FAIRFAX, FAIRFAX CITY, AND FALLS CHURCH CITY')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'f86b666d4c2449e695630ac2413d2899', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 4412, 99, N'TEXAS ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'f8a34e995d934f2f9ddd58dc78f736a4', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 7202, 1, N'LOUISIANA ', N'NEW ORLEANS', N'JEFFERSON, ORLEANS, PLAQUEMINES AND ST. BERNARD')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'f8b47fa7669e46ebab3ac2c05e1eafe1', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 9102, 3, N'FLORIDA ', N'FORT LAUDERDALE', N'BROWARD, COLLIER, INDIAN RIVER, LEE, MARTIN, PALM BEACH, AND ST. LUCIE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'f950068f91944a76b5cce499e24ca0f2', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 12402, 1, N'NEW JERSEY ', N'NORTHERN NJ ', N'BERGEN, ESSEX, HUDSON, HUNTERDON, MIDDLESEX, MORRIS, PASSAIC, SOMERSET, SUSSEX, UNION AND WARREN')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'f976aecb3e5d49fc926b0cd24b1e01e9', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 12502, 1, N'PENNSYLVANIA ', N'METROPOLITAN PHILADELPHIA', N'BUCKS, CHESTER, DELAWARE, MONTGOMERY AND PHILADELPHIA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'f9b2f4407c49484e9dd473c03bab902d', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 5202, 0, N'KANSAS ', N'STATEWIDE* ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff100', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 57, N'CALIFORNIA', N'HANFORD-CORCORAN', N'KINGS')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff101', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), 1182, 18, N'CALIFORNIA', N'LOS ANGELES-LONG BEACH-ANAHEIM (LOS ANGELES CNTY)', N'LOS ANGELES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff102', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), 1182, 26, N'CALIFORNIA', N'LOS ANGELES-LONG BEACH-ANAHEIM (ORANGE CNTY)', N'ORANGE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff103', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 58, N'CALIFORNIA', N'MADERA', N'MADERA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff104', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 59, N'CALIFORNIA', N'MERCED', N'MERCED')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff105', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 60, N'CALIFORNIA', N'MODESTO', N'STANISLAUS')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff106', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 51, N'CALIFORNIA', N'NAPA', N'NAPA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff107', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1182, 17, N'CALIFORNIA', N'OXNARD-THOUSAND OAKS-VENTURA', N'VENTURA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff108', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 61, N'CALIFORNIA', N'REDDING', N'SHASTA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff109', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 62, N'CALIFORNIA', N'RIVERSIDE-SAN BERNARDINO-ONTARIO', N'SAN BERNARDINO, RIVERSIDE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff110', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), 1112, 63, N'CALIFORNIA', N'SACRAMENTO--ROSEVILLE--ARDEN-ARCADE', N'SACRAMENTO, PLACER, YOLO, EL DORADO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff111', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 64, N'CALIFORNIA', N'SALINAS', N'MONTEREY')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff112', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), 1182, 72, N'CALIFORNIA', N'SAN DIEGO-CARLSBAD', N'SAN DIEGO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff113', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), 1112, 52, N'CALIFORNIA', N'SAN FRANCISCO-OAKLAND-HAYWARD (MARIN CNTY)', N'MARIN')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff114', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 65, N'CALIFORNIA', N'SAN JOSE-SUNNYVALE-SANTA CLARA (SAN BENITO CNTY)', N'SAN BENITO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff115', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), 1182, 73, N'CALIFORNIA', N'SAN LUIS OBISPO-PASO ROBLES-ARROYO GRANDE', N'SAN LUIS OBISPO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff116', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 66, N'CALIFORNIA', N'SANTA CRUZ-WATSONVILLE', N'SANTA CRUZ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff117', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1182, 74, N'CALIFORNIA', N'SANTA MARIA-SANTA BARBARA', N'SANTA BARBARA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff118', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), 1112, 67, N'CALIFORNIA', N'SANTA ROSA', N'SONOMA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff119', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), 1112, 68, N'CALIFORNIA', N'STOCKTON-LODI', N'SAN JOAQUIN')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff120', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), 1112, 53, N'CALIFORNIA', N'VALLEJO-FAIRFIELD', N'SOLANO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff121', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), 1112, 69, N'CALIFORNIA', N'VISALIA-PORTERVILLE', N'TULARE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff122', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 70, N'CALIFORNIA', N'YUBA CITY', N'SUTTER, YUBA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff96', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 54, N'CALIFORNIA', N'BAKERSFIELD', N'KERN')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff97', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 55, N'CALIFORNIA', N'CHICO', N'BUTTE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff98', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1182, 71, N'CALIFORNIA', N'EL CENTRO', N'IMPERIAL')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fa3953d0ed4e49e19b2b8834c1c2ff99', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 1112, 56, N'CALIFORNIA', N'FRESNO', N'FRESNO')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fad9ebfedd19455da88e60b90ee08091', CAST(N'2013-04-01T00:00:00.000' AS DateTime), CAST(N'2013-06-30T00:00:00.000' AS DateTime), 12302, 99, N'MARYLAND ', N'REST OF STATE ', N'ALL OTHER COUNTIES EXCEPT MONTGOMERY AND PRINCE GEORGES')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fb134be484984ba1a41f71f80f10b92f', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 9102, 99, N'FLORIDA ', N'REST OF STATE ', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fbbf79632ca4432db3615fa8f5107a31', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 11202, 1, N'SOUTH CAROLINA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fbeca17d9e4f489b9395923a6a54113e', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 1112, 7, N'CALIFORNIA ', N'OAKLAND/BERKLEY', N'ALAMEDA AND CONTRA COSTA')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fc80f0817c8b47a0a5b2dd72be985bec', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 1102, 5, N'CALIFORNIA ', N'SAN FRANCISCO', N'SAN FRANCISCO ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fc9df981d1474842b6f666ecebcfde24', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-09-30T00:00:00.000' AS DateTime), 1192, 99, N'CALIFORNIA ', N'REST OF STATE*', N'ALL OTHER COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fd9010c689f04d20b5f318706843e65c', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 11302, 0, N'VIRGINIA', N'STATEWIDE', N'ALL COUNTIES, EXCEPT ALEXANDRIA CITY, ARLINGTON, FAIRFAX, FAIRFAX CITY, AND FALLS CHURCH CITY')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fde93515293444e3b9d3b69c13bc92f4', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2013-03-31T00:00:00.000' AS DateTime), 13102, 0, N'CONNECTICUT ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'feb82098eb4c4eb59144b7ffc04b50dd', CAST(N'2013-10-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T00:00:00.000' AS DateTime), 11502, 0, N'NORTH CAROLINA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'fed10fe863f94ad3a08c5f3434f6f740', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 11502, 0, N'NORTH CAROLINA ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ff4a2ae4f54a4113834898444f0dea91', CAST(N'2013-07-01T00:00:00.000' AS DateTime), CAST(N'2013-10-30T00:00:00.000' AS DateTime), 9102, 3, N'FLORIDA ', N'FORT LAUDERDALE', N'BROWARD, COLLIER, INDIAN RIVER, LEE, MARTIN, PALM BEACH, AND ST. LUCIE')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ffb1aaf8f7cd4e989e9e9f9e1efa04de', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), 13102, 0, N'CONNECTICUT ', N'STATEWIDE ', N'ALL COUNTIES ')
INSERT [dbo].[Carriers] ([CarrierID], [BeginDate], [EndDate], [CarrierNumber], [LocalityNumber], [State], [FeeScheduleArea], [Counties]) VALUES (N'ffed242f918943d2aa898309cbd39383', CAST(N'2012-10-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T00:00:00.000' AS DateTime), 5402, 0, N'NEBRASKA ', N'STATEWIDE ', N'ALL COUNTIES ')
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'00b45248a4bb4f0f8acd672c37985745', 1, 1, -1, N'99476  Subsequent inpatient pediatric critical care, per day, for the evaluation and management of a critically ill infant or young child, 2 through 5 years of age.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99476', 30504688, -2, 0, 0, 0, 0, 730, 2190, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'00b45248a4bb4f0f8acd672c37985746', 1, 1, -1, N'G2012 Brief communication technology-based service, e.g. virtual check-in, by a physician or other qualified health care professional who can report evaluation and management services, provided to an established patient, not originating from a related e/m service provided within the previous 7 days nor leading to an e/m service or procedure within the next 24 hours or soonest available appointment; 5-10 minutes of medical discussion', CAST(N'2020-01-01T00:00:00.000' AS DateTime), CAST(N'2024-12-31T23:59:00.000' AS DateTime), N'G2012', 29509800, -2, 0, 0, 0, 0, 0, 364635, 5, 999, 18, 3, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'00b45248a4bb4f0f8acd672c37985747', 1, 1, -1, N'G2010 Remote evaluation of recorded video and/or images submitted by an established patient (e.g., store and forward), including interpretation with follow-up with the patient within 24 business hours, not originating from a related e/m service provided within the previous 7 days nor leading to an e/m service or procedure within the next 24 hours or soonest available appointment', CAST(N'2020-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G2010', 29509900, -2, 0, 0, 0, 0, 0, 364635, 0, 999, 18, 3, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'00b45248a4bb4f0f8acd672c37985748', 0, 1, 5, N'99441 Telephone evaluation and management service provided by a physician to an established patient, parent, or guardian not originating from a related E/M service provided within the previous 7 days nor leading to an E/M service or procedure within the next 24 hours or soonest available appointment; 5-10 minutes of medical discussion. (Do not report 99441-99443 when using 99339-99340, 99374-99380 for the same call(s)) (Do not report 99441-99443 for anticoagulation management when reporting 99363-99364, 0)', CAST(N'2020-01-01T00:00:00.000' AS DateTime), CAST(N'2024-12-31T23:59:00.000' AS DateTime), N'99441', 29504250, -2, 0, -1, -1, -1, 0, 364635, 5, 10, 18, 3, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'00b45248a4bb4f0f8acd672c37985749', 0, 1, 11, N'99442 Telephone evaluation and management service provided by a physician to an established patient, parent, or guardian not originating from a related E/M service provided within the previous 7 days nor leading to an E/M service or procedure within the next 24 hours or soonest available appointment; 11-20 minutes of medical discussion', CAST(N'2020-01-01T00:00:00.000' AS DateTime), CAST(N'2024-12-31T23:59:00.000' AS DateTime), N'99442', 29504250, -2, 0, -1, -1, -1, 0, 364635, 11, 20, 18, 3, 0, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'00b45248a4bb4f0f8acd672c37985750', 0, 1, 21, N'99443 Telephone evaluation and management service provided by a physician to an established patient, parent, or guardian not originating from a related E/M service provided within the previous 7 days nor leading to an E/M service or procedure within the next 24 hours or soonest available appointment; 21-30 minutes of medical discussion (Do not report 99441-99443 when using 99339-99340, 99374-99380 for the same call(s)) (Do not report 99441-99443 for anticoagulation management when reporting 99363-99364, 0)', CAST(N'2020-01-01T00:00:00.000' AS DateTime), CAST(N'2024-12-31T23:59:00.000' AS DateTime), N'99443', 29504250, -2, 0, -1, -1, -1, 0, 364635, 21, 999, 18, 3, 0, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'00b45248a4bb4f0f8acd672c37985751', 1, 0, 5, N'99441 Telephone evaluation and management service provided by a physician to an established patient, parent, or guardian not originating from a related E/M service provided within the previous 7 days nor leading to an E/M service or procedure within the next 24 hours or soonest available appointment; 5-10 minutes of medical discussion. (Do not report 99441-99443 when using 99339-99340, 99374-99380 for the same call(s)) (Do not report 99441-99443 for anticoagulation management when reporting 99363-99364, 0)', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2023-10-09T23:59:00.000' AS DateTime), N'99441', 29504250, -2, 0, -1, -1, -1, 0, 364635, 5, 10, 18, 3, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'00b45248a4bb4f0f8acd672c37985752', 1, 0, 11, N'99442 Telephone evaluation and management service provided by a physician to an established patient, parent, or guardian not originating from a related E/M service provided within the previous 7 days nor leading to an E/M service or procedure within the next 24 hours or soonest available appointment; 11-20 minutes of medical discussion', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2023-10-09T23:59:00.000' AS DateTime), N'99442', 29504250, -2, 0, -1, -1, -1, 0, 364635, 11, 20, 18, 3, 0, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'00b45248a4bb4f0f8acd672c37985753', 1, 0, 21, N'99443 Telephone evaluation and management service provided by a physician to an established patient, parent, or guardian not originating from a related E/M service provided within the previous 7 days nor leading to an E/M service or procedure within the next 24 hours or soonest available appointment; 21-30 minutes of medical discussion (Do not report 99441-99443 when using 99339-99340, 99374-99380 for the same call(s)) (Do not report 99441-99443 for anticoagulation management when reporting 99363-99364, 0)', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2023-10-09T23:59:00.000' AS DateTime), N'99443', 29504250, -2, 0, -1, -1, -1, 0, 364635, 21, 999, 18, 3, 0, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'00fb777af78f4320a3cba43fd43c6d7d', 1, 1, -1, N'90811  Individual psychotherapy, interactive, using play equipment, physical devices, language interpreter, or other mechanisms of non-verbal communication, in an office or outpatient facility with medical evaluation and management, approximately 20 - 30 minutes face-to-face with the patient.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2009-12-31T23:59:00.000' AS DateTime), N'90811', 33005600, -2, 0, 0, 0, 0, 0, 364635, 20, 35, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'01d6d6261fd24f56971600302fcf7951', 1, 1, 0, N'99488   first hour of clinical staff time directed by a physician or other qualified health care professional with one face-to-face visit; per calendar month', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99488', 43009200, -2, 0, 0, 0, 0, 0, 364635, 31, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'01fe87b70baf49b69bcd2f1df8bdc09f', 1, 0, -1, N'99461  Initial care, per day, for evaluation and management of normal newborn infant seen in other than hospital or birthing center', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99461', 30104520, -2, 0, 0, 0, 0, 0, 29, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'02300e4ac8144f40b85defa938068019', 1, 1, -1, N'99429  Unlisted preventive medicine service', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99429', 40504110, -2, 0, -1, -1, -1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'029af0f6a0de42e1aff95194e7f9058c', 1, 1, -1, N'99363  Anticoagulant management for an outpatient taking warfarin, physician review and interpretation of International Normalized Ratio (INR) testing, patient instructions, dosage adjustments (as needed), and ordering of additional tests; initial 90 days of therapy (must include a minimum of 8 INR measurements)', CAST(N'2007-01-01T00:00:00.000' AS DateTime), CAST(N'2007-12-31T23:59:00.000' AS DateTime), N'99363', 26503550, -2, 0, -1, -1, -1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'02b1f73d2ede45439021b6d010ac8d92', 0, 1, 10, N'99212 Office or other outpatient visit for the evaluation and management of an established patient, which requires at least two of these three key components:  a problem focused history, a problem focused examination, and straightforward medical decision making.  Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are self limited or minor. Physicians typically spend 10 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99212', 1000, -2, 2, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'02b422a2fa8f4ceca007d6a91e8b9cb3', 1, 1, -1, N'99305 Initial nursing facility care, per day, for the evaluation and management of a patient which requires these three key components: a comprehensive history;  a comprehensive examination; and  medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission are of moderate severity.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2007-12-31T23:59:00.000' AS DateTime), N'99305', 20002780, -2, 3, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'03616d216351465baad7d6fb894eb39d', 1, 1, -1, N'90814  Individual psychotherapy, interactive, using play equipment, physical devices, language interpreter, or other mechanisms of non-verbal communication, in an office or outpatient facility, approximately 75 - 80 minutes face-to-face with the patient.', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90814', 33005500, -2, 0, 0, 0, 0, 0, 364635, 75, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'0378f0f8ee074e59b2b2041d5cd5baef', 1, 1, -1, N'90822  Individual psychotherapy, insight oriented, behavior and/or supportive, in an inpatient hospital, partial hospital or residential care setting, approximately 75 to 80 minutes face-to-face with the patient with medical evaluation and management services', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2006-12-31T23:59:00.000' AS DateTime), N'90822', 34005800, -2, 0, 0, 0, 0, 0, 364635, 66, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'03ec583b495e4edcaa43445ee76d572d', 1, 1, 60, N'99493 Subsequent psychiatric collaborative care management, first 60 minutes in a subsequent month of behavioral health care manager activities, in consultation with a psychiatric consultant, and directed by the treating physician or other qualified health care professional, with the following required elements: tracking patient follow-up and progress using the registry, with appropriate documentation; participation in weekly caseload consultation with the psychiatric consultant; ongoing collaboration with and coordination of the patient''s mental health care with the treating physician or other qualified health care professional and any other treating mental health providers; additional review of progress and recommendations for changes in treatment, as indicated, including medications, based on recommendations provided by the psychiatric consultant; provision of brief interventions using evidence-based techniques such as behavioral activation, motivational interviewing, and other focused treatment strategies; monitoring of patient outcomes using validated rating scales; and relapse prevention planning with patients as they achieve remission of symptoms and/or other treatment goals and are prepared for discharge from active treatment.', CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2021-12-31T23:59:00.000' AS DateTime), N'99493', 43752000, -2, 0, 0, 0, 0, 0, 364635, 31, 999, 9, 7, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'04c6660104054a50a3ebc256758605b7', 1, 1, 60, N'99244 Office consultation for a new or established patient, which requires these three key components:  a comprehensive history, a comprehensive examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate to high severity. Physicians typically spend 60 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99244', 13001700, -2, 3, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'06aa3cf35d554e03a6b851d3a11ff882', 0, 1, -1, N'Online digital evaluation and management service, for an established patient, for up to 7 days, cumulative time during the 7 days; 5-10 minutes', CAST(N'2020-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99421', 29504255, -2, 0, 0, 0, 0, 0, 364635, 5, 10, 15, 6, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'06aa3cf35d554e03a6b851d3a11ff883', 0, 1, -1, N'Online digital evaluation and management service, for an established patient, for up to 7 days, cumulative time during the 7 days; 11-20 minutes', CAST(N'2020-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99422', 29504255, -2, 0, 0, 0, 0, 0, 364635, 11, 20, 15, 6, 0, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'06aa3cf35d554e03a6b851d3a11ff884', 0, 1, -1, N'Online digital evaluation and management service, for an established patient, for up to 7 days, cumulative time during the 7 days; 21 or more minutes', CAST(N'2020-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99423', 29504255, -2, 0, 0, 0, 0, 0, 364635, 21, 999, 15, 6, 0, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'06aa3cf35d554e03a6b851d3a11ff885', 1, 1, -1, N'Self-measured blood pressure using a device validated for clinical accuracy; patient education/training and device calibration', CAST(N'2020-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99473', 29509641, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'06aa3cf35d554e03a6b851d3a11ff886', 1, 1, -1, N'Self-measured blood pressure using a device validated for clinical accuracy; separate self-measurements of two readings one minute apart, twice daily over a 30-day period (minimum of 12 readings), collection of data reported by the patient and/or caregiver to the physician or other qualified health care professional, with report of average systolic and diastolic pressures and subsequent communication of a treatment plan to the patient', CAST(N'2020-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99474', 29509642, -2, 0, 0, 0, 0, 0, 364635, 0, 999, 14, 4, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'06aa3cf35d554e03a6b851d3a11ff887', 1, 1, 0, N'Remote physiologic monitoring treatment management services, first 20 minutes of clinical staff/physician/other qualified health care professional time in a calendar month requiring interactive communication with the patient/caregiver during the month', CAST(N'2020-01-01T00:00:00.000' AS DateTime), CAST(N'2025-12-31T23:59:00.000' AS DateTime), N'99457', 29509700, -2, 0, 0, 0, 0, 0, 364635, 20, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'06fef14b669d49e481494398bb856349', 1, 1, -1, N'99293 Initial inpatient pediatric critical care, per day, for the evaluation and management of a critically ill infant or young child, 29 days through 24 months of age', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99293', 17002200, -2, 0, -1, -1, -1, 0, 730, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'070d1b5c3be84450a7c00c799d3d9cb0', 1, 1, -1, N'99472  Subsequent inpatient pediatric critical care, per day, for the evaluation and management of a critically ill infant or young child, 29 days through 24 months of age.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99472', 30504688, -2, 0, 0, 0, 0, 29, 730, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'076b4a3852da45e487f6e268426f4df0', 1, 1, -1, N'99420  Administration and interpretation of health risk assessment instrument (e.g., health hazard appraisal)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99420', 28004100, -2, 0, -1, -1, -1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'07aa967058d0417aa999fcba81913f4b', 1, 1, 40, N'99243 Office consultation for a new or established patient, which requires these three key components:  a detailed history, a detailed examination, and medical decision making of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate severity. Physicians typically spend 40 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99243', 13001700, -2, 3, 3, 3, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'082ef01dd4f24465b6823c5e9e200809', 0, 1, 10, N'99212 Office or other outpatient visit for the evaluation and management of an established patient, which requires at least two of these three key components:  a problem focused history, a problem focused examination, and straightforward medical decision making.  Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are self limited or minor. Physicians typically spend 10 minutes face-to-face with the patient and/or family.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99212', 10001005, -2, 2, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, 10, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'098501a280fe45c5b9e132fdb1257b7d', 1, 1, -1, N'99281 Emergency department visit for the evaluation and management of a patient, which requires these three key components: a problem focused history, a problem focused examination, and straightforward medical decision making.  Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are self limited or minor.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99281', 14001890, -2, 3, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'0a0f1523774d4e76a0538964869d0da7', 1, 1, 0, N'Interprofessional telephone/Internet/electronic health record assessment and management service provided by a consultative physician including a verbal and written report to the patient''s treating/requesting physician or other qualified health care professional; 11-20 minutes of medical consultative discussion and review', CAST(N'2019-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99447', 29509510, -2, 0, 0, 0, 0, 0, 364635, 11, 20, 13, 2, 0, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'0a463341fd5c44ea8869bbaee886872b', 1, 1, -1, N'99475  Initial inpatient pediatric critical care, per day, for the evaluation and management of a critically ill infant or young child, 2 through 5 years of age.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99475', 30504686, -2, 0, 0, 0, 0, 730, 2190, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'0a86f785a6d94e1192b15a451d5fd3cf', 1, 1, -1, N'90828  Individual psychotherapy, interactive, using play equipment, physical devices, language interpreter, or other mechanisms of non-verbal communication, in an inpatient hospital, partial hospital or residential care setting, approximately 75 to 80 minutes face-to-face with the patient', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90828', 34005900, -2, 0, 0, 0, 0, 0, 364635, 75, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'0c7c9fe1705445fa943875397d5e2252', 1, 1, -1, N'90805  Individual psychotherapy, insight oriented, behavior modifying and/or supportive, in an office or outpatient facility with medical evaluation and management services, approximately 20 - 30 minutes face-to-face with the patient.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2009-12-31T23:59:00.000' AS DateTime), N'90805', 33005400, -2, 0, 0, 0, 0, 0, 364635, 20, 35, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'0c94b070ddec4b079d76d11f8a4d1bee', 1, 1, -1, N'90824  Individual psychotherapy, interactive, using play equipment, physical devices, language interpreter, or other mechanisms of non-verbal communication, in an inpatient hospital, partial hospital or residential care setting, approximately 20 to 30 minutes face-to-face with the patient with medical evaluation and management services.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2009-12-31T23:59:00.000' AS DateTime), N'90824', 34006000, -2, 0, 0, 0, 0, 0, 364635, 20, 35, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'0c9f44a918ea4082a874ad5d484f0906', 1, 1, -1, N'99469  Subsequent inpatient neonatal critical care, per day, for the evaluation and management of a critically ill neonate, 28 days of age or less.', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99469', 30504682, -2, 0, 0, 0, 0, 0, 29, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'0d00fa473dbb4fe7a67e14fa105ac94a', 1, 1, -1, N'99316 Nursing facility discharge day management; more than 30 minutes', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99316', 20002950, -2, 0, -1, -1, -1, 0, 364635, 31, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'0d32c7670b1e40a5a6ecb8d1dae6d95a', 1, 1, -1, N'99468  Initial inpatient neonatal critical care, per day, for the evaluation and management of a critically ill neonate, 28 days of age or less.', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99468', 30504680, -2, 0, 0, 0, 0, 0, 29, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'0e9d801b11924741be00857475533722', 1, 0, -1, N'99386  Initial comprehensive preventive medicine evaluation and management of an individual including an AGE and GENDER APPROPRIATE HISTORY, EXAMINATION, counseling/anticipatory guidance/risk factor reduction interventions, and the ordering of appropriate immunization(s), laboratory/diagnostic procedures, new patient;  age 40 - 64  years', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99386', 28003840, -2, 0, -1, -1, -1, 14600, 23725, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 6)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'0fb0bcf5e7974114bd906b7844d9a7fc', 1, 0, 75, N'99328 Domiciliary rest home visit for the evaluation and management of a new patient, which requires these 3 key components: a comprehensive history, a comprehensive examination, and medical decision making of high complexity. Counseling and/or coordination of care with other physicians, other qualified health care professionals, or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs. Usually, the patient is unstable or has developed a significant new problem requiring immediate physician attention.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99328', 2100, -2, 3, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'0fc26e263b7b4771b5db1e65e4055bfb', 1, 1, -1, N'99499  Unlisted evaluation and management service', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99499', 3100, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'1074a8ad40fb4d89b191cad766588bc3', 1, 0, -1, N'99461  Initial care, per day, for evaluation and management of normal newborn infant seen in other than hospital or birthing center', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'99461', 30104520, -2, 1, -1, 1, -1, 0, 28, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'109ebb4565c446f2a379f979731afaf7', 1, 0, 75, N'99345 Home visit for the evaluation and management of a new patient, which requires these three key components:  a comprehensive history, a comprehensive examination, and a medical decision making of high complexity.  Usually, the patient is unstable or has developed a significant new problem requiring immediate physician attention.  Physicians typically spend 75 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99345', 23003100, -2, 3, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'11112d68b4ab453e8d49de81acc3ebe9', 1, 1, -1, N'99289 Critical care services delivered by a physician, face-to-face, during an interfacility transport of critically ill or critically injured pediatric patient, 24 months of age or less; first 30-74 minutes of hands on care during transport', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99289', 15008000, -2, 0, -1, -1, -1, 0, 730, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15235a44961f4d8b96a4b8d282b9732b', 1, 1, -1, N'90822  Individual psychotherapy, insight oriented, behavior and/or supportive, in an inpatient hospital, partial hospital or residential care setting, approximately 75 to 80 minutes face-to-face with the patient with medical evaluation and management services', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90822', 34005800, -2, 0, 0, 0, 0, 0, 364635, 75, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'155aace7db7249a2891f4cc124590fbd', 1, 1, 0, N'Psychotherapy, 45 minutes with patient.', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90834', 35003545, -2, 0, 0, 0, 0, 0, 364635, 38, 52, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d251', 1, 1, -1, N'90791  Psychiatric diagnostic evaluation', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90791', 35003510, -2, 0, 0, 0, 0, 0, 364635, 0, 999, 24, -1, -1, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2510', 1, 0, 60, N'99205  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 60-74 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99205', 1000, -2, 0, -1, -1, -1, 0, 364635, 60, 999, NULL, NULL, NULL, 74, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25100', 1, 0, 125, N'99345  Home or residence visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99345', 2300, -2, 0, -1, -1, -1, 0, 364635, 75, 999, 28, 1, 0, -1, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25101', 0, 1, -1, N'99347  Home or residence visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using total time on the date of the encounter for code selection, 20 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99347', 2300, -2, 1, -1, -1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25102', 0, 1, -1, N'99347  Home or residence visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using total time on the date of the encounter for code selection, 20 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99347', 2300, -2, 0, -1, -1, -1, 0, 364635, 20, 29, NULL, NULL, NULL, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25103', 0, 1, -1, N'99348  Home or residence visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99348', 2300, -2, 1, -1, -1, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25104', 0, 1, -1, N'99348  Home or residence visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99348', 2300, -2, 0, -1, -1, -1, 0, 364635, 30, 39, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25105', 0, 1, -1, N'99349  Home or residence visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99349', 2300, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25106', 0, 1, -1, N'99349  Home or residence visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99349', 2300, -2, 0, -1, -1, -1, 0, 364635, 40, 59, NULL, NULL, NULL, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25107', 0, 1, 60, N'99350  Home or residence visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99350', 2300, -2, 1, -1, -1, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25108', 0, 1, 60, N'99350  Home or residence visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99350', 2300, -2, 0, -1, -1, -1, 0, 364635, 60, 999, NULL, NULL, NULL, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25109', 0, 1, 60, N'99350  Home or residence visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99350', 2300, -2, 0, -1, -1, -1, 0, 364635, 60, 999, 28, 0, 1, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2511', 1, 0, 60, N'99205  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 60-74 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99205', 1000, -2, 0, -1, -1, -1, 0, 364635, 60, 999, 28, 0, 1, 74, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25110', 0, 1, 95, N'99350  Home or residence visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99350', 2300, -2, 0, -1, -1, -1, 0, 364635, 60, 999, 28, 1, 0, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25111', 1, 1, 0, N'Interprofessional telephone/Internet/electronic health record assessment and management service provided by a consultative physician or other qualified health care professional including a verbal and written report to the patient''s treating/requesting physician or other qualified health care professional; 5-10 minutes of medical consultative discussion and review', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99446', 29509510, -2, 0, 0, 0, 0, 0, 364635, 5, 10, 13, 2, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25112', 1, 1, 0, N'Interprofessional telephone/Internet/electronic health record assessment and management service provided by a consultative physician or other qualified health care professional including a verbal and written report to the patient''s treating/requesting physician or other qualified health care professional; 11-20 minutes of medical consultative discussion and review', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99447', 29509510, -2, 0, 0, 0, 0, 0, 364635, 11, 20, 13, 2, 0, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25113', 1, 1, 0, N'Interprofessional telephone/Internet/electronic health record assessment and management service provided by a consultative physician or other qualified health care professional including a verbal and written report to the patient''s treating/requesting physician or other qualified health care professional; 21-30 minutes of medical consultative discussion and review', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99448', 29509510, -2, 0, 0, 0, 0, 0, 364635, 21, 30, 13, 2, 0, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25114', 1, 1, 0, N'Interprofessional telephone/Internet/electronic health record assessment and management service provided by a consultative physician or other qualified health care professional including a verbal and written report to the patient''s treating/requesting physician or other qualified health care professional; 31 minutes or more of medical consultative discussion and review', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99449', 29509510, -2, 0, 0, 0, 0, 0, 364635, 31, 999, 13, 2, 0, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25115', 1, 1, -1, N'99450  Basic life and/or disability examination that includes: Measurement of height, weight, and blood pressure; Completion of a medical history following a life insurance pro forma; Collection of blood sample and/or urinalysis complying with "chain of custody" protocols; and Completion of necessary documentation/certificates.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99450', 30004300, -2, 0, 0, 0, 0, 0, 364635, 0, 999, 25, 4, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25116', 1, 1, 0, N'Interprofessional telephone/Internet/electronic health record assessment and management service provided by a consultative physician or other qualified health care professional including a written report to the patient''s treating/requesting physician or other qualified health care professional; 5-10 minutes of medical consultative discussion time', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99451', 29509510, -2, 0, 0, 0, 0, 0, 364635, 5, 999, 13, 1, 1, -1, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25117', 1, 1, 0, N'Interprofessional telephone/Internet/electronic health record referral service(s) provided by a treating/requesting physician or other qualified health care professional; 30 minutes', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99452', 29509520, -2, 0, 0, 0, 0, 0, 364635, 16, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25118', 1, 1, -1, N'99455  Work related or medical disability examination by the treating physician that includes: Completion of a medical history commensurate with the patient''s condition; Performance of an examination commensurate with the patient''s condition; Formulation of a diagnosis, assessment of capabilities and stability, and calculation of impairment; Development of future medical treatment plan; and Completion of necessary documentation/certificates and report.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99455', 43504400, -2, 0, 0, 0, 0, 0, 364635, 0, 999, 26, 5, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25119', 1, 1, -1, N'99456  Work related or medical disability examination by other than the treating physician that includes: Completion of a medical history commensurate with the patient''s condition; Performance of an examination commensurate with the patient''s condition; Formulation of a diagnosis, assessment of capabilities and stability, and calculation of impairment; Development of future medical treatment plan; and Completion of necessary documentation/certificates and report.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99456', 43504500, -2, 0, 0, 0, 0, 0, 364635, 0, 999, 26, 5, 0, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2512', 1, 0, 74, N'99205  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 60-74 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99205', 1000, -2, 0, -1, -1, -1, 0, 364635, 60, 999, 28, 1, 0, 74, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25120', 1, 1, 60, N'99483  Assessment of and care planning for a patient with cognitive impairment, requiring an independent historian, in the office or other outpatient, home or domiciliary or rest home, with all of the following required elements: Cognition-focused evaluation including a pertinent history and examination, Medical decision making of moderate or high complexity, Functional assessment (eg, basic and instrumental activities of daily living), including decision-making capacity, Use of standardized instruments for staging of dementia (eg, functional assessment staging test [FAST], clinical dementia rating [CDR]), Medication reconciliation and review for high-risk medications, Evaluation for neuropsychiatric and behavioral symptoms, including depression, including use of standardized screening instrument(s), Evaluation of safety (eg, home), including motor vehicle operation, Identification of caregiver(s), caregiver knowledge, caregiver needs, social supports, and the willingness of caregiver to take on caregiving tasks, Development, updating or revision, or review of an Advance Care Plan, Creation of a written care plan, including initial plans to address any neuropsychiatric symptoms, neuro-cognitive symptoms, functional limitations, and referral to community resources as needed (eg, rehabilitation services, adult day programs, support groups) shared with the patient and/or caregiver with initial education and support. Typically, 60 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99483', 4325, -2, 1, -1, -1, 3, 0, 364635, 0, 999, 10, -1, -1, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d25121', 1, 1, 85, N'99483  Assessment of and care planning for a patient with cognitive impairment, requiring an independent historian, in the office or other outpatient, home or domiciliary or rest home, with all of the following required elements: Cognition-focused evaluation including a pertinent history and examination, Medical decision making of moderate or high complexity, Functional assessment (eg, basic and instrumental activities of daily living), including decision-making capacity, Use of standardized instruments for staging of dementia (eg, functional assessment staging test [FAST], clinical dementia rating [CDR]), Medication reconciliation and review for high-risk medications, Evaluation for neuropsychiatric and behavioral symptoms, including depression, including use of standardized screening instrument(s), Evaluation of safety (eg, home), including motor vehicle operation, Identification of caregiver(s), caregiver knowledge, caregiver needs, social supports, and the willingness of caregiver to take on caregiving tasks, Development, updating or revision, or review of an Advance Care Plan, Creation of a written care plan, including initial plans to address any neuropsychiatric symptoms, neuro-cognitive symptoms, functional limitations, and referral to community resources as needed (eg, rehabilitation services, adult day programs, support groups) shared with the patient and/or caregiver with initial education and support. Typically, 60 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99483', 4325, -2, 1, -1, -1, 3, 0, 364635, 0, 999, 10, 10, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2513', 0, 1, -1, N'99211  Office or other outpatient visit for the evaluation and management of an established patient that may not require the presence of a physician or other qualified health care professional', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99211', 1000, -2, 0, -1, -1, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2514', 0, 1, -1, N'99212  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using time for code selection, 10-19 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99212', 1000, -2, 1, -1, -1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, 19, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2515', 0, 1, -1, N'99212  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using time for code selection, 10-19 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99212', 1000, -2, 0, -1, -1, 1, 0, 364635, 10, 19, NULL, NULL, NULL, 19, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2516', 0, 1, -1, N'99213  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using time for code selection, 20-29 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99213', 1000, -2, 1, -1, -1, 2, 0, 364635, 0, 999, NULL, NULL, NULL, 29, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2517', 0, 1, -1, N'99213  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using time for code selection, 20-29 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99213', 1000, -2, 0, -1, -1, 2, 0, 364635, 20, 29, NULL, NULL, NULL, 29, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2518', 0, 1, -1, N'99214  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using time for code selection, 30-39 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99214', 1000, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, 39, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2519', 0, 1, -1, N'99214  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using time for code selection, 30-39 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99214', 1000, -2, 0, -1, -1, 3, 0, 364635, 30, 39, NULL, NULL, NULL, 39, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d252', 1, 1, -1, N'90792  Psychiatric diagnostic evaluation with medical services', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90792', 35003520, -2, 0, 0, 0, 0, 0, 364635, 0, 999, 24, -1, -1, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2520', 0, 1, 40, N'99215  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99215', 1000, -2, 1, -1, -1, 4, 0, 364635, 0, 999, NULL, NULL, NULL, 54, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2521', 0, 1, 40, N'99215  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99215', 1000, -2, 0, -1, -1, 4, 0, 364635, 40, 999, NULL, NULL, NULL, 54, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2522', 0, 1, 40, N'99215  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99215', 1000, -2, 0, -1, -1, 4, 0, 364635, 40, 999, 28, 0, 1, 54, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2523', 0, 1, 54, N'99215  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99215', 1000, -2, 0, -1, -1, 4, 0, 364635, 40, 999, 28, 1, 0, 54, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2524', 1, 1, -1, N'99221  Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and straightforward or low level medical decision making. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99221', 12001175, -2, 1, -1, -1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2525', 1, 1, -1, N'99221  Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and straightforward or low level medical decision making. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99221', 12001175, -2, 0, -1, -1, -1, 0, 364635, 40, 54, NULL, NULL, NULL, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2526', 1, 1, -1, N'99222  Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 55 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99222', 12001175, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2527', 1, 1, -1, N'99222  Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 55 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99222', 12001175, -2, 0, -1, -1, -1, 0, 364635, 55, 74, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2528', 1, 1, 75, N'99223  Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99223', 12001175, -2, 1, -1, -1, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2529', 1, 1, 75, N'99223  Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99223', 12001175, -2, 0, -1, -1, -1, 0, 364635, 75, 999, NULL, NULL, NULL, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d253', 1, 0, -1, N'99202  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using time for code selection, 15-29 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99202', 1000, -2, 1, -1, -1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, 29, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2530', 1, 1, 75, N'99223  Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99223', 12001175, -2, 0, -1, -1, -1, 0, 364635, 75, 999, 28, 0, 1, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2531', 1, 1, 75, N'99223  Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99223', 12001175, -2, 0, -1, -1, -1, 0, 364635, 75, 999, 28, 1, 0, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2532', 1, 1, -1, N'99231  Subsequent hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and straightforward or low level of medical decision making. When using total time on the date of the encounter for code selection, 25 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99231', 12001300, -2, 1, -1, -1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2533', 1, 1, -1, N'99231  Subsequent hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and straightforward or low level of medical decision making. When using total time on the date of the encounter for code selection, 25 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99231', 12001300, -2, 0, -1, -1, -1, 0, 364635, 25, 34, NULL, NULL, NULL, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2534', 1, 1, -1, N'99232  Subsequent hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 35 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99232', 12001300, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2535', 1, 1, -1, N'99232  Subsequent hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 35 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99232', 12001300, -2, 0, -1, -1, -1, 0, 364635, 35, 49, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2536', 1, 1, 50, N'99233  Subsequent hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 50 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99233', 12001300, -2, 1, -1, -1, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 3)
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2537', 1, 1, 50, N'99233  Subsequent hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 50 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99233', 12001300, -2, 0, -1, -1, -1, 0, 364635, 50, 999, NULL, NULL, NULL, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2538', 1, 1, 50, N'99233  Subsequent hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 50 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99233', 12001300, -2, 0, -1, -1, -1, 0, 364635, 50, 999, 28, 0, 1, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2539', 1, 1, 50, N'99233  Subsequent hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 50 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99233', 12001300, -2, 0, -1, -1, -1, 0, 364635, 50, 999, 28, 1, 0, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d254', 1, 0, -1, N'99202  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using time for code selection, 15-29 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99202', 1000, -2, 0, -1, -1, -1, 0, 364635, 15, 29, NULL, NULL, NULL, 29, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2540', 1, 1, -1, N'99234  Hospital inpatient or observation care, for the evaluation and management of a patient including admission and discharge on the same date, which requires a medically appropriate history and/or examination and straightforward or low level of medical decision making. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99234', 12001400, -2, 1, -1, -1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2541', 1, 1, -1, N'99234  Hospital inpatient or observation care, for the evaluation and management of a patient including admission and discharge on the same date, which requires a medically appropriate history and/or examination and straightforward or low level of medical decision making. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99234', 12001400, -2, 0, -1, -1, -1, 0, 364635, 45, 69, NULL, NULL, NULL, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2542', 1, 1, -1, N'99235  Hospital inpatient or observation care, for the evaluation and management of a patient including admission and discharge on the same date, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 70 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99235', 12001400, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2543', 1, 1, -1, N'99235  Hospital inpatient or observation care, for the evaluation and management of a patient including admission and discharge on the same date, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 70 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99235', 12001400, -2, 0, -1, -1, -1, 0, 364635, 70, 84, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2544', 1, 1, 85, N'99236  Hospital inpatient or observation care, for the evaluation and management of a patient including admission and discharge on the same date, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 85 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99236', 12001400, -2, 1, -1, -1, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2545', 1, 1, 85, N'99236  Hospital inpatient or observation care, for the evaluation and management of a patient including admission and discharge on the same date, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 85 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99236', 12001400, -2, 0, -1, -1, -1, 0, 364635, 85, 999, NULL, NULL, NULL, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2546', 1, 1, 85, N'99236  Hospital inpatient or observation care, for the evaluation and management of a patient including admission and discharge on the same date, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 85 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99236', 12001400, -2, 0, -1, -1, -1, 0, 364635, 85, 999, 28, 0, 1, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2547', 1, 1, 95, N'99236  Hospital inpatient or observation care, for the evaluation and management of a patient including admission and discharge on the same date, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 85 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99236', 12001400, -2, 0, -1, -1, -1, 0, 364635, 85, 999, 28, 1, 0, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2548', 1, 1, -1, N'99238  Hospital inpatient or observation discharge day management; 30 minutes or less on the date of the encounter', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99238', 12001600, -2, 0, -1, -1, -1, 0, 364635, 0, 30, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2549', 1, 1, -1, N'99239  Hospital inpatient or observation discharge day management; more than 30 minutes on the date of the encounter', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99239', 12001600, -2, 0, -1, -1, -1, 0, 364635, 31, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d255', 1, 0, -1, N'99203  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using time for code selection, 30-44 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99203', 1000, -2, 1, -1, -1, 2, 0, 364635, 0, 999, NULL, NULL, NULL, 44, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2550', 1, 1, -1, N'99242  Office or other outpatient consultation for a new or established patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using total time on the date of the encounter for code selection, 20 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99242', 13001700, -2, 1, -1, -1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2551', 1, 1, -1, N'99242  Office or other outpatient consultation for a new or established patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using total time on the date of the encounter for code selection, 20 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99242', 13001700, -2, 0, -1, -1, -1, 0, 364635, 20, 29, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2552', 1, 1, -1, N'99243  Office or other outpatient consultation for a new or established patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99243', 13001700, -2, 1, -1, -1, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2553', 1, 1, -1, N'99243  Office or other outpatient consultation for a new or established patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99243', 13001700, -2, 0, -1, -1, -1, 0, 364635, 30, 39, NULL, NULL, NULL, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2554', 1, 1, -1, N'99244  Office or other outpatient consultation for a new or established patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99244', 13001700, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2555', 1, 1, -1, N'99244  Office or other outpatient consultation for a new or established patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99244', 13001700, -2, 0, -1, -1, -1, 0, 364635, 40, 54, NULL, NULL, NULL, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2556', 1, 1, 55, N'99245  Office or other outpatient consultation for a new or established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 55 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99245', 13001700, -2, 1, -1, -1, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2557', 1, 1, 55, N'99245  Office or other outpatient consultation for a new or established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 55 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99245', 13001700, -2, 0, -1, -1, -1, 0, 364635, 55, 999, NULL, NULL, NULL, -1, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2558', 1, 1, -1, N'99252  Inpatient or observation consultation for a new or established patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using total time on the date of the encounter for code selection, 35 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99252', 13001800, -2, 1, -1, -1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2559', 1, 1, -1, N'99252  Inpatient or observation consultation for a new or established patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using total time on the date of the encounter for code selection, 35 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99252', 13001800, -2, 0, -1, -1, -1, 0, 364635, 35, 44, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d256', 1, 0, -1, N'99203  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using time for code selection, 30-44 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99203', 1000, -2, 0, -1, -1, -1, 0, 364635, 30, 44, NULL, NULL, NULL, 44, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2560', 1, 1, -1, N'99253  Inpatient or observation consultation for a new or established patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99253', 13001800, -2, 1, -1, -1, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2561', 1, 1, -1, N'99253  Inpatient or observation consultation for a new or established patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99253', 13001800, -2, 0, -1, -1, -1, 0, 364635, 45, 59, NULL, NULL, NULL, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2562', 1, 1, -1, N'99254  Inpatient or observation consultation for a new or established patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99254', 13001800, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2563', 1, 1, -1, N'99254  Inpatient or observation consultation for a new or established patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99254', 13001800, -2, 0, -1, -1, -1, 0, 364635, 60, 79, NULL, NULL, NULL, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2564', 1, 1, 80, N'99255  Inpatient or observation consultation for a new or established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 80 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99255', 13001800, -2, 1, -1, -1, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2565', 1, 1, 80, N'99255  Inpatient or observation consultation for a new or established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 80 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99255', 13001800, -2, 0, -1, -1, -1, 0, 364635, 80, 999, NULL, NULL, NULL, -1, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2566', 1, 1, -1, N'99281  Emergency department visit for the evaluation and management of a patient that may not require the presence of a physician or other qualified health care professional', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99281', 14001890, -2, 0, -1, -1, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2567', 1, 1, -1, N'99282  Emergency department visit for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and straightforward medical decision making', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99282', 14001890, -2, 1, -1, -1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2568', 1, 1, -1, N'99283  Emergency department visit for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and low level of medical decision making', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99283', 14001890, -2, 1, -1, -1, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2569', 1, 1, -1, N'99284  Emergency department visit for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99284', 14001890, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d257', 1, 0, -1, N'99204  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using time for code selection, 45-59 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99204', 1000, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, 59, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2570', 1, 1, -1, N'99285  Emergency department visit for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99285', 14001890, -2, 1, -1, -1, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2571', 1, 1, -1, N'99304  Initial nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and straightforward or low level of medical decision making. When using total time on the date of the encounter for code selection, 25 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99304', 20002780, -2, 1, -1, -1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2572', 1, 1, -1, N'99304  Initial nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and straightforward or low level of medical decision making. When using total time on the date of the encounter for code selection, 25 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99304', 20002780, -2, 0, -1, -1, -1, 0, 364635, 25, 34, NULL, NULL, NULL, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2573', 1, 1, -1, N'99305  Initial nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 35 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99305', 20002780, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2574', 1, 1, -1, N'99305  Initial nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 35 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99305', 20002780, -2, 0, -1, -1, -1, 0, 364635, 35, 44, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2575', 1, 1, 45, N'99306  Initial nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99306', 20002780, -2, 1, -1, -1, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2576', 1, 1, 45, N'99306  Initial nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99306', 20002780, -2, 0, -1, -1, -1, 0, 364635, 45, 999, NULL, NULL, NULL, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2577', 1, 1, 45, N'99306  Initial nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99306', 20002780, -2, 0, -1, -1, -1, 0, 364635, 45, 999, 28, 0, 1, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2578', 1, 1, 80, N'99306  Initial nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99306', 20002780, -2, 0, -1, -1, -1, 0, 364635, 45, 999, 28, 1, 0, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2579', 1, 1, -1, N'99307  Subsequent nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using total time on the date of the encounter for code selection, 10 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99307', 20002900, -2, 1, -1, -1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d258', 1, 0, -1, N'99204  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using time for code selection, 45-59 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99204', 1000, -2, 0, -1, -1, -1, 0, 364635, 45, 59, NULL, NULL, NULL, 59, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2580', 1, 1, -1, N'99307  Subsequent nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using total time on the date of the encounter for code selection, 10 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99307', 20002900, -2, 0, -1, -1, -1, 0, 364635, 10, 14, NULL, NULL, NULL, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2581', 1, 1, -1, N'99308  Subsequent nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using total time on the date of the encounter for code selection, 15 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99308', 20002900, -2, 1, -1, -1, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2582', 1, 1, -1, N'99308  Subsequent nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using total time on the date of the encounter for code selection, 15 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99308', 20002900, -2, 0, -1, -1, -1, 0, 364635, 15, 29, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2583', 1, 1, -1, N'99309  Subsequent nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99309', 20002900, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2584', 1, 1, -1, N'99309  Subsequent nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99309', 20002900, -2, 0, -1, -1, -1, 0, 364635, 30, 44, NULL, NULL, NULL, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2585', 1, 1, 45, N'99310  Subsequent nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99310', 20002900, -2, 1, -1, -1, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2586', 1, 1, 45, N'99310  Subsequent nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99310', 20002900, -2, 0, -1, -1, -1, 0, 364635, 45, 999, NULL, NULL, NULL, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2587', 1, 1, 45, N'99310  Subsequent nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99310', 20002900, -2, 0, -1, -1, -1, 0, 364635, 45, 999, 28, 0, 1, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2588', 1, 1, 70, N'99310  Subsequent nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99310', 20002900, -2, 0, -1, -1, -1, 0, 364635, 45, 999, 28, 1, 0, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2589', 1, 1, -1, N'99315  Nursing facility discharge management; 30 minutes or less total time on the date of the encounter', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99315', 20002950, -2, 0, 0, 0, 0, 0, 364635, 0, 30, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d259', 1, 0, 60, N'99205  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 60-74 minutes of total time is spent on the date of the encounter.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99205', 1000, -2, 1, -1, -1, 4, 0, 364635, 0, 999, NULL, NULL, NULL, 74, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2590', 1, 1, -1, N'99316  Nursing facility discharge management; more than 30 minutes total time on the date of the encounter', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99316', 20002950, -2, 0, 0, 0, 0, 0, 364635, 31, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2591', 1, 0, -1, N'99341  Home or residence visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using total time on the date of the encounter for code selection, 15 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99341', 2300, -2, 1, -1, -1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2592', 1, 0, -1, N'99341  Home or residence visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using total time on the date of the encounter for code selection, 15 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99341', 2300, -2, 0, -1, -1, -1, 0, 364635, 15, 29, NULL, NULL, NULL, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2593', 1, 0, -1, N'99342  Home or residence visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99342', 2300, -2, 1, -1, -1, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2594', 1, 0, -1, N'99342  Home or residence visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99342', 2300, -2, 0, -1, -1, -1, 0, 364635, 30, 59, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2595', 1, 0, -1, N'99344  Home or residence visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99344', 2300, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2596', 1, 0, -1, N'99344  Home or residence visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99344', 2300, -2, 0, -1, -1, -1, 0, 364635, 60, 74, NULL, NULL, NULL, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2597', 1, 0, 75, N'99345  Home or residence visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99345', 2300, -2, 1, -1, -1, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2598', 1, 0, 75, N'99345  Home or residence visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99345', 2300, -2, 0, -1, -1, -1, 0, 364635, 75, 999, NULL, NULL, NULL, -1, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'15d788a63a174bf9b037fea86e138d2599', 1, 0, 75, N'99345  Home or residence visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99345', 2300, -2, 0, -1, -1, -1, 0, 364635, 75, 999, 28, 0, 1, -1, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'16bf8d46f97f4cb1bd64d1bf3711d515', 1, 1, -1, N'99480  Subsequent intensive care, per day, for the evaluation and management of the recovering very low birth weight infant (present body weight 2501-5000 grams)', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99480', 30604696, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'16ea884022844b489bb9c39f68ea938a', 1, 1, -1, N'99412  Preventive medicine counseling and/or risk factor reduction intervention(s) provided to individuals in a group setting (separate procedure); approximately 60 minutes', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99412', 38954000, -2, 0, -1, -1, -1, 0, 364635, 46, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'1741eac271e14800a44c070056089522', 1, 1, -1, N'90853  Group psychotherapy (other than of a multiple-family group)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90853', 36006500, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'182d85777a9c4916b2428228400a07ab', 1, 0, -1, N'92004  Comprehensive ophthalmological services, new patient.  Medical examination and evaluation with initiation of diagnostic and treatment program, one or more visits.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'92004', 51005175, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'18746168a88a4d31bdbf713156fe3452', 1, 1, -1, N'90813  Individual psychotherapy, interactive, using play equipment, physical devices, language interpreter, or other mechanisms of non-verbal communication, in an office or outpatient facility with medical evaluation and management, approximately 45 - 50 minutes face-to-face with the patient.', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90813', 33005600, -2, 0, 0, 0, 0, 0, 364635, 45, 74, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'1a4cb85cf6484bb4ad69d7a39239a280', 1, 1, 50, N'99219 Initial observation care, per day, for the evaluation and management of a patient, which requires these three key components: a comprehensive history, a comprehensive examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission to outpatient hospital "observation status" are of moderate severity.', CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99219', 11001100, -2, 3, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'1ba1aa5005f64a068debe07141d535f1', 1, 1, 30, N'99221 Initial hospital care, per day, for the evaluation and management of a patient, which requires these three key components: a detailed or comprehensive history;  a detailed or comprehensive examination; and medical decision making that is straightforward or of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission are of low severity. Physicians typically spend 30 minutes at the bedside and on the patient''s hospital floor or unit.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'99221', 12001200, -2, 3, 3, 3, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'1be0816db3d0472b8777414373d204ae', 1, 1, -1, N'90818  Individual psychotherapy, insight oriented, behavior and/or supportive, in an inpatient hospital, partial hospital or residential care setting, approximately 45 to 50 minutes face-to-face with the patient', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2009-12-31T23:59:00.000' AS DateTime), N'90818', 34005700, -2, 0, 0, 0, 0, 0, 364635, 36, 65, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'1ca73e05b0fc4615a8abc29a58cfb97f', 0, 1, 25, N'99348  Home visit for the evaluation and management of an established patient, which requires two of these three key components:  1, 0) EXPANDED INTERVAL HISTORY,  2, 0) EXPANDED EXAMINATION  3, 0)  LOW COMPLEXITY MEDICAL DECISION.  Usually, the presenting problem(s) are of low to moderate complexity.  Physicians typically spend 25 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99348', 2300, -2, 2, 2, 2, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'1cb4c416b8fe47ad912dda1247542c65', 1, 0, -1, N'99383  Initial comprehensive preventive medicine evaluation and management of an individual including an AGE and GENDER APPROPRIATE HISTORY, EXAMINATION, counseling/anticipatory guidance/risk factor reduction interventions, and the ordering of appropriate immunization(s), laboratory/diagnostic procedures, new patient;  late childhood (age 5 through 11 years)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99383', 28003840, -2, 0, -1, -1, -1, 1825, 4380, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'1cbedfbaf7ae4a2882f06b12356eaf43', 1, 1, -1, N'99308 Subsequent nursing facility care, per day, for the evaluation and management of a patient, which requires at least two of these three key components:  an expanded problem focused interval history; an expanded problem focused examination;  medical decision making of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the patient is responding inadequately to therapy or has developed a minor complication.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2007-12-31T23:59:00.000' AS DateTime), N'99308', 20002900, -2, 2, 2, 2, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'1cf3d5682d5b4daabe2557bd3b0855de', 1, 1, -1, N'90889  Preparation of report of patient''s psychiatric status, history, treatment, or progress (other than for legal or consultative purposes) for other physicians, agencies, or insurance carriers', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90889', 37007600, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'1cf5ba50e0b444709ece347a9534af6e', 1, 1, 0, N'99485 Supervision by a control physician of interfacility transport care of the critically ill or critically injured pediatric patient, 24 months of age or younger, includes two - way communication with transport team before transport, at the referring facility and during the transport, including data interpretation and report; first 30 minutes. (Use 99486 in conjunction with 99485, 0) (For physician direction of emergency medical systems supervision for a pediatric patient older than 24 months of age, or at any age if not critically ill or injured, use 99288, 0) (Do not report 99485, 99486 with any other services reported by the control physician for the same period) (Do not report 99485, 99486 in conjunction with 99466, 99467 when performed by the same physician)', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99485', 30153030, -2, 0, 0, 0, 0, 0, 731, 16, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'1d9f5428c2d74f8997afe6597f1e874f', 1, 1, -1, N'98942  Chiropractic Manipulative Treatment (CMT) is a form of manual treatment to influence joint and neurophysiological function.  This treatment may be accomplished using a variety of techniques.  (CMT); spinal, five regions', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98942', 40008900, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'21a2c15cea27465fb9049d1592ee52a0', 1, 1, -1, N'99217 Observation care discharge day management (This code is to be utilized by the physician to report all services provided to a patient on discharge from "observation status" if the discharge is on other than the initial date of "observation status." To report services to a patient designated as "observation status" or "inpatient status" and discharged on the same date, use the codes for Observation or Inpatient Care Services [including Admission and Discharge Services, 99234-99236 as appropriate.])', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2017-12-31T23:59:00.000' AS DateTime), N'99217', 11001010, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'21b31687bb874f8c9dab5d126718e517', 1, 1, -1, N'90875  Individual psychophysiological therapy incorporating biofeedback training by any modality (face-to-face with the patient), with psychotherapy (eg, insight oriented, behavior modifying or supportive psychotherapy), approximately 20-30 minutes.', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90875', 37007100, -2, 0, 0, 0, 0, 0, 364635, 20, 44, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'21c269981fdd4d0e82771471f2c7d6e7', 0, 1, 15, N'99347  Home visit for the evaluation and management of an established patient, which requires two of these three key components:  1, 0) PROBLEM FOCUSED INTERVAL HISTORY,  2, 0) PROBLEM FOCUSED EXAMINATION  3, 0)  STRAIGHTFORWARD MEDICAL DECISION.  Usually, the presenting problem(s) are self-limited or minor.  Physicians typically spend 15 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99347', 2300, -2, 2, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'221c7d093def44e49af8b8bdc54fc1e6', 1, 1, -1, N'99471  Initial inpatient pediatric critical care, per day, for the evaluation and management of a critically ill infant or young child, 29 days through 24 months of age.', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99471', 30554686, -2, 0, 0, 0, 0, 29, 730, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'221f029772f24867819f67034ed1ad72', 0, 1, 40, N'99349 Home visit for the evaluation and management of an established patient, which requires two of these three key components:  a detailed interval history, a detailed examination, and a medical decision making of moderate complexity.  Usually, the presenting problem(s) are of moderate to high complexity.  Physicians usually spend 40 minutes face-to-face with the patient and/or family.', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99349', 23003200, -2, 2, 3, 3, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'22c00b39aa11483ca31b2d83907ccf8c', 1, 1, -1, N'90801  Psychiatric diagnostic interview examination', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90801', 35007800, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'22c45099ffb54f7ea817a51576b6febd', 1, 1, -1, N'99471  Initial inpatient pediatric critical care, per day, for the evaluation and management of a critically ill infant or young child, 29 days through 24 months of age.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99471', 30504686, -2, 0, 0, 0, 0, 29, 730, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'233d42c8d75746d6a041262efdd6d17f', 1, 1, -1, N'99294 Subsequent inpatient pediatric critical care, per day, for the evaluation and management of a critically ill infant or young child, 29 days through 24 months of age', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99294', 17002300, -2, 0, -1, -1, -1, 0, 730, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'2356a36a770e4caebff50bfeff896e43', 1, 1, 0, N'99495  Transitional Care Management Services with the following required elements:  1, 0)  Communication (direct contact, telephone, electronic) with the patient and/or caregiver within 2 business days of discharge, 2, 0) Medical decision making of at least moderate complexity during the service period, 3, 0) Face-to-face visit, within 14 calendar days', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2017-12-31T23:59:00.000' AS DateTime), N'99495', 44009300, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'23b4ed53ddbb4aa180ecf0ec2dcf1fb5', 1, 1, 50, N'99219 Initial observation care, per day, for the evaluation and management of a patient, which requires these three key components: a comprehensive history;  a comprehensive examination; and  medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission to "observation status" are of moderate severity.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'99219', 11001100, -2, 3, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'24083fcba50040379710aba5e03092ad', 1, 1, -1, N'99407 Smoking and tobacco use cessation counseling visit; intensive, greater than 10 minutes (Do not report 99407 in conjunction with 99406, 0)', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99407', 38953910, -2, 0, -1, -1, -1, 0, 364635, 11, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'247cf8abc1ad435fb2f890eff21588de', 1, 1, -1, N'99298 Subsequent intensive care, per day, for the evaluation and management of the recovering very low birth weight infant (present body weight less than 1500 grams).  Infants with present body weight less than 1500 grams who are not critically ill but continue to require intensive cardiac and respiratory monitoring, continuous and/or frequent vital sign monitoring, heat maintenance, enteral and/or parenteral nutritional adjustments, laboratory and oxygen monitoring and constant observation by the health care team under direct physician supervision.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99298', 19002500, -2, 0, -1, -1, -1, 0, 365, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'2489714c30a94c57b9bbd589fbcd4335', 1, 1, -1, N'99355  Prolonged physician service in the office or other outpatient setting requiring direct (face-to-face) patient contact beyond the usual service (e.g., prolonged care and treatment of an acute asthmatic patient in an outpatient setting); each additional 30 minutes', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99355', 24003300, -2, 0, -1, -1, -1, 0, 364635, 61, 90, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'24c03b9a-e5c9-4059-adf9-c4398305751b', 1, 1, -1, N'90792 Psychiatric diagnostic evaluation with medical services', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'90792', 35003520, -2, 2, 2, 1, 999, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'2510f4d2edec4763a97e94e565a728b9', 1, 1, -1, N'99412  Preventive medicine counseling and/or risk factor reduction intervention(s) provided to individuals in a group setting (separate procedure); approximately 60 minutes', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2007-12-31T23:59:00.000' AS DateTime), N'99412', 28004000, -2, 0, -1, -1, -1, 0, 364635, 31, 70, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'2684c7df17014db3b09a81b4589875d4', 1, 1, 25, N'99309 Subsequent nursing facility care, per day, for the evaluation and management of a patient, which requires at least two of these three key components:  a detailed interval history, a detailed examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the patient has developed a significant complication or a significant new problem.', CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99309', 20002900, -2, 2, 3, 3, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'268e2f3eabf14bf080d8cffbc8749e9f', 1, 1, -1, N'90810  Individual psychotherapy, interactive, using play equipment, physical devices, language interpreter, or other mechanisms of non-verbal communication, in an office or outpatient facility, approximately 20 - 30 minutes face-to-face with the patient.', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90810', 33005500, -2, 0, 0, 0, 0, 0, 364635, 20, 44, NULL, NULL, NULL, -1, 0, -1, -1, 1)
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'2739f0e0fc35482d8f43b51845dba697', 1, 1, -1, N'G0101 Well Woman (Pelvic & Breast)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2017-12-31T23:59:00.000' AS DateTime), N'G0101', 28003860, -2, 1, -1, 4, -1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27a4560a78bd48f799ab62bb1fccb351', 1, 1, 5, N'99406 Smoking and tobacco use cessation counseling visit; intermediate, greater than 3 minutes up to 10 minutes', CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99406', 28003910, -2, 0, 0, 0, 0, 0, 364635, 3, 10, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b081', 1, 0, -1, N'98000  Synchronous audio-video visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using total time on the date of the encounter for code selection, 15 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98000', 10501000, -2, 1, -1, -1, 1, 0, 364635, 0, 29, 31, -1, -1, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0810', 0, 1, -1, N'98004  Synchronous audio-video visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using total time on the date of the encounter for code selection, 10 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98004', 10501000, -2, 0, -1, -1, 0, 0, 364635, 10, 19, 31, -1, -1, -1, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0811', 0, 1, -1, N'98005  Synchronous audio-video visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and low medical decision making. When using total time on the date of the encounter for code selection, 20 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98005', 10501000, -2, 1, -1, -1, 2, 0, 364635, 0, 29, 31, -1, -1, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0812', 0, 1, -1, N'98005  Synchronous audio-video visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and low medical decision making. When using total time on the date of the encounter for code selection, 20 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98005', 10501000, -2, 0, -1, -1, 0, 0, 364635, 20, 29, 31, -1, -1, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0813', 0, 1, -1, N'98006  Synchronous audio-video visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and moderate medical decision making. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98006', 10501000, -2, 1, -1, -1, 3, 0, 364635, 0, 39, 31, -1, -1, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0814', 0, 1, -1, N'98006  Synchronous audio-video visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and moderate medical decision making. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98006', 10501000, -2, 0, -1, -1, 0, 0, 364635, 30, 39, 31, -1, -1, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0815', 0, 1, 40, N'98007  Synchronous audio-video visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high medical decision making. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98007', 10501000, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 31, -1, -1, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0816', 0, 1, 40, N'98007  Synchronous audio-video visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high medical decision making. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98007', 10501000, -2, 0, -1, -1, 0, 0, 364635, 40, 999, 31, -1, -1, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0817', 1, 0, -1, N'98008  Synchronous audio-only visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination, straightforward medical decision making, and more than 10 minutes of medical discussion. When using total time on the date of the encounter for code selection, 15 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98008', 10502000, -2, 1, -1, -1, 1, 0, 364635, 10, 29, 32, -1, -1, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0818', 1, 0, -1, N'98008  Synchronous audio-only visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination, straightforward medical decision making, and more than 10 minutes of medical discussion. When using total time on the date of the encounter for code selection, 15 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98008', 10502000, -2, 0, -1, -1, 0, 0, 364635, 15, 29, 32, -1, -1, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0819', 1, 0, -1, N'98009  Synchronous audio-only visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination, low medical decision making, and more than 10 minutes of medical discussion. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98009', 10502000, -2, 1, -1, -1, 2, 0, 364635, 10, 44, 32, -1, -1, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b082', 1, 0, -1, N'98000  Synchronous audio-video visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using total time on the date of the encounter for code selection, 15 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98000', 10501000, -2, 0, -1, -1, 0, 0, 364635, 15, 29, 31, -1, -1, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0820', 1, 0, -1, N'98009  Synchronous audio-only visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination, low medical decision making, and more than 10 minutes of medical discussion. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98009', 10502000, -2, 0, -1, -1, 0, 0, 364635, 30, 44, 32, -1, -1, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0821', 1, 0, -1, N'98010  Synchronous audio-only visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination, moderate medical decision making, and more than 10 minutes of medical discussion. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98010', 10502000, -2, 1, -1, -1, 3, 0, 364635, 10, 59, 32, -1, -1, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0822', 1, 0, -1, N'98010  Synchronous audio-only visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination, moderate medical decision making, and more than 10 minutes of medical discussion. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98010', 10502000, -2, 0, -1, -1, 0, 0, 364635, 45, 59, 32, -1, -1, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0823', 1, 0, 60, N'98011  Synchronous audio-only visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination, high medical decision making, and more than 10 minutes of medical discussion. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98011', 10502000, -2, 1, -1, -1, 4, 0, 364635, 10, 999, 32, -1, -1, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0824', 1, 0, 60, N'98011  Synchronous audio-only visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination, high medical decision making, and more than 10 minutes of medical discussion. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98011', 10502000, -2, 0, -1, -1, 0, 0, 364635, 60, 999, 32, -1, -1, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0825', 0, 1, -1, N'98012  Synchronous audio-only visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination, straightforward medical decision making, and more than 10 minutes of medical discussion. When using total time on the date of the encounter for code selection, 10 minutes must be exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98012', 10502000, -2, 1, -1, -1, 1, 0, 364635, 10, 19, 32, -1, -1, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0826', 0, 1, -1, N'98012  Synchronous audio-only visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination, straightforward medical decision making, and more than 10 minutes of medical discussion. When using total time on the date of the encounter for code selection, 10 minutes must be exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98012', 10502000, -2, 0, -1, -1, 0, 0, 364635, 10, 19, 32, -1, -1, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0827', 0, 1, -1, N'98013  Synchronous audio-only visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination, low medical decision making, and more than 10 minutes of medical discussion. When using total time on the date of the encounter for code selection, 20 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98013', 10502000, -2, 1, -1, -1, 2, 0, 364635, 10, 29, 32, -1, -1, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0828', 0, 1, -1, N'98013  Synchronous audio-only visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination, low medical decision making, and more than 10 minutes of medical discussion. When using total time on the date of the encounter for code selection, 20 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98013', 10502000, -2, 0, -1, -1, 0, 0, 364635, 20, 29, 32, -1, -1, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0829', 0, 1, -1, N'98014  Synchronous audio-only visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination, moderate medical decision making, and more than 10 minutes of medical discussion. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98014', 10502000, -2, 1, -1, -1, 3, 0, 364635, 10, 39, 32, -1, -1, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b083', 1, 0, -1, N'98001  Synchronous audio-video visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and low medical decision making. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98001', 10501000, -2, 1, -1, -1, 2, 0, 364635, 0, 44, 31, -1, -1, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0830', 0, 1, -1, N'98014  Synchronous audio-only visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination, moderate medical decision making, and more than 10 minutes of medical discussion. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98014', 10502000, -2, 0, -1, -1, 0, 0, 364635, 30, 39, 32, -1, -1, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0831', 0, 1, 40, N'98015  Synchronous audio-only visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination, high medical decision making, and more than 10 minutes of medical discussion. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98015', 10502000, -2, 1, -1, -1, 4, 0, 364635, 10, 999, 32, -1, -1, -1, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0832', 0, 1, 40, N'98015  Synchronous audio-only visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination, high medical decision making, and more than 10 minutes of medical discussion. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98015', 10502000, -2, 0, -1, -1, 0, 0, 364635, 40, 999, 32, -1, -1, -1, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b0833', 0, 1, -1, N'98016  Brief communication technology-based service (eg, virtual check-in) by a physician or other qualified health care professional who can report evaluation and management services, provided to an established patient, not originating from a related evaluation and management service provided within the previous 7 days nor leading to an evaluation and management service or procedure within the next 24 hours or soonest available appointment, 5-10 minutes of medical discussion', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98016', 10503000, -2, 0, -1, -1, 0, 0, 364635, 5, 999, 33, -1, -1, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b084', 1, 0, -1, N'98001  Synchronous audio-video visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and low medical decision making. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98001', 10501000, -2, 0, -1, -1, 0, 0, 364635, 30, 44, 31, -1, -1, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b085', 1, 0, -1, N'98002  Synchronous audio-video visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and moderate medical decision making. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98002', 10501000, -2, 1, -1, -1, 3, 0, 364635, 0, 59, 31, -1, -1, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b086', 1, 0, -1, N'98002  Synchronous audio-video visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and moderate medical decision making. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98002', 10501000, -2, 0, -1, -1, 0, 0, 364635, 45, 59, 31, -1, -1, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b087', 1, 0, 60, N'98003  Synchronous audio-video visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98003', 10501000, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 31, -1, -1, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b088', 1, 0, 60, N'98003  Synchronous audio-video visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98003', 10501000, -2, 0, -1, -1, 0, 0, 364635, 60, 999, 31, -1, -1, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'27d9e8e409794f0ba035f40457c01b089', 0, 1, -1, N'98004  Synchronous audio-video visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using total time on the date of the encounter for code selection, 10 minutes must be met or exceeded.', CAST(N'2025-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98004', 10501000, -2, 1, -1, -1, 1, 0, 364635, 0, 19, 31, -1, -1, -1, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'2803376a413b4091ad12992bc8e02a8f', 1, 1, 0, N'Interprofessional telephone/Internet assessment and management service provided by a consultative physician including a verbal and written report to the patient''s treating/requesting physician or other qualified health care professional; 31 minutes or more of medical consultative discussion and review', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2018-12-31T23:59:00.000' AS DateTime), N'99449', 29509500, -2, 0, 0, 0, 0, 0, 364635, 31, 999, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'29d02f15319a4c49b692cd86b1a730fb', 1, 1, -1, N'99315 Nursing facility discharge day management; 30 minutes or less', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99315', 20002950, -2, 0, -1, -1, -1, 0, 364635, 0, 30, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'2a0286d42bf849fda22f74d06f64e1ad', 0, 1, -1, N'92014  Comprehensive ophthalmological services, established patient.  Medical examination and evaluation with initiation or continuation of diagnostic and treatment program, one or more visits.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'92014', 52005275, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'2b3a884323c84e64b1bba61dd9bd2660', 1, 1, 50, N'99235 Observation or inpatient hospital care, for the evaluation and management of a patient including admission and discharge on the same date which requires these three key components: a comprehensive history, a comprehensive examination, and  medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually the presenting problem(s) requiring admission are of moderate severity.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99235', 1250, -2, 3, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'2b5d469c667b4df5a968c2b68222c8de', 1, 1, -1, N'98927  Osteopathic manipulative treatment (OMT) is a form of manual treatment applied by a physician to eliminate or alleviate somatic dysfunction and related disorders.  This treatment may be accomplished by a variety of techniques. (OMT); five to six body regions involved', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98927', 39008400, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'2c3b531418b1417ea56495ef37fec57a', 1, 1, -1, N'99455  Work related or medical disability examination by the treating physician that includes:  completion of a medical history commensurate with the patient''s condition;  performance of an examination commensurate with the patient''s condition; formulation of a diagnosis, assessment of capabilities and stability, and calculation of impairment; development of future medical treatment plan; and completion of necessary documentation/certificates and report.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99455', 30004500, -2, 3, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'2c692daa96dd418e9f5a32602e06f99e', 1, 1, 0, N'Interprofessional telephone/Internet/electronic health record assessment and management service provided by a consultative physician including a verbal and written report to the patient''s treating/requesting physician or other qualified health care professional; 31 minutes or more of medical consultative discussion and review', CAST(N'2019-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99449', 29509510, -2, 0, 0, 0, 0, 0, 364635, 31, 999, 13, 2, 0, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'2cee360abd134d558222f86b7c8ff139', 1, 0, -1, N'99435  History and examination of the normal newborn infant, including the preparation of medical records ( this code should only be used for newborns assessed and discharged from the hospital or birthing room on the same date)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99435', 29004200, -2, 2, 1, 1, 999, 0, 365, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'2ddfec5ed55a4bd797f8a9c8818b9691', 1, 1, -1, N'99499  Unlisted evaluation and management service', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'99499', 3100, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'2e56d6bc556b44bd941d70da14005ce6', 1, 1, 0, N'Remote monitoring of physiologic parameter(s) (eg, weight, blood pressure, pulse oximetry, respiratory flow rate), initial; set-up and patient education on use of equipment', CAST(N'2019-01-01T00:00:00.000' AS DateTime), CAST(N'2025-12-31T23:59:00.000' AS DateTime), N'99453', 29509610, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'2e689a02aa9f46629a24cc9ea3ff5d0d', 1, 1, -1, N'99375  Physician supervision of a patient under care of home health agency (patient not present) requiring complex and multidisciplinary care modalities involving regular physician development and/or revision of care plans, review of subsequent reports of patient status, review of laboratory and other studies, communication (including telephone calls) with other health care professionals involved in patient''s care, integration of new information into the medical treatment plan and/or adjustment of medical therapy, within a calendar month; 30 minutes or more', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99375', 27003810, -2, 0, -1, -1, -1, 0, 364635, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'2eb206add3e94bef9e56432296e5f5aa', 1, 1, -1, N'90806  Individual psychotherapy, insight oriented, behavior modifying and/or supportive, in an office or outpatient facility, approximately 45 - 50 minutes face-to-face with the patient.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2009-12-31T23:59:00.000' AS DateTime), N'90806', 33005300, -2, 0, 0, 0, 0, 0, 364635, 36, 65, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3065483671744cb58bcfd8a076b88fdc', 1, 1, -1, N'99363  Anticoagulant management for an outpatient taking warfarin, physician review and interpretation of International Normalized Ratio (INR) testing, patient instructions, dosage adjustments (as needed), and ordering of additional tests; initial 90 days of therapy (must include a minimum of 8 INR measurements)', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99363', 26503600, -2, 0, -1, -1, -1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3089ff5432c748cdb378126b9aa2012f', 1, 0, 30, N'99342 Home visit for the evaluation and management of a new patient, which requires these three key components:  an expanded problem focused history, an expanded problem focused examination, and a medical decision making of low complexity.  Usually, the presenting problem(s) are of moderate severity.  Physicians typically spend 30 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99342', 23003100, -2, 3, 2, 2, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'30e6f637b16441bda99a052da42d0755', 1, 1, -1, N'99472  Subsequent inpatient pediatric critical care, per day, for the evaluation and management of a critically ill infant or young child, 29 days through 24 months of age.', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99472', 30554688, -2, 0, 0, 0, 0, 29, 730, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'310553433752455cb8312a6aaf0d4aff', 1, 1, -1, N'90827  Individual psychotherapy, interactive, using play equipment, physical devices, language interpreter, or other mechanisms of non-verbal communication, in an inpatient hospital, partial hospital or residential care setting, approximately 45 to 50 minutes face-to-face with the patient with medical evaluation and management services', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2009-12-31T23:59:00.000' AS DateTime), N'90827', 34006000, -2, 0, 0, 0, 0, 0, 364635, 36, 65, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'31ba98363ceb49fe8a14811d3cb07848', 1, 1, -1, N'98940  Chiropractic Manipulative Treatment (CMT) is a form of manual treatment to influence joint and neurophysiological function.  This treatment may be accomplished using a variety of techniques.  (CMT); spinal, one to two regions', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98940', 40008700, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'32524fad06bc4020852ccf7e39c80f9a', 1, 1, -1, N'99411  Preventive medicine counseling and/or risk factor reduction intervention(s) provided to individuals in a group setting (separate procedure); approximately 30 minutes', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99411', 38954000, -2, 0, -1, -1, -1, 0, 364635, 16, 45, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'34aa705d75a0473e8ad2b66ed9c83e30', 1, 1, -1, N'99295 Initial inpatient neonatal critical care, per day, for the evaluation and management of a critically ill neonate, 28 days of age or less', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99295', 18002350, -2, 0, -1, -1, -1, 0, 365, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'351fa8ca6d794f999edee887fe60723a', 1, 1, -1, N'90813  Individual psychotherapy, interactive, using play equipment, physical devices, language interpreter, or other mechanisms of non-verbal communication, in an office or outpatient facility with medical evaluation and management, approximately 45 - 50 minutes face-to-face with the patient.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2009-12-31T23:59:00.000' AS DateTime), N'90813', 33005600, -2, 0, 0, 0, 0, 0, 364635, 36, 65, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3792b534f93a46538fccaaffd19be345', 1, 1, 0, N'99487  Complex chronic care coordination services; first hour of clinical staff time directed by a physician or other qualified health care professional with no face-to-face time visit, per calendar month', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99487', 43009100, -2, 0, 0, 0, 0, 0, 364635, 31, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'38198011ea3344d1bb3d6fcb27d85362', 1, 1, -1, N'99409 Alcohol and/or substance (other than tobacco) abuse structured screening (e.g., AUDIT, DAST), and brief intervention (SBI) services; greater than 30 minutes(Do not report 99409 in conjunction with 99408, 0) (Do not report 99408, 99409 in conjunction with 99420, 0) (Use 99408, 99409 only for initial screening and brief intervention)', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99409', 38953920, -2, 0, -1, -1, -1, 0, 364635, 31, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'39f33ebb846d45479e528804b800e3cb', 0, 1, 15, N'99334 Domiciliary rest home visit for the evaluation and management of an established patient, which requires these 2 key components: a problem focused interval history, a problem focused examination, and straightforward medical decision making. Counseling and/or coordination of care with other physicians, other qualified health care professionals, or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs. Usually, the presenting problem(s) are self-limited or minor.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99334', 2100, -2, 2, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3a5dbb41b0734989896ecb7b4c2defab', 0, 1, 5, N'99211 Office or other outpatient visit for the evaluation and management of an established patient, that may not require the presence of a physician or other qualified health care professional. Usually, the presenting problem(s) are minimal. Typically, 5 minutes are spent performing or supervising these services.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99211', 10001005, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, 5, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3aaf38ba18bf44ac8e2849f9883b1f6a', 1, 1, 20, N'99408 Alcohol and/or substance (other than tobacco) abuse structured screening (eg, AUDIT, DAST), and brief intervention (SBI) services; 15 to 30 minutes (Do not report services of less than 15 minutes with 99408, 0) (Do not report 99408, 99409 in conjunction with 99420, 0) (Use 99408, 99409 only for initial screening and brief intervention)', CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99408', 28003920, -2, 0, 0, 0, 0, 0, 364635, 15, 30, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3b761976cd9a42a8a78a3591f7c7ff72', 1, 1, -1, N'90846  Family psychotherapy (without the patient present)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2016-12-31T23:59:00.000' AS DateTime), N'90846', 36006200, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e10', 1, 0, 60, N'99205 Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 60-74 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99205', 10001000, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 19, 0, 1, 74, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e11', 1, 0, 74, N'99205 Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 60-74 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99205', 10001000, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 19, 1, 0, 74, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e12', 0, 1, -1, N'99211 Office or other outpatient visit for the evaluation and management of an established patient, that may not require the presence of a physician or other qualified health care professional. Usually, the presenting problem(s) are minimal.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2021-12-31T23:59:00.000' AS DateTime), N'99211', 10001005, -2, 0, -1, -1, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e13', 0, 1, -1, N'99212 Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using time for code selection, 10-19 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99212', 10001005, -2, 1, -1, -1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, 19, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e14', 0, 1, -1, N'99213 Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using time for code selection, 20-29 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99213', 10001005, -2, 1, -1, -1, 2, 0, 364635, 0, 999, NULL, NULL, NULL, 29, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e15', 0, 1, -1, N'99214 Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using time for code selection, 30-39 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99214', 10001005, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, 39, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e16', 0, 1, 40, N'99215 Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99215', 10001005, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 19, 0, 1, 54, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e17', 0, 1, 54, N'99215 Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99215', 10001005, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 19, 1, 0, 54, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e18', 1, 0, -1, N'99202 Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using time for code selection, 15-29 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99202', 10001000, -2, 0, -1, -1, 1, 0, 364635, 15, 29, NULL, NULL, NULL, 29, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e19', 1, 0, -1, N'99203 Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using time for code selection, 30-44 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99203', 10001000, -2, 0, -1, -1, 2, 0, 364635, 30, 44, NULL, NULL, NULL, 44, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e20', 1, 0, -1, N'99204 Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using time for code selection, 45-59 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99204', 10001000, -2, 0, -1, -1, 3, 0, 364635, 45, 59, NULL, NULL, NULL, 59, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e21', 1, 0, 60, N'99205 Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 60-74 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99205', 10001000, -2, 0, -1, -1, 4, 0, 364635, 60, 999, 19, 0, 1, 74, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e22', 1, 0, 74, N'99205 Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 60-74 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99205', 10001000, -2, 0, -1, -1, 4, 0, 364635, 60, 999, 19, 1, 0, 74, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e23', 0, 1, -1, N'99211 Office or other outpatient visit for the evaluation and management of an established patient, that may not require the presence of a physician or other qualified health care professional. Usually, the presenting problem(s) are minimal.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2021-12-31T23:59:00.000' AS DateTime), N'99211', 10001005, -2, 0, -1, -1, 0, 0, 364635, 0, 9, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e24', 0, 1, -1, N'99212 Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using time for code selection, 10-19 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99212', 10001005, -2, 0, -1, -1, 1, 0, 364635, 10, 19, NULL, NULL, NULL, 19, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e25', 0, 1, -1, N'99213 Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using time for code selection, 20-29 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99213', 10001005, -2, 0, -1, -1, 2, 0, 364635, 20, 29, NULL, NULL, NULL, 29, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e26', 0, 1, -1, N'99214 Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using time for code selection, 30-39 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99214', 10001005, -2, 0, -1, -1, 3, 0, 364635, 30, 39, NULL, NULL, NULL, 39, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e27', 0, 1, 40, N'99215 Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99215', 10001005, -2, 0, -1, -1, 4, 0, 364635, 40, 999, 19, 0, 1, 54, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e28', 0, 1, 54, N'99215 Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99215', 10001005, -2, 0, -1, -1, 4, 0, 364635, 40, 999, 19, 1, 0, 54, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e30', 1, 1, -1, N'99490 Chronic care management services with the following required elements: multiple (two or more) chronic conditions expected to last at least 12 months, or until the death of the patient, chronic conditions place the patient at significant risk of death, acute exacerbation/decompensation, or functional decline, comprehensive care plan established, implemented, revised, or monitored; first 20 minutes of clinical staff time directed by a physician or other qualified health care professional, per calendar month.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2021-12-31T23:59:00.000' AS DateTime), N'99490', 43509500, -2, 0, 0, 0, 0, 0, 364635, 20, 999, 1, 3, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e31', 1, 1, -1, N'99491 Chronic care management services, provided personally by a physician or other qualified health care professional, at least 30 minutes of physician or other qualified health care professional time, per calendar month, with the following required elements: multiple (two or more) chronic conditions expected to last at least 12 months, or until the death of the patient; chronic conditions place the patient at significant risk of death, acute exacerbation/decompensation, or functional decline; comprehensive care plan established, implemented, revised, or monitored.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2021-12-31T23:59:00.000' AS DateTime), N'99491', 43509500, -2, 0, 0, 0, 0, 0, 364635, 30, 999, 1, 4, 0, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e32', 1, 1, -1, N'99487 Complex chronic care management services with the following required elements: multiple (two or more) chronic conditions expected to last at least 12 months, or until the death of the patient, chronic conditions place the patient at significant risk of death, acute exacerbation/decompensation, or functional decline, comprehensive care plan established, implemented, revised, or monitored, moderate or high complexity medical decision making; first 60 minutes of clinical staff time directed by a physician or other qualified health care professional, per calendar month.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2021-12-31T23:59:00.000' AS DateTime), N'99487', 43509600, -2, 1, -1, -1, 3, 0, 364635, 60, 999, 2, 3, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e33', 1, 0, 60, N'99205 Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 60-74 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99205', 10001000, -2, 0, -1, -1, 4, 0, 364635, 60, 999, 19, 0, 0, 74, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e34', 0, 1, 40, N'99215 Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99215', 10001005, -2, 0, -1, -1, 4, 0, 364635, 40, 999, 19, 0, 0, 54, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e35', 1, 0, 60, N'99205 Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 60-74 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99205', 10001000, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 19, 0, 0, 74, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e36', 0, 1, 40, N'99215 Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99215', 10001005, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 19, 0, 0, 54, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e7', 1, 0, -1, N'99202 Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using time for code selection, 15-29 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99202', 10001000, -2, 1, -1, -1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, 29, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e8', 1, 0, -1, N'99203 Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using time for code selection, 30-44 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99203', 10001000, -2, 1, -1, -1, 2, 0, 364635, 0, 999, NULL, NULL, NULL, 44, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3bc18675e7c047ae91424d9a030131e9', 1, 0, -1, N'99204 Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using time for code selection, 45-59 minutes of total time is spent on the date of the encounter.', CAST(N'2021-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99204', 10001000, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, 59, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3be40211ba34466aa22c57c16325c894', 1, 1, -1, N'90876  Individual psychophysiological therapy incorporating biofeedback training by any modality (face-to-face with the patient), with psychotherapy (eg, insight oriented, behavior modifying or supportive psychotherapy), approximately 45-50 minutes.', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90876', 37007100, -2, 0, 0, 0, 0, 0, 364635, 38, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3c20efddf65e48c4a3d8973e20782177', 1, 0, 60, N'99327 Domiciliary rest home visit for the evaluation and management of a new patient, which requires these 3 key components: a comprehensive history, a comprehensive examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other physicians, other qualified health care professionals, or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs. Usually, the presenting problem(s) are of high severity.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99327', 2100, -2, 3, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3c7c8700eedc4c1e8803727ea012486a', 1, 1, 40, N'99409 Alcohol and/or substance (other than tobacco) abuse structured screening (e.g., AUDIT, DAST), and brief intervention (SBI) services; greater than 30 minutes(Do not report 99409 in conjunction with 99408, 0) (Do not report 99408, 99409 in conjunction with 99420, 0) (Use 99408, 99409 only for initial screening and brief intervention)', CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99409', 28003920, -2, 0, 0, 0, 0, 0, 364635, 31, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3ca2dc77717b45a9845a1525f79121ec', 0, 1, -1, N'99395  Periodic comprehensive preventive medicine reevaluation and management of an individual including an AGE and GENDER APPROPRIATE HISTORY, EXAMINATION, counseling/anticipatory guidance/risk factor reduction interventions, and the ordering of appropriate immunization(s), laboratory/diagnostic procedures, established patient;  18 - 39 years', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99395', 28003850, -2, 0, -1, -1, -1, 6570, 14600, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3cf876ab05364d1aa655bcc5c09ab75f', 1, 1, -1, N'90809  Individual psychotherapy, insight oriented, behavior modifying and/or supportive, in an office or outpatient facility with medical evaluation and management services, approximately 75 - 80 minutes face-to-face with the patient.', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90809', 33005400, -2, 0, 0, 0, 0, 0, 364635, 75, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3d29127145ee4557a08b1ddc9cd571b6', 1, 1, -1, N'99374  Physician supervision of a patient under care of home health agency (patient not present) requiring complex and multidisciplinary care modalities involving regular physician development and/or revision of care plans, review of subsequent reports of patient status, review of laboratory and other studies, communication (including telephone calls) with other health care professionals involved in patient''s care, integration of new information into the medical treatment plan and/or adjustment of medical therapy, within a calendar month; 15 - 29 minutes', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99374', 27003810, -2, 0, -1, -1, -1, 0, 364635, 15, 29, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3e1e0aebb8fb49b09eddf23711f90bf8', 1, 1, 25, N'99225 Subsequent observation care, per day, for the evaluation and management of a patient, which requires at least 2 of these 3 key components: An expanded problem focused interval history; An expanded problem focused examination; Medical decision making of moderate complexity. Counseling and/or coordination of care with other', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'99225', 11001150, -2, 2, 2, 2, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3e25e9b254774fe08cc33017f8a268ea', 1, 1, 0, N'Psychotherapy, 30 minutes with patient and/or family member. For add-on code 90833 go to Other Services and input code in Procedures.', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'90832', 3550, -2, 0, 0, 0, 0, 0, 364635, 16, 37, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'3f330ea9a36f439e9ac8a9c48897b104', 1, 1, -1, N'98926  Osteopathic manipulative treatment (OMT) is a form of manual treatment applied by a physician to eliminate or alleviate somatic dysfunction and related disorders.  This treatment may be accomplished by a variety of techniques. (OMT); three to four body regions involved', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98926', 39008300, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4118a0dd38784ef0a39fd24e2d55cd82', 1, 1, 30, N'99318 Evaluation and management of a patient involving an annual nursing facility assessment, which requires these 3 key components: a detailed interval history, a comprehensive examination, and medical decision making that is of low to moderate complexity. Counseling and/or coordination of care with other physicians, other qualified health care professionals, or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs. Usually, the patient is stable, recovering, or improving.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99318', 20003000, -2, 3, 3, 4, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'418ca51668f5454f8e0b134c2d57484d', 1, 1, -1, N'90876  Individual psychophysiological therapy incorporating biofeedback training by any modality (face-to-face with the patient), with psychotherapy (eg, insight oriented, behavior modifying or supportive psychotherapy), approximately 45-50 minutes.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2009-12-31T23:59:00.000' AS DateTime), N'90876', 37007100, -2, 0, 0, 0, 0, 0, 364635, 36, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'41d12c02364e4bf2b0c0f57ad9c411d0', 1, 1, -1, N'99309  Subsequent nursing facility care, per day, for the evaluation and management of a patient.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2007-12-31T23:59:00.000' AS DateTime), N'99309', 20002900, -2, 2, 3, 3, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4220e72927be45fb9413767cafa9e22a', 1, 1, 0, N'Psychotherapy, 45 minutes with patient and/or family member. For add-on code 90836 go to Other Services and input code in Procedures.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2016-12-31T23:59:00.000' AS DateTime), N'90834', 35003545, -2, 0, 0, 0, 0, 0, 364635, 38, 52, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'42f284ab4d954556bea61d29c381622a', 1, 1, -1, N'99291 Critical care, evaluation and management of the critically ill or critically injured patient; first 30-74 minutes', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99291', 16008115, -2, 0, -1, -1, -1, 730, 364635, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4356ae5a8eba4329ab0736662e1ead2b', 1, 1, -1, N'99378  Physician supervision of a hospice patient (patient not present) requiring complex and multidisciplinary care modalities involving regular physician development and/or revision of care plans, review of subsequent reports of patient status, review of subsequent reports of patient status, review of related laboratory and other studies, communication (including telephone calls) with other health care professionals involved in patient''s care, integration of new information into the medical treatment plan and/or adjustment of medical therapy, within a calendar month; 30 minutes or more', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99378', 27003820, -2, 0, -1, -1, -1, 0, 364635, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'448a2a18a625440ea6152dc751d38f10', 0, 1, 15, N'99213 Office or other outpatient visit for the evaluation and management of an established patient, which requires at least two of these three key components:  an expanded problem focused history, an expanded problem focused examination, and medical decision making of low complexity. Counseling and coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of low to moderate severity. Physicians typically spend 15 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99213', 1000, -2, 2, 2, 2, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'44ce1dac645b4969a13a4eb23cd8d1e3', 1, 1, -1, N'99238 Hospital discharge day management; 30 minutes or less', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99238', 12001600, -2, 0, -1, -1, -1, 0, 364635, 0, 30, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'459a5762ae954713bd019346c6521e4b', 1, 1, 0, N'99291 Critical care, evaluation and management of the critically ill or critically injured patient; first 30-74 minutes. For inpatient critical care services provided to patients 72 months of age or younger, see pediatric critical care codes 99471-99476 or neonatal critical care codes 99468, 99469. For transport services of critically ill or critically injured pediatric patients 24 months of age or younger, see 99466, 99467.', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99291', 16002200, -2, 0, 0, 0, 0, 730, 364635, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4633ce519a9449e09dd34216d243fc3a', 1, 1, -1, N'90847  Family psychotherapy (conjoint psychotherapy)(with patient present)', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2017-12-31T23:59:00.000' AS DateTime), N'90847', 36006300, -2, 0, 0, 0, 0, 0, 364635, 26, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'46a563e1d1324ab78765f8f41a11ed97', 1, 0, 60, N'99344 Home visit for the evaluation and management of a new patient, which requires these three key components:  a comprehensive history, a comprehensive examination, and a medical decision making of moderate complexity.  Usually, the presenting problem(s) are of high severity.  Physicians typically spend 60 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99344', 23003100, -2, 3, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4710dbf0b48d4275a7acf41e8cbcfa97', 1, 1, -1, N'90808  Individual psychotherapy, insight oriented, behavior modifying and/or supportive, in an office or outpatient facility, approximately 75 - 80 minutes face-to-face with the patient.', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90808', 33005300, -2, 0, 0, 0, 0, 0, 364635, 75, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4757378d326d45bea82977778f293906', 1, 1, 50, N'99219 Initial observation care, per day, for the evaluation and management of a patient, which requires these three key components: a comprehensive history, a comprehensive examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission to "observation status" are of moderate severity.', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2017-12-31T23:59:00.000' AS DateTime), N'99219', 11001100, -2, 3, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'47d269cfece243dc98707ec6b315a90b', 1, 1, -1, N'90804  Individual psychotherapy, insight oriented, behavior modifying and/or supportive, in an office or outpatient facility, approximately 20 - 30 minutes face-to-face with the patient.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2009-12-31T23:59:00.000' AS DateTime), N'90804', 33005300, -2, 0, 0, 0, 0, 0, 364635, 20, 35, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'47d6940f16ea484da0957250284ae032', 1, 1, -1, N'90814  Individual psychotherapy, interactive, using play equipment, physical devices, language interpreter, or other mechanisms of non-verbal communication, in an office or outpatient facility, approximately 75 - 80 minutes face-to-face with the patient.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2009-12-31T23:59:00.000' AS DateTime), N'90814', 33005500, -2, 0, 0, 0, 0, 0, 364635, 66, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'48af47b78d7745dda1d835e225c53998', 1, 1, 35, N'99310 Subsequent nursing facility care, per day, for the evaluation and management of a patient, which requires at least two of these three key components:  a comprehensive interval history, a comprehensive examination, and medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  The patient may be unstable or may have developed a significant new problem requiring immediate physician attention.', CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99310', 20002900, -2, 2, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'49c6bc7f59614b18b98621262c2e1dcf', 0, 1, -1, N'99392  Periodic comprehensive preventive medicine reevaluation and management of an individual including an AGE and GENDER APPROPRIATE HISTORY, EXAMINATION, counseling/anticipatory guidance/risk factor reduction interventions, and the ordering of appropriate immunization(s), laboratory/diagnostic procedures, established patient; early childhood (age 1 through 4 years)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99392', 28003850, -2, 0, -1, -1, -1, 365, 1825, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a01007b92d245bfad9030fac2e27f95', 1, 1, -1, N'90815  Individual psychotherapy, interactive, using play equipment, physical devices, language interpreter, or other mechanisms of non-verbal communication, in an office or outpatient facility with medical evaluation and management, approximately 75 - 80 minutes face-to-face with the patient.', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90815', 33005600, -2, 0, 0, 0, 0, 0, 364635, 75, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca8131', 1, 0, -1, N'99202  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using total time on the date of the encounter for code selection, 15 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99202', 1000, -2, 1, -1, -1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, 29, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81310', 1, 0, 60, N'99205  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99205', 1000, -2, 0, -1, -1, -1, 0, 364635, 60, 999, 28, 0, 0, 74, 1, 0, 0, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81311', 1, 0, 60, N'99205  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99205', 1000, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 28, 0, 0, 74, 1, 0, 0, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81312', 0, 1, -1, N'99212  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using total time on the date of the encounter for code selection, 10 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99212', 1000, -2, 1, -1, -1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, 19, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81313', 0, 1, -1, N'99212  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using total time on the date of the encounter for code selection, 10 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99212', 1000, -2, 0, -1, -1, 1, 0, 364635, 10, 19, NULL, NULL, NULL, 19, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81314', 0, 1, -1, N'99213  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using total time on the date of the encounter for code selection, 20 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99213', 1000, -2, 1, -1, -1, 2, 0, 364635, 0, 999, NULL, NULL, NULL, 29, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81315', 0, 1, -1, N'99213  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using total time on the date of the encounter for code selection, 20 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99213', 1000, -2, 0, -1, -1, 2, 0, 364635, 20, 29, NULL, NULL, NULL, 29, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81316', 0, 1, -1, N'99214  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99214', 1000, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, 39, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81317', 0, 1, -1, N'99214  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99214', 1000, -2, 0, -1, -1, 3, 0, 364635, 30, 39, NULL, NULL, NULL, 39, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81318', 0, 1, 40, N'99215  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99215', 1000, -2, 0, -1, -1, 4, 0, 364635, 40, 999, 28, 0, 1, 54, 1, 0, 1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81319', 0, 1, 54, N'99215  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99215', 1000, -2, 0, -1, -1, 4, 0, 364635, 40, 999, 28, 1, 0, 54, 1, 1, 0, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca8132', 1, 0, -1, N'99202  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using total time on the date of the encounter for code selection, 15 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99202', 1000, -2, 0, -1, -1, -1, 0, 364635, 15, 29, NULL, NULL, NULL, 29, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81320', 0, 1, 54, N'99215  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99215', 1000, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 28, 1, 0, 54, 1, 1, 0, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81321', 0, 1, 40, N'99215  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99215', 1000, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 28, 0, 0, 54, 1, 0, 0, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81322', 0, 1, 40, N'99215  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99215', 1000, -2, 0, -1, -1, 4, 0, 364635, 40, 999, 28, 0, 0, 54, 1, 0, 0, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81323', 1, 1, 50, N'99306  Initial nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 50 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99306', 20002780, -2, 0, -1, -1, -1, 0, 364635, 50, 999, 28, 0, 1, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81324', 1, 1, 80, N'99306  Initial nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 50 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99306', 20002780, -2, 0, -1, -1, -1, 0, 364635, 50, 999, 28, 1, 0, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81325', 1, 1, 80, N'99306  Initial nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 50 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99306', 20002780, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 28, 1, 0, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81326', 1, 1, 50, N'99306  Initial nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 50 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99306', 20002780, -2, 1, -1, -1, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81327', 1, 1, 50, N'99306  Initial nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 50 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99306', 20002780, -2, 0, -1, -1, -1, 0, 364635, 50, 999, NULL, NULL, NULL, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81328', 1, 1, -1, N'99308  Subsequent nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using total time on the date of the encounter for code selection, 15 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99308', 20002900, -2, 1, -1, -1, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81329', 1, 1, -1, N'99308  Subsequent nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using total time on the date of the encounter for code selection, 20 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99308', 20002900, -2, 0, -1, -1, -1, 0, 364635, 20, 29, NULL, NULL, NULL, -1, 1, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca8133', 1, 0, -1, N'99203  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99203', 1000, -2, 1, -1, -1, 2, 0, 364635, 0, 999, NULL, NULL, NULL, 44, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca81330', 1, 1, -1, N'99307  Subsequent nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and straightforward medical decision making. When using total time on the date of the encounter for code selection, 10 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99307', 20002900, -2, 0, -1, -1, -1, 0, 364635, 10, 19, NULL, NULL, NULL, -1, 1, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca8134', 1, 0, -1, N'99203  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and low level of medical decision making. When using total time on the date of the encounter for code selection, 30 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99203', 1000, -2, 0, -1, -1, -1, 0, 364635, 30, 44, NULL, NULL, NULL, 44, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca8135', 1, 0, -1, N'99204  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99204', 1000, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, 59, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca8136', 1, 0, -1, N'99204  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and moderate level of medical decision making. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99204', 1000, -2, 0, -1, -1, -1, 0, 364635, 45, 59, NULL, NULL, NULL, 59, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca8137', 1, 0, 60, N'99205  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99205', 1000, -2, 0, -1, -1, -1, 0, 364635, 60, 999, 28, 0, 1, 74, 1, 0, 1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca8138', 1, 0, 74, N'99205  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99205', 1000, -2, 0, -1, -1, -1, 0, 364635, 60, 999, 28, 1, 0, 74, 1, 1, 0, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4a95359f1db14f4e866460102f0ca8139', 1, 0, 74, N'99205  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99205', 1000, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 28, 1, 0, 74, 1, 1, 0, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4d2dca4be97d4619a51e3d83cf312535', 1, 1, -1, N'99456  Work related or medical disability examination by other than the treating physician that includes:  completion of a medical history commensurate with the patient''s condition;  performance of an examination commensurate with the patient''s condition; formulation of a diagnosis, assessment of capabilities and stability, and calculation of impairment; development of future medical treatment plan; and completion of necessary documentation/certificates and report.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99456', 43504500, -2, 3, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4d505922dd9b4750b0d8b8afd9bf018e', 1, 1, -1, N'90818  Individual psychotherapy, insight oriented, behavior and/or supportive, in an inpatient hospital, partial hospital or residential care setting, approximately 45 to 50 minutes face-to-face with the patient', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90818', 34005700, -2, 0, 0, 0, 0, 0, 364635, 45, 74, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4dd98c6ebf6c40ce98d0ee0d1e942dbe', 1, 1, -1, N'99477 Initial hospital care, per day, for the evaluation and management of the neonate, 28 days of age or less, who requires intensive observation, frequent interventions, and other intensive care services(For the initiation of inpatient care of the normal newborn, report 99431, 0) (For the initiation of care of the critically ill neonate, use 99295, 0) (For initiation of inpatient hospital care of the neonate not requiring intensive observation, frequent interventions, and other intensive care services, see 99221-99223, 0)', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99477', 30604690, -2, 0, 0, 0, 0, 0, 29, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4e4b150759a249e39adadf8e5e794b88', 1, 1, -1, N'90821  Individual psychotherapy, insight oriented, behavior and/or supportive, in an inpatient hospital, partial hospital or residential care setting, approximately 75 to 80 minutes face-to-face with the patient', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90821', 34005700, -2, 0, 0, 0, 0, 0, 364635, 75, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4e65ebba5a904d438d5b28093ee52f6d', 1, 1, -1, N'No Code - Problem with documentation (Legibility, insufficient documentation, etc.)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'No Code', 4100, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4f322fcf66304a3c931d96b8dbe9012c', 1, 0, -1, N'99440  Newborn resuscitation:  provision of positive pressure ventilation and/or chest compressions in the presence of acute inadequate ventilation and/or cardiac output', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99440', 29004230, -2, 0, -1, -1, -1, 0, 365, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4f475399ba304d9286fdf099aa9958a2', 1, 1, -1, N'90811  Individual psychotherapy, interactive, using play equipment, physical devices, language interpreter, or other mechanisms of non-verbal communication, in an office or outpatient facility with medical evaluation and management, approximately 20 - 30 minutes face-to-face with the patient.', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90811', 33005600, -2, 0, 0, 0, 0, 0, 364635, 20, 44, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4fdfb19a97fb4a02a9036a5082289b6b', 1, 1, 40, N'99234 Observation or inpatient hospital care, for the evaluation and management of a patient including admission and discharge on the same date which requires these three key components: a detailed or comprehensive history,  a detailed or comprehensive examination, and medical decision making that is straightforward or of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually the presenting problem(s) requiring admission are of low severity.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99234', 1250, -2, 3, 3, 3, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'4feb39ee5c3f45e79636e23c6643e271', 1, 0, 30, N'99325 Domiciliary rest home visit for the evaluation and management of a new patient, which requires these 3 key components: an expanded problem focused history, an expanded problem focused examination, and medical decision making of low complexity. Counseling and/or coordination of care with other physicians, other qualified health care professionals, or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs. Usually, the presenting problem(s) are of moderate severity.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99325', 2100, -2, 3, 2, 2, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'50484a1ce9874740aac5ee08db2db33c', 1, 1, -1, N'99304 Initial nursing facility care, per day, for the evaluation and management of a patient which requires these three key components: a detailed or comprehensive history;  a detailed or comprehensive examination; and medical decision making that is straightforward or of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission are of low severity.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2007-12-31T23:59:00.000' AS DateTime), N'99304', 20002780, -2, 3, 3, 3, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'50739472391b4c1cac03dd7f9f14cb78', 0, 1, -1, N'99372  Telephone call by a physician to patient or for consultation or medical management or for coordinating medical management with other health care professionals (e.g., nurses, therapists, social workers, nutritionists, physicians, pharmacists); Intermediate (e.g., to provide advice to an established patient on a new problem, to initiate therapy that can be handled by telephone, to discuss tests results in detail, to coordinate medical management of a new problem in an established patient, to discuss and evaluate new information and details, or to initiate new plan of care)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99372', 26003700, -2, 0, -1, -1, -1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'52fe97cd99014b5db169965bc2b00b1c', 1, 1, 53, N'Psychotherapy, 60 minutes with patient.', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90837', 35003545, -2, 0, 0, 0, 0, 0, 364635, 53, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'53e9bd369cdb4d48955d24c9a364e1f5', 1, 1, -1, N'90846 Family psychotherapy (without the patient present)', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90846', 36006200, -2, 0, 0, 0, 0, 0, 364635, 26, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'54ea90d60f694b3f859efb59c62d80d5', 1, 1, -1, N'99364 Anticoagulant management for an outpatient taking warfarin, physician review and interpretation of International Normalized Ratio (INR) testing, patient instructions, dosage adjustment (as needed), and ordering of additional tests; each subsequent 90 days of therapy (must include a minimum of 3 INR measurements)', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2017-12-31T23:59:00.000' AS DateTime), N'99364', 26003700, -2, 0, -1, -1, -1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'557e78e71f49478099094dbb971c2d25', 1, 1, -1, N'G2064 Comprehensive care management services for a single high-risk disease, e.g., principal care management, at least 30 minutes of physician or other qualified health care professional time per calendar month with the following elements: one complex chronic condition lasting at least 3 months, which is the focus of the care plan, the condition is of sufficient severity to place patient at risk of hospitalization or have been the cause of a recent hospitalization, the condition requires development or revision of disease-specific care plan, the condition requires frequent adjustments in the medication regimen, and/or the management of the condition is unusually complex due to comorbidities', CAST(N'2020-01-01T00:00:00.000' AS DateTime), CAST(N'2021-12-31T23:59:00.000' AS DateTime), N'G2064', 43509700, 0, 0, 0, 0, 0, 0, 364635, 30, 999, 16, 5, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'557e78e71f49478099094dbb971c2d26', 1, 1, -1, N'G2065 Comprehensive care management services for a single high-risk disease, e.g., principal care management, at least 30 minutes of clinical staff time directed by a physician or other qualified health care professional, per calendar month with the following elements: one complex chronic condition lasting at least 3 months, which is the focus of the care plan, the condition is of sufficient severity to place patient at risk of hospitalization or have been cause of a recent hospitalization, the condition requires development or revision of disease-specific care plan, the condition requires frequent adjustments in the medication regimen, and/or the management of the condition is unusually complex due to comorbidities', CAST(N'2020-01-01T00:00:00.000' AS DateTime), CAST(N'2021-12-31T23:59:00.000' AS DateTime), N'G2065', 43509700, 0, 0, 0, 0, 0, 0, 364635, 30, 999, 16, 5, 1, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'5653e57904e54f359833e034ad004725', 1, 1, 53, N'Psychotherapy, 60 minutes with patient and/or family member. For add-on code 90838 go to Other Services and input code in Procedures.', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'90837', 3550, -2, 0, 0, 0, 0, 0, 364635, 53, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'56cfbcaf93bb4ba894d6668c97273ff1', 1, 1, -1, N'99371  Telephone call by a physician to patient or for consultation or medical management or for coordinating medical management with other health care professionals (e.g., nurses, therapists, social workers, nutritionists, physicians, pharmacists); simple or brief (e.g., to report on tests and/or laboratory results, to clarify or alter previous instructions, to integrate new information from other health professionals into the medical treatment plan, or to adjust therapy)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99371', 26003600, -2, 0, -1, -1, -1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'57445358c1c645409ccc252fb052d1bd', 0, 1, 60, N'99337 Domiciliary rest home visit for the evaluation and management of an established patient, which requires these 2 key components: a comprehensive interval history, a comprehensive examination, and medical decision making of high complexity. Counseling and/or coordination of care with other physicians, other qualified health care professionals, or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs. Usually, the presenting problem(s) are of moderate to high severity. The patient may be unstable or may have developed a significant new problem requiring immediate physician attention.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99337', 2100, -2, 2, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'57c0fe6ca6544c738b7029ff938d7e58', 1, 1, 0, N'Collection and interpretation of physiologic data (eg, ECG, blood pressure, glucose monitoring) digitally stored and/or transmitted by the patient and/or caregiver to the physician or other qualified health care professional, qualified by education, training, licensure/regulation (when applicable) requiring a minimum of 30 minutes of time, each 30 days', CAST(N'2019-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99091', 29509630, -2, 0, 0, 0, 0, 0, 364635, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'58b1da6bdf024b89bb7364d7f6479fee', 1, 1, 110, N'99255 Initial inpatient consultation for a new or established patient, which requires these three key components:  a comprehensive history, a comprehensive examination, and medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate to high severity. Physicians typically spend 110 minutes at the bedside and on the patient''s hospital floor or unit.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99255', 13001850, -2, 3, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'58c97f8386214417b597af02ebec3a82', 0, 1, -1, N'99393  Periodic comprehensive preventive medicine reevaluation and management of an individual including an AGE and GENDER APPROPRIATE HISTORY, EXAMINATION, counseling/anticipatory guidance/risk factor reduction interventions, and the ordering of appropriate immunization(s), laboratory/diagnostic procedures, established patient;  late childhood (5 through 11 years)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99393', 28003850, -2, 0, -1, -1, -1, 1825, 4380, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'5ace8edf51fd4b74815d21733112171a', 1, 1, 0, N'Interprofessional telephone/Internet/electronic health record referral service(s) provided by a treating/requesting physician or other qualified health care professional; 30 minutes', CAST(N'2019-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99452', 29509520, -2, 0, 0, 0, 0, 0, 364635, 16, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'5b4e48361d1d45c4bd5d5af89fb186a4', 1, 1, -1, N'99288 Physician or other qualified health care professional direction of emergency medical systems (EMS) emergency care, advanced life support', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99288', 14001900, -2, 0, -1, -1, -1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'5b60717898fe47a9a75806402b6f6ee3', 1, 0, 30, N'99325 Domiciliary rest home visit for the evaluation and management of a new patient, which requires these 3 key components: an expanded problem focused history, an expanded problem focused examination, and medical decision making of low complexity. Counseling and/or coordination of care with other physicians, other qualified health care professionals, or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs. Usually, the presenting problem(s) are of moderate severity.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99325', 21003050, -2, 3, 2, 2, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'5be6bc4ea9624c0e927348f6d52e6ce8', 1, 1, -1, N'G0439 Annual Wellness Visit; Subsequent Visit', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2017-12-31T23:59:00.000' AS DateTime), N'G0439', 28003890, -2, 1, 4, -1, -1, 0, 364635, 0, 999, 37, 1, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'5e1a9115ac7f4079abef942775e7b672', 1, 0, 45, N'99204 Office or other outpatient visit for the evaluation and management of a new patient, which requires these three key components: a comprehensive history, a comprehensive examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate to high severity. Physicians typically spend 45 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99204', 10001000, -2, 3, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, 45, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'5e7e37ec262144c6afaa9673a361b420', 1, 1, -1, N'99366 Medical team conference with interdisciplinary team of health care professionals, face-to-face with patient and/or family, 30 minutes or more, participation by nonphysician qualified health care professional.(Team conference services of less than 30 minutes duration are not reported separately) (For team conference services by a physician with patient and/or family present, see Evaluation and Management services)', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99366', 26003550, -2, 0, -1, -1, -1, 0, 364635, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'5f72a06fb6d946f8a2b7c93d0ff4c1a4', 1, 1, 0, N'Psychotherapy, 30 minutes with patient and/or family member. For add-on code 90833 go to Other Services and input code in Procedures.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2016-12-31T23:59:00.000' AS DateTime), N'90832', 35003545, -2, 0, 0, 0, 0, 0, 364635, 16, 37, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6269a91b0b874aaf852356aed862e871', 1, 1, -1, N'90882  Environmental intervention for medical management purposes on a psychiatric patient''s behalf with agencies, employers, or institutions', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90882', 37007300, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'641fe88f46454c8f8d59a2fb1c67c863', 1, 1, 25, N'99304 Initial nursing facility care, per day, for the evaluation and management of a patient which requires these three key components: a detailed or comprehensive history, a detailed or comprehensive examination, and medical decision making that is straightforward or of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission are of low severity.', CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99304', 20002780, -2, 3, 3, 3, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'652511fcd1ed4487af0c2307fb9f7ea9', 1, 1, -1, N'90823  Individual psychotherapy, interactive, using play equipment, physical devices, language interpreter, or other mechanisms of non-verbal communication, in an inpatient hospital, partial hospital or residential care setting, approximately 20 to 30 minutes face-to-face with the patient', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90823', 34005900, -2, 0, 0, 0, 0, 0, 364635, 20, 44, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'654000c0dd22495ea449155653239013', 1, 1, 50, N'99222 Initial hospital care, per day, for the evaluation and management of a patient, which requires these three key components: a comprehensive history, a comprehensive examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission are of moderate severity. Physicians typically spend 50 minutes at the bedside and on the patient''s hospital floor or unit.', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99222', 12001200, -2, 3, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6720542c32cf473a8bff68e1d0a25ec0', 1, 1, -1, N'G0438 Annual Wellness Visit; Initial Visit', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2017-12-31T23:59:00.000' AS DateTime), N'G0438', 28003880, -2, 1, 4, -1, -1, 0, 364635, 0, 999, 36, 1, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'675d16d8b2b44f29a8bb773dceef4825', 1, 1, -1, N'99368  Medical team conference with interdisciplinary team of health care professionals, patient and/or family not present, 30 minutes or more; participation by nonphysician qualified health care professional', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99368', 26003570, -2, 0, -1, -1, -1, 0, 364635, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'686e5ee2072f4c3d8073a06cd623a131', 1, 1, -1, N'99290 Critical care services delivered by a physician, face-to-face, during an interfacility transport of critically ill or critically injured pediatric patient, 24 months of age or less; each additional 30 minutes (List separately in addition to code for primary service)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99290', 15008100, -2, 0, -1, -1, -1, 0, 730, 75, 104, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'693e9dc483ca4e7da40d166de10154f8', 1, 1, -1, N'99296 Subsequent inpatient neonatal critical care, per day, for the evaluation and management of a critically ill neonate, 28 days of age or less', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99296', 18002400, -2, 0, -1, -1, -1, 0, 365, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6a4b5cd0a8b04977819122272f630585', 1, 1, -1, N'98943  Chiropractic Manipulative Treatment (CMT) is a form of manual treatment to influence joint and neurophysiological function.  This treatment may be accomplished using a variety of techniques.  (CMT); extraspinal, one or more regions', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98943', 40009000, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6a62208c44214c88b8188631736bdb1b', 1, 1, 0, N'Psychotherapy, 30 minutes with patient.', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90832', 35003545, -2, 0, 0, 0, 0, 0, 364635, 16, 37, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6ad7cc0f7c174174a88d190fc98b93e3', 1, 0, -1, N'99436  Attendance at delivery (when requested by delivering physician) and initial stabilization of newborn.  (99436 may be reported in addition to 99431, 0)  (99436 may not be reported in addition to 99440, 0)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99436', 29004215, -2, 0, -1, -1, -1, 0, 365, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6b1546244c084ecfa67be3d8a6595666', 1, 1, 0, N'99292 Critical care, evaluation and management of the critically ill or critically injured patient; Additional 30 minutes.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99292', 16002300, -2, 0, 0, 0, 0, 0, 364635, 30, 999, 29, 4, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6b7ae74be36d4fe98839cccfc83e27b71', 1, 1, 0, N'Remote physiologic monitoring treatment management services, clinical staff/physician/other qualified health care professional time in a calendar month requiring 1 real-time interactive communication with the patient/caregiver during the calendar month; first 10 minutes', CAST(N'2026-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99470', 29509700, -2, 0, 0, 0, 0, 0, 364635, 10, 19, 43, 1, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6b7ae74be36d4fe98839cccfc83e27b72', 1, 1, 0, N'Remote physiologic monitoring treatment management services, clinical staff/physician/other qualified health care professional time in a calendar month requiring 1 real-time interactive communication with the patient/caregiver during the calendar month; first 20 minutes', CAST(N'2026-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99457', 29509700, -2, 0, 0, 0, 0, 0, 364635, 20, 999, 43, 1, 0, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6b7ae74be36d4fe98839cccfc83e27b73', 1, 1, 0, N'Remote monitoring of physiologic parameter(s) (eg, weight, blood pressure, pulse oximetry, respiratory flow rate); initial set-up and patient education on use of equipment', CAST(N'2026-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99453', 29509610, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6b7ae74be36d4fe98839cccfc83e27b74', 1, 1, 0, N'Remote monitoring of physiologic parameter(s) (eg, weight, blood pressure, pulse oximetry, respiratory flow rate); device(s) supply with daily recording(s) or programmed alert(s) transmission, 2-15 days in a 30-day period', CAST(N'2026-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99445', 29509620, -2, 0, 0, 0, 0, 0, 364635, 0, 999, 44, 1, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6b7ae74be36d4fe98839cccfc83e27b75', 1, 1, 0, N'Remote monitoring of physiologic parameter(s) (eg, weight, blood pressure, pulse oximetry, respiratory flow rate); device(s) supply with daily recording(s) or programmed alert(s) transmission, 16-30 days in a 30-day period', CAST(N'2026-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99454', 29509620, -2, 0, 0, 0, 0, 0, 364635, 0, 999, 44, 1, 1, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6bba4047d6f94c64bcf3542187e666af', 1, 1, -1, N'99499  Unlisted evaluation and management service', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2007-12-31T23:59:00.000' AS DateTime), N'99499', 3100, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6cb5cfa9eddb4bceb4cc0be47ae5334e', 1, 1, -1, N'90802  Interactive psychiatric diagnostic interview examination using play equipment, physical devices, language interpreter, or other mechanisms of communication.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90802', 35007900, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6d0563b829d2485ba560fbac126553a71', 1, 1, 95, N'99236  Hospital inpatient or observation care, for the evaluation and management of a patient including admission and discharge on the same date, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 85 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99236', 12001400, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 28, 1, 0, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6d0563b829d2485ba560fbac126553a72', 1, 1, 80, N'99306  Initial nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2023-12-31T23:59:00.000' AS DateTime), N'99306', 20002780, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 28, 1, 0, -1, 1, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6d0563b829d2485ba560fbac126553a73', 1, 1, 70, N'99310  Subsequent nursing facility care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 45 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99310', 20002900, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 28, 1, 0, -1, 1, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6d0563b829d2485ba560fbac126553a74', 1, 0, 125, N'99345  Home or residence visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99345', 2300, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 28, 1, 0, -1, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6d0563b829d2485ba560fbac126553a75', 0, 1, 95, N'99350  Home or residence visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2023-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99350', 2300, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 28, 1, 0, -1, 1, -1, -1, 4)
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6df69775f4a84a2da74403dab9b54fea', 1, 0, -1, N'99385  Initial comprehensive preventive medicine evaluation and management of an individual including an AGE and GENDER APPROPRIATE HISTORY, EXAMINATION, counseling/anticipatory guidance/risk factor reduction interventions, and the ordering of appropriate immunization(s), laboratory/diagnostic procedures, new patient;  age 18 - 39 years', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99385', 28003840, -2, 0, -1, -1, -1, 6570, 14600, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6e5259e5aa144346aeead6effb46c288', 1, 1, -1, N'99401  Preventive medicine counseling and/or risk factor reduction intervention(s) provided to an individual (separate procedure);  approximately 15 minutes', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99401', 28003900, -2, 0, -1, -1, -1, 0, 364635, 0, 25, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6ee521cac5fc48249766dc9d855d8cd11', 1, 1, 10, N'G0101 Well Woman (Pelvic & Breast)', CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0101', 28003860, -2, 1, -1, 4, -1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6ee521cac5fc48249766dc9d855d8cd12', 1, 1, 30, N'G0402 IPPE (Welcome to Medicare)', CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0402', 28003870, -2, 1, 4, -1, -1, 0, 364635, 0, 999, 35, 1, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6ee521cac5fc48249766dc9d855d8cd13', 1, 1, 30, N'G0438 Annual Wellness Visit; Initial Visit', CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0438', 28003880, -2, 1, 4, -1, -1, 0, 364635, 0, 999, 36, 1, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6ee521cac5fc48249766dc9d855d8cd14', 1, 1, 25, N'G0439 Annual Wellness Visit; Subsequent Visit', CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0439', 28003890, -2, 1, 4, -1, -1, 0, 364635, 0, 999, 37, 1, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6f2f3c3b009a4645b9b6a4cf763e3577', 1, 0, 20, N'99202 Office or other outpatient visit for the evaluation and management of a new patient, which requires these three key components: an expanded problem focused history, an expanded problem focused examination, and straightforward medical decision making.  Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of low to moderate severity. Physicians typically spend 20 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99202', 10001000, -2, 3, 2, 2, 1, 0, 364635, 0, 999, NULL, NULL, NULL, 20, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6f96bcefb91749c3aadd9a77b82ab0b0', 1, 1, -1, N'99366 Medical team conference with interdisciplinary team of health care professionals, face-to-face with patient and/or family, 30 minutes or more, participation by nonphysician qualified health care professional.(Team conference services of less than 30 minutes duration are not reported separately) (For team conference services by a physician with patient and/or family present, see Evaluation and Management services)', CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99366', 26003550, -2, 0, -1, -1, -1, 0, 364635, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'6f9bb0515dd44dacb8ecdcfad4519b74', 1, 1, -1, N'90822  Individual psychotherapy, insight oriented, behavior and/or supportive, in an inpatient hospital, partial hospital or residential care setting, approximately 75 to 80 minutes face-to-face with the patient with medical evaluation and management services', CAST(N'2007-01-01T00:00:00.000' AS DateTime), CAST(N'2009-12-31T23:59:00.000' AS DateTime), N'90822', 34005800, -2, 0, 0, 0, 0, 0, 364635, 75, 85, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'70a57ed090d147d1b9f5636d231277ee', 1, 1, -1, N'90792 Psychiatric diagnostic evaluation with medical services', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'90792', 35007900, -2, 2, 2, 1, 999, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'70ad878de026490082ea0f73acaa2b04', 0, 1, 40, N'99349  Home visit for the evaluation and management of an established patient, which requires two of these three key components:  1, 0) DETAILED INTERVAL HISTORY,  2, 0) DETAILED EXAMINATION  3, 0)  MODERATE COMPLEXITY MEDICAL DECISION.  Usually, the presenting problem(s) are of moderate to high complexity.  Physicians usually spend 40 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99349', 2300, -2, 2, 3, 3, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'717150d4dad2465e9e498ffd009c45e6', 1, 1, 20, N'99251 Initial inpatient consultation for a new or established patient, which requires these three key components:  a problem focused history, a problem focused examination, and straightforward medical decision making.  Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are self limited or minor. Physicians typically spend 20 minutes at the bedside and on the patient''s hospital floor or unit.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99251', 13001850, -2, 3, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'71e98556b2bb4f5594fb052d355a7872', 1, 1, 0, N'Interprofessional telephone/Internet/electronic health record assessment and management service provided by a consultative physician including a verbal and written report to the patient''s treating/requesting physician or other qualified health care professional; 21-30 minutes of medical consultative discussion and review', CAST(N'2019-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99448', 29509510, -2, 0, 0, 0, 0, 0, 364635, 21, 30, 13, 2, 0, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'72c37e47841e4d8f883afe3953913edd', 1, 1, -1, N'90823  Individual psychotherapy, interactive, using play equipment, physical devices, language interpreter, or other mechanisms of non-verbal communication, in an inpatient hospital, partial hospital or residential care setting, approximately 20 to 30 minutes face-to-face with the patient', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2009-12-31T23:59:00.000' AS DateTime), N'90823', 34005900, -2, 0, 0, 0, 0, 0, 364635, 20, 35, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'72e45d27d43e44e0b1d84eb13eacfb3b', 1, 1, -1, N'99402  Preventive medicine counseling and/or risk factor reduction intervention(s) provided to an individual (separate procedure);  approximately 30 minutes', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99402', 38953900, -2, 0, -1, -1, -1, 0, 364635, 23, 37, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'745a074038044b55a744e0a3c482cfaf', 1, 1, 0, N'Code 90839 is used to report the first 30-74 minutes of psychotherapy for crisis on a given date. It should be used only once per date even if the time spent by the physician or other health care professional is not continuous on that date. Psychotherapy for crisis of less than 30 minutes total duration on a given date should be reported with 90832 or 90833 (when provided with evaluation and management services). Code 90840 is used to report additional block(s) of time, of up to 30 minutes each beyond the first 74 minutes.', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'90839', 36006000, -2, 0, 0, 0, 0, 0, 364635, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'759cb82d209743bc82363b3a2e14c570', 1, 0, -1, N'99381  Initial comprehensive preventive medicine evaluation and management of an individual including an AGE and GENDER APPROPRIATE HISTORY, EXAMINATION, counseling/anticipatory guidance/risk factor reduction interventions, and the ordering of appropriate immunization(s), laboratory/diagnostic procedures, new patient; infant (age under 1 year)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99381', 28003840, -2, 0, -1, -1, -1, 0, 365, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'76fc87eacc5d4d9ea3ce6046b0d43917', 1, 1, 70, N'99220 Initial observation care, per day, for the evaluation and management of a patient, which requires these three key components: a comprehensive history, a comprehensive examination, and medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission to "observation status" are of high severity.', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2017-12-31T23:59:00.000' AS DateTime), N'99220', 11001100, -2, 3, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'770ffaf4fadb494986e39387464db7e5', 1, 1, -1, N'99402  Preventive medicine counseling and/or risk factor reduction intervention(s) provided to an individual (separate procedure);  approximately 30 minutes', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99402', 28003900, -2, 0, -1, -1, -1, 0, 364635, 26, 40, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'77c868fda5c042bb9a56334343e11c41', 0, 1, -1, N'99462  Subsequent hospital care, per day, for evaluation and management of normal newborn', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99462', 30104530, -2, 0, -1, -1, -1, 0, 29, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'77f70a82aff54dcb991b607991f349f1', 1, 1, 50, N'90847  Family psychotherapy (conjoint psychotherapy)(with patient present)', CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90847', 36006300, -2, 0, 0, 0, 0, 0, 364635, 26, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'791ee15df26442b39797949140f34813', 1, 1, -1, N'90821  Individual psychotherapy, insight oriented, behavior and/or supportive, in an inpatient hospital, partial hospital or residential care setting, approximately 75 to 80 minutes face-to-face with the patient', CAST(N'2007-01-01T00:00:00.000' AS DateTime), CAST(N'2009-12-31T23:59:00.000' AS DateTime), N'90821', 34005700, -2, 0, 0, 0, 0, 0, 364635, 70, 85, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'79c1940a16714f4fba399a0f0214d585', 1, 1, -1, N'99358  Prolonged evaluation and management service before and/or after direct (face-to-face) patient care (e.g., review of extensive records and tests, communication with other professionals and/or the patient/family); first hour', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99358', 2500, -2, 0, -1, -1, -1, 0, 364635, 0, 60, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'7b2132357972431ea27e1facce0040e1', 1, 1, 70, N'99223 Initial hospital care, per day, for the evaluation and management of a patient, which requires these three key components: a comprehensive history, a comprehensive examination, and medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission are of high severity. Physicians typically spend 70 minutes at the bedside and on the patient''s hospital floor or unit.', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99223', 12001200, -2, 3, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'7c121138b68044ba8efe0b9863c70ca6', 1, 1, 45, N'99306 Initial nursing facility care, per day, for the evaluation and management of a patient, which requires these three key components: a comprehensive history, a comprehensive examination, and medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission are of high severity.', CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99306', 20002780, -2, 3, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'7d0719542cf3405c969484d5da6b6f0f', 0, 1, 25, N'99335 Domiciliary rest home visit for the evaluation and management of an established patient, which requires these 2 key components: an expanded interval history, an expanded examination, and medical decision making of low complexity. Counseling and/or coordination of care with other physicians, other qualified health care professionals, or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs. Usually, the presenting problem(s) are of low to moderate severity.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99335', 2100, -2, 2, 2, 2, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'7d1d4fb6b18044c0a5aaf9aea6969951', 0, 1, 25, N'99348 Home visit for the evaluation and management of an established patient, which requires two of these three key components:  an expanded problem focused interval history, an expanded problem focused examination, and a medical decision making of low complexity.  Usually, the presenting problem(s) are of low to moderate complexity.  Physicians typically spend 25 minutes face-to-face with the patient and/or family.', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99348', 23003200, -2, 2, 2, 2, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'7d33f6bdbef74277931fffb3f7040f47', 1, 1, -1, N'90829  Individual psychotherapy, interactive, using play equipment, physical devices, language interpreter, or other mechanisms of non-verbal communication, in an inpatient hospital, partial hospital or residential care setting, approximately 75 to 80 minutes face-to-face with the patient with medical evaluation and management services', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90829', 34006000, -2, 0, 0, 0, 0, 0, 364635, 75, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'7d884df63edd436da6b5978959b656d1', 0, 1, 40, N'99336 Domiciliary rest home visit for the evaluation and management of an established patient, which requires these 2 key components: a detailed interval history, a detailed examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other physicians, other qualified health care professionals, or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs. Usually, the presenting problem(s) are of moderate to high severity.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99336', 2100, -2, 2, 3, 3, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'7dc9433b1cc34549be26935703d333c3', 1, 1, -1, N'99306 Initial nursing facility care, per day, for the evaluation and management of a patient, which requires these three key components: a comprehensive history;  a comprehensive examination; and  medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission are of high severity.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2007-12-31T23:59:00.000' AS DateTime), N'99306', 20002780, -2, 3, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'7f3550575c9949098551e623f2af6b1f', 1, 1, -1, N'90826  Individual psychotherapy, interactive, using play equipment, physical devices, language interpreter, or other mechanisms of non-verbal communication, in an inpatient hospital, partial hospital or residential care setting, approximately 45 to 50 minutes face-to-face with the patient', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2009-12-31T23:59:00.000' AS DateTime), N'90826', 34005900, -2, 0, 0, 0, 0, 0, 364635, 36, 65, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'7f65b7b37f864642840d9c951b04afe3', 1, 1, 70, N'99220 Initial observation care, per day, for the evaluation and management of a patient, which requires these three key components: a comprehensive history, a comprehensive examination, and medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission to outpatient hospital "observation status" are of high severity.', CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99220', 11001100, -2, 3, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'7fc43bbfbda147588e2c17de8570c179', 1, 0, -1, N'92002  Intermediate ophthalmological services, new patient.  Medical examination and evaluation with initiation of diagnostic and treatment program.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'92002', 51005125, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'7ffb8b2fc71b439e98c27ec7241937e2', 1, 1, -1, N'99359  Prolonged evaluation and management service before and/or after direct (face-to-face) patient care (e.g., review of extensive records and tests, communication with other professionals and/or the patient/family); each additional 30 minutes.  (To report telephone calls, see 99371-99373, 0)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99359', 2500, -2, 0, -1, -1, -1, 0, 364635, 61, 90, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'80851bb2a17f49d1bc11a7b4d9a33c04', 1, 1, -1, N'90817  Individual psychotherapy, insight oriented, behavior and/or supportive, in an inpatient hospital, partial hospital or residential care setting, approximately 20 to 30 minutes face-to-face with the patient with medical evaluation and management services', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90817', 34005800, -2, 0, 0, 0, 0, 0, 364635, 20, 44, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'80bfe4c0613c4cc3b4b4dc410cee33f3', 1, 0, 30, N'99203 Office or other outpatient visit for the evaluation and management of a new patient, which requires these three key components: a detailed history, a detailed examination, and medical decision making of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate severity. Physicians typically spend 30 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99203', 10001000, -2, 3, 3, 3, 2, 0, 364635, 0, 999, NULL, NULL, NULL, 30, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f5239924910', 1, 0, 20, N'99202 Office or other outpatient visit for the evaluation and management of a new patient, which requires these three key components: an expanded problem focused history, an expanded problem focused examination, and straightforward medical decision making.  Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of low to moderate severity. Physicians typically spend 20 minutes face-to-face with the patient and/or family.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99202', 10001000, -2, 1, -1, -1, 1, 0, 364635, 0, 999, 17, 2, 0, 20, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f5239924911', 1, 0, 30, N'99203 Office or other outpatient visit for the evaluation and management of a new patient, which requires these three key components: a detailed history, a detailed examination, and medical decision making of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate severity. Physicians typically spend 30 minutes face-to-face with the patient and/or family.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99203', 10001000, -2, 1, -1, -1, 2, 0, 364635, 0, 999, 17, 2, 0, 30, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f5239924912', 1, 0, 45, N'99204 Office or other outpatient visit for the evaluation and management of a new patient, which requires these three key components: a comprehensive history, a comprehensive examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate to high severity. Physicians typically spend 45 minutes face-to-face with the patient and/or family.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99204', 10001000, -2, 1, -1, -1, 3, 0, 364635, 0, 999, 17, 2, 0, 45, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f5239924913', 1, 0, 60, N'99205 Office or other outpatient visit for the evaluation and management of a new patient, which requires these three key components: a comprehensive history, a comprehensive examination, and medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate to high severity. Physicians typically spend 60 minutes face-to-face with the patient and/or family.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99205', 10001000, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 17, 2, 0, 60, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f5239924914', 0, 1, 5, N'99211 Office or other outpatient visit for the evaluation and management of an established patient, that may not require the presence of a physician or other qualified health care professional. Usually, the presenting problem(s) are minimal. Typically, 5 minutes are spent performing or supervising these services.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99211', 10001005, -2, 0, -1, -1, 0, 0, 364635, 0, 999, 17, 2, 0, 5, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f5239924915', 0, 1, 10, N'99212 Office or other outpatient visit for the evaluation and management of an established patient, which requires at least two of these three key components:  a problem focused history, a problem focused examination, and straightforward medical decision making.  Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are self limited or minor. Physicians typically spend 10 minutes face-to-face with the patient and/or family.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99212', 10001005, -2, 1, -1, -1, 1, 0, 364635, 0, 999, 17, 2, 0, 10, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f5239924916', 0, 1, 15, N'99213 Office or other outpatient visit for the evaluation and management of an established patient, which requires at least two of these three key components:  an expanded problem focused history, an expanded problem focused examination, and medical decision making of low complexity. Counseling and coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of low to moderate severity. Physicians typically spend 15 minutes face-to-face with the patient and/or family.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99213', 10001005, -2, 1, -1, -1, 2, 0, 364635, 0, 999, 17, 2, 0, 15, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f5239924918', 0, 1, 25, N'99214 Office or other outpatient visit for the evaluation and management of an established patient, which requires at least two of these three key components:  a detailed history, a detailed examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate to high severity. Physicians typically spend 25 minutes face-to-face with the patient and/or family.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99214', 10001005, -2, 1, -1, -1, 3, 0, 364635, 0, 999, 17, 2, 0, 25, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f5239924919', 0, 1, 40, N'99215 Office or other outpatient visit for the evaluation and management of an established patient, which requires at least two of these three key components:  a comprehensive history, a comprehensive examination, and medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate to high severity. Physicians typically spend 40 minutes face-to-face with the patient and/or family.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99215', 10001005, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 17, 2, 0, 40, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f5239924920', 1, 0, 10, N'99201 Office or other outpatient visit for the evaluation and management of a new patient, which requires these three key components: a problem focused history, a problem focused examination, and straightforward medical decision making.  Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are self limited or minor. Physicians typically spend 10 minutes face-to-face with the patient and/or family.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99201', 10001000, -2, 0, -1, -1, 1, 0, 364635, 10, 19, 17, 2, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f5239924921', 1, 0, 20, N'99202 Office or other outpatient visit for the evaluation and management of a new patient, which requires these three key components: an expanded problem focused history, an expanded problem focused examination, and straightforward medical decision making.  Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of low to moderate severity. Physicians typically spend 20 minutes face-to-face with the patient and/or family.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99202', 10001000, -2, 0, -1, -1, 1, 0, 364635, 20, 29, 17, 2, 0, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f5239924922', 1, 0, 30, N'99203 Office or other outpatient visit for the evaluation and management of a new patient, which requires these three key components: a detailed history, a detailed examination, and medical decision making of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate severity. Physicians typically spend 30 minutes face-to-face with the patient and/or family.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99203', 10001000, -2, 0, -1, -1, 2, 0, 364635, 30, 44, 17, 2, 0, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f5239924923', 1, 0, 45, N'99204 Office or other outpatient visit for the evaluation and management of a new patient, which requires these three key components: a comprehensive history, a comprehensive examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate to high severity. Physicians typically spend 45 minutes face-to-face with the patient and/or family.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99204', 10001000, -2, 0, -1, -1, 3, 0, 364635, 45, 59, 17, 2, 0, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f5239924924', 1, 0, 60, N'99205 Office or other outpatient visit for the evaluation and management of a new patient, which requires these three key components: a comprehensive history, a comprehensive examination, and medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate to high severity. Physicians typically spend 60 minutes face-to-face with the patient and/or family.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99205', 10001000, -2, 0, -1, -1, 4, 0, 364635, 60, 999, 17, 2, 0, 60, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f5239924925', 0, 1, 5, N'99211 Office or other outpatient visit for the evaluation and management of an established patient, that may not require the presence of a physician or other qualified health care professional. Usually, the presenting problem(s) are minimal. Typically, 5 minutes are spent performing or supervising these services.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99211', 10001005, -2, 0, -1, -1, 0, 0, 364635, 5, 9, 17, 2, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f5239924926', 0, 1, 10, N'99212 Office or other outpatient visit for the evaluation and management of an established patient, which requires at least two of these three key components:  a problem focused history, a problem focused examination, and straightforward medical decision making.  Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are self limited or minor. Physicians typically spend 10 minutes face-to-face with the patient and/or family.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99212', 10001005, -2, 0, -1, -1, 1, 0, 364635, 10, 14, 17, 2, 0, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f5239924927', 0, 1, 15, N'99213 Office or other outpatient visit for the evaluation and management of an established patient, which requires at least two of these three key components:  an expanded problem focused history, an expanded problem focused examination, and medical decision making of low complexity. Counseling and coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of low to moderate severity. Physicians typically spend 15 minutes face-to-face with the patient and/or family.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99213', 10001005, -2, 0, -1, -1, 2, 0, 364635, 15, 24, 17, 2, 0, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f5239924928', 0, 1, 25, N'99214 Office or other outpatient visit for the evaluation and management of an established patient, which requires at least two of these three key components:  a detailed history, a detailed examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate to high severity. Physicians typically spend 25 minutes face-to-face with the patient and/or family.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99214', 10001005, -2, 0, -1, -1, 3, 0, 364635, 25, 39, 17, 2, 0, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f5239924929', 0, 1, 40, N'99215 Office or other outpatient visit for the evaluation and management of an established patient, which requires at least two of these three key components:  a comprehensive history, a comprehensive examination, and medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate to high severity. Physicians typically spend 40 minutes face-to-face with the patient and/or family.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99215', 10001005, -2, 0, -1, -1, 4, 0, 364635, 40, 999, 17, 2, 0, 40, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'812320456247475f89e1f5f523992499', 1, 0, 10, N'99201 Office or other outpatient visit for the evaluation and management of a new patient, which requires these three key components: a problem focused history, a problem focused examination, and straightforward medical decision making.  Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are self limited or minor. Physicians typically spend 10 minutes face-to-face with the patient and/or family.', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99201', 10001000, -2, 1, -1, -1, 1, 0, 364635, 0, 999, 17, 2, 0, 10, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'813eb5eb96f04675a1ad8e8e6713ecd8', 1, 1, 20, N'99339 Individual physician supervision of a patient (patient not present) in home, domiciliary, or rest home (e.g., assisted living facility) requiring complex and multidisciplinary care modalities involving regular physician development and/or revision of care plans, review of related laboratory and other studies, communication (including telephone calls) for purposes of assessment or care decisions with health care professional(s), family member(s), surrogate decision maker(s) (e.g., legal guardian) and/or key caregiver(s) involved in patient''s care, integration of new information into the medical treatment plan and/or adjustment of medical treatment plan and/or adjustment of medical therapy, within a calendar month; 15-29 minutes', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99339', 2200, -2, 0, -1, -1, -1, 0, 364635, 15, 29, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'8177ba75ff9542a7ace230ddeef64367', 0, 1, -1, N'99396  Periodic comprehensive preventive medicine reevaluation and management of an individual including an AGE and GENDER APPROPRIATE HISTORY, EXAMINATION, counseling/anticipatory guidance/risk factor reduction interventions, and the ordering of appropriate immunization(s), laboratory/diagnostic procedures, established patient;  40 - 64 years', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99396', 28003850, -2, 0, -1, -1, -1, 14600, 23725, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 6)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'821c4967602446619b41f0375d44ab8c', 1, 1, 0, N'Remote monitoring of physiologic parameter(s) (eg, weight, blood pressure, pulse oximetry, respiratory flow rate), initial; device(s) supply with daily recording(s) or programmed alert(s) transmission, each 30 days', CAST(N'2019-01-01T00:00:00.000' AS DateTime), CAST(N'2025-12-31T23:59:00.000' AS DateTime), N'99454', 29509620, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'8278f1dddfee4661b8f24b75d3fdeab3', 1, 1, -1, N'90805  Individual psychotherapy, insight oriented, behavior modifying and/or supportive, in an office or outpatient facility with medical evaluation and management services, approximately 20 - 30 minutes face-to-face with the patient.', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90805', 33005400, -2, 0, 0, 0, 0, 0, 364635, 20, 44, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'82905fcde61b49f99dd7a4ef9553f6f0', 1, 1, 0, N'Code 90839 is used to report the first 30-74 minutes of psychotherapy for crisis on a given date. It should be used only once per date even if the time spent by the physician or other health care professional is not continuous on that date. Psychotherapy for crisis of less than 30 minutes total duration on a given date should be reported with 90832 or 90833 (when provided with evaluation and management services). Code 90840 is used to report additional block(s) of time, of up to 30 minutes each beyond the first 74 minutes.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90839', 35003575, -2, 0, 0, 0, 0, 0, 364635, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'82cb8deff62c4ab5a9190f4da15c865f', 0, 1, 40, N'99215 Office or other outpatient visit for the evaluation and management of an established patient, which requires at least two of these three key components:  a comprehensive history, a comprehensive examination, and medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate to high severity. Physicians typically spend 40 minutes face-to-face with the patient and/or family.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99215', 10001005, -2, 2, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, 40, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'82d52ecdc347482ca9b99ab5615cd9c9', 1, 1, -1, N'99367 Medical team conference with interdisciplinary team of health care professionals, patient and/or family not present, 30 minutes or more; participation by physician.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99367', 26003560, -2, 0, -1, -1, -1, 0, 364635, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'82fd9639fd8a4f22a34ac17829697aa2', 1, 1, -1, N'99412  Preventive medicine counseling and/or risk factor reduction intervention(s) provided to individuals in a group setting (separate procedure); approximately 60 minutes', CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99412', 28004000, -2, 0, -1, -1, -1, 0, 364635, 31, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'83bb688d00574766aedc9841168b7be5', 1, 0, -1, N'99464  Attendance at delivery (when requested by delivering physician) and initial stabilization of newborn.  
(99464 may be reported in conjunction with 99460, 99468, 99477, 0)
(Do not report 99464 in conjunction with 99465, 0)', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99464', 30104550, -2, 0, -1, -1, -1, 0, 28, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'83f4cad3d9a641b8a406de9bebf22ff8', 1, 1, 50, N'99222 Initial hospital care, per day, for the evaluation and management of a patient, which requires these three key components: a comprehensive history;  a comprehensive examination; and  medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission are of moderate severity. Physicians typically spend 50 minutes at the bedside and on the patient''s hospital floor or unit.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'99222', 12001200, -2, 3, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'83f94080e2bb41cabc47f6492eec03de', 1, 1, -1, N'99499  Unlisted evaluation and management service', CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99499', 31006124, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'8593fcfb5daf4779950553e29082398a', 0, 1, -1, N'99394  Periodic comprehensive preventive medicine reevaluation and management of an individual including an AGE and GENDER APPROPRIATE HISTORY, EXAMINATION, counseling/anticipatory guidance/risk factor reduction interventions, and the ordering of appropriate immunization(s), laboratory/diagnostic procedures, established patient;  adolescent (age 12 through 17 years)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99394', 28003850, -2, 0, -1, -1, -1, 4380, 6570, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'8596fee4d8e24b70a45a1fa67431c4ac', 1, 1, 55, N'99236 Observation or inpatient hospital care, for the evaluation and management of a patient including admission and discharge on the same date, which requires these 3 key components: a comprehensive history, a comprehensive exam, and medical decision making that is high complexity.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99236', 12001400, -2, 3, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'85b13208156f4fcd910e7a30d4df3bb3', 0, 1, 15, N'99213 Office or other outpatient visit for the evaluation and management of an established patient, which requires at least two of these three key components:  an expanded problem focused history, an expanded problem focused examination, and medical decision making of low complexity. Counseling and coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of low to moderate severity. Physicians typically spend 15 minutes face-to-face with the patient and/or family.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99213', 10001005, -2, 2, 2, 2, 2, 0, 364635, 0, 999, NULL, NULL, NULL, 15, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'8610ddd68fcd4d3e849bf2dc85c479da', 1, 0, 20, N'99341 Home visit for the evaluation and management of a new patient, which requires these three key components:  a problem focused history, a problem focused examination, and a straightforward medical decision making.  Usually, the presenting problem(s) are of low severity.  Physicians typically spend 20 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99341', 23003100, -2, 3, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'8661f989fabc4288b4bbefa9007988b41', 1, 0, -1, N'Online digital evaluation and management service, for an established patient, for up to 7 days, cumulative time during the 7 days; 5-10 minutes', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2023-10-09T23:59:00.000' AS DateTime), N'99421', 29504255, -2, 0, 0, 0, 0, 0, 364635, 5, 10, 15, 6, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'8661f989fabc4288b4bbefa9007988b42', 1, 0, -1, N'Online digital evaluation and management service, for an established patient, for up to 7 days, cumulative time during the 7 days; 11-20 minutes', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2023-10-09T23:59:00.000' AS DateTime), N'99422', 29504255, -2, 0, 0, 0, 0, 0, 364635, 11, 20, 15, 6, 0, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'8661f989fabc4288b4bbefa9007988b43', 1, 0, -1, N'Online digital evaluation and management service, for an established patient, for up to 7 days, cumulative time during the 7 days; 21 or more minutes', CAST(N'2020-03-01T00:00:00.000' AS DateTime), CAST(N'2023-10-09T23:59:00.000' AS DateTime), N'99423', 29504255, -2, 0, 0, 0, 0, 0, 364635, 21, 999, 15, 6, 0, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'87818623e46e4d78bc0719eb624a238a', 1, 1, 0, N'Interprofessional telephone/Internet assessment and management service provided by a consultative physician including a verbal and written report to the patient''s treating/requesting physician or other qualified health care professional; 21-30 minutes of medical consultative discussion and review', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2018-12-31T23:59:00.000' AS DateTime), N'99448', 29509500, -2, 0, 0, 0, 0, 0, 364635, 21, 30, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'878d78083918424d832a7d2e0f465775', 1, 1, -1, N'90816  Individual psychotherapy, insight oriented, behavior and/or supportive, in an inpatient hospital, partial hospital or residential care setting, approximately 20 to 30 minutes face-to-face with the patient', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90816', 34005700, -2, 0, 0, 0, 0, 0, 364635, 20, 44, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'87c1a40cfdf948e9b22823ab23d7d12d', 0, 1, -1, N'99391  Periodic comprehensive preventive medicine reevaluation and management of an individual including an AGE and GENDER APPROPRIATE HISTORY, EXAMINATION, counseling/anticipatory guidance/risk factor reduction interventions, and the ordering of appropriate immunization(s), laboratory/diagnostic procedures, established patient;  infant (age under 1 year)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99391', 28003850, -2, 0, -1, -1, -1, 0, 365, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'87e2befc5e34419ca83916d283c1ddde', 1, 1, -1, N'99239 Hospital discharge day management; more than 30 minutes', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99239', 12001600, -2, 0, -1, -1, -1, 0, 364635, 31, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'88581df3466947d5a3f7b8393a9dd6eb', 0, 1, 5, N'99211 Office or other outpatient visit for the evaluation and management of an established patient, that may not require the presence of a physician or other qualified health care professional. Usually, the presenting problem(s) are minimal. Typically, 5 minutes are spent performing or supervising these services.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99211', 1000, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'88cca41435c64c4ab548cb8429c24d74', 1, 0, -1, N'99384  Initial comprehensive preventive medicine evaluation and management of an individual including an AGE and GENDER APPROPRIATE HISTORY, EXAMINATION, counseling/anticipatory guidance/risk factor reduction interventions, and the ordering of appropriate immunization(s), laboratory/diagnostic procedures, new patient;  adolescent (age 12 - 17 years)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99384', 28003840, -2, 0, -1, -1, -1, 4380, 6570, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'8942b315fe7d478e9d9aeb809c7c0121', 1, 1, -1, N'99357  Prolonged physician service in the inpatient setting requiring direct (face-to-face) patient contact beyond the usual service (e.g., maternal fetal monitoring for high risk delivery or other physiological monitoring, prolonged care of an acutely ill inpatient); each additional 30 minutes', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99357', 24003400, -2, 0, -1, -1, -1, 0, 364635, 61, 90, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'89e0f9f5f3414ce585ce87ac509428ac', 1, 1, -1, N'90819  Individual psychotherapy, insight oriented, behavior and/or supportive, in an inpatient hospital, partial hospital or residential care setting, approximately 45 to 50 minutes face-to-face with the patient with medical evaluation and management services', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2009-12-31T23:59:00.000' AS DateTime), N'90819', 34005800, -2, 0, 0, 0, 0, 0, 364635, 36, 65, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'8a40f889cc354fcfa55a6487301efe4f', 1, 0, 60, N'99205 Office or other outpatient visit for the evaluation and management of a new patient, which requires these three key components: a comprehensive history, a comprehensive examination, and medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate to high severity. Physicians typically spend 60 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99205', 10001000, -2, 3, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, 60, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'8a7c84e9a4de49ec914910de28187aba', 1, 1, 30, N'99340 Individual physician supervision of a patient (patient not present) in home, domiciliary, or rest home (e.g., assisted living facility) requiring complex and multidisciplinary care modalities involving regular physician development and/or revision of care plans, review of related laboratory and other studies, communication (including telephone calls) for purposes of assessment or care decisions with health care professional(s), family member(s), surrogate decision maker(s) (e.g., legal guardian) and/or key caregiver(s) involved in patient''s care, integration of new information into the medical treatment plan and/or adjustment of medical treatment plan and/or adjustment of medical therapy, within a calendar month; 30 minutes or more', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99340', 2200, -2, 0, -1, -1, -1, 0, 364635, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'8b4039a5d6df40df89d1d8a7516d32e5', 1, 1, 20, N'99251 Initial inpatient consultation for a new or established patient, which requires these three key components:  a problem focused history, a problem focused examination, and straightforward medical decision making.  Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are self limited or minor. Physicians typically spend 20 minutes at the bedside and on the patient''s hospital floor or unit.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99251', 13001800, -2, 3, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'8c7b97798f6542c9ab68415472b34102', 1, 1, -1, N'99283 Emergency department visit for the evaluation and management of a patient, which requires these three key components: an expanded problem focused history, an expanded problem focused examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate severity.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99283', 14001890, -2, 3, 2, 2, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'8c9f4223c6ca4656a9e177017f4f2578', 1, 1, 15, N'99224 Subsequent observation care, per day, for the evaluation and management of a patient, which requires at least 2 of these 3 key components: Problem focused interval history; Problem focused examination; Medical decision making that is straightforward or of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs. Usually, the patient is stable, recovering, or improving. Physicians typically spend 15 minutes at the bedside and on the patient''s hospital floor or unit.', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99224', 11001150, -2, 2, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'8d93279517474c7885cefee3171bf22a', 1, 1, -1, N'90899  Unlisted psychiatric service or procedure', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90899', 37007700, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'8d9a8139ef8748ac824b7cfa36faf4c8', 1, 1, 35, N'99226 Subsequent observation care, per day, for the evaluation and management of a patient, which requires at least 2 of these 3 key components: A detailed interval history; A detailed examination; Medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99226', 11001150, -2, 2, 3, 3, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'8e9c23fe118a4847b4c3b85fa629b7df', 1, 1, -1, N'99363  Anticoagulant management for an outpatient taking warfarin, physician review and interpretation of International Normalized Ratio (INR) testing, patient instructions, dosage adjustments (as needed), and ordering of additional tests; initial 90 days of therapy (must include a minimum of 8 INR measurements)', CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99363', 26503520, -2, 0, -1, -1, -1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'8f1276933a83452087de5d461b48cd0b', 1, 1, -1, N'90815  Individual psychotherapy, interactive, using play equipment, physical devices, language interpreter, or other mechanisms of non-verbal communication, in an office or outpatient facility with medical evaluation and management, approximately 75 - 80 minutes face-to-face with the patient.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2009-12-31T23:59:00.000' AS DateTime), N'90815', 33005600, -2, 0, 0, 0, 0, 0, 364635, 66, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'8f879ee9976444e9a43ef67149c50eb4', 1, 1, 80, N'99254 Initial inpatient consultation for a new or established patient, which requires these three key components:  a comprehensive history, a comprehensive examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate to high severity. Physicians typically spend 80 minutes at the bedside and on the patient''s hospital floor or unit.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99254', 13001850, -2, 3, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'90257d6d76ef4708bd202dd080ffa236', 1, 0, 10, N'99201 Office or other outpatient visit for the evaluation and management of a new patient, which requires these three key components: a problem focused history, a problem focused examination, and straightforward medical decision making.  Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are self limited or minor. Physicians typically spend 10 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99201', 10001000, -2, 3, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, 10, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'916d3de8b91f4a30ae5c2aaf3e6bc1b8', 1, 1, 25, N'99232 Subsequent hospital care, per day, for the evaluation and management of a patient, which requires at least two of these three key components: an expanded problem focused interval history, an expanded problem focused examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the patient is responding inadequately to therapy or has developed a minor complication. Physicians typically spend 25 minutes at the bedside and on the patient''s hospital floor or unit.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99232', 12001300, -2, 2, 2, 2, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'91f382827e0a423ab5af1ad9faaf6035', 1, 1, -1, N'99478  Subsequent intensive care, per day, for the evaluation and management of the recovering very low birth weight infant (present body weight less than 1500 grams)', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99478', 30604692, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'92225559c8ed46f18caa06c9b0da3993', 0, 1, 21, N'99443 Telephone evaluation and management service provided by a physician to an established patient, parent, or guardian not originating from a related E/M service provided within the previous 7 days nor leading to an E/M service or procedure within the next 24 hours or soonest available appointment; 21-30 minutes of medical discussion (Do not report 99441-99443 when using 99339-99340, 99374-99380 for the same call(s)) (Do not report 99441-99443 for anticoagulation management when reporting 99363-99364, 0)', CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2019-12-31T23:59:00.000' AS DateTime), N'99443', 29504250, -2, 0, -1, -1, -1, 0, 364635, 21, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9259453a9d8c459f908621be03abd1e0', 1, 1, -1, N'Chronic care management services are provided when medical and/or psychosocial needs of the patient require establishing, implementing, revising, or monitoring the care plan. Patients who receive chronic care management services have two or more chronic continuous or episodic health conditions that are expected to last at least 12 months, or until the death of the patient, and that place the patient at significant risk of death, acute exacerbation/decompensation, or functional decline. Code 99490 is reported when, during the calendar month, at least 20 minutes of clinical staff time is spent in care management activities.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99490', 43509500, -2, 0, 0, 0, 0, 0, 364635, 20, 999, 1, 3, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9259453a9d8c459f908621be03abd1e01', 1, 1, -1, N'Chronic care management services are provided when medical and/or psychosocial needs of the patient require establishing, implementing, revising, or monitoring the care plan. Patients who receive chronic care management services have two or more chronic continuous or episodic health conditions that are expected to last at least 12 months, or until the death of the patient, and that place the patient at significant risk of death, acute exacerbation/decompensation, or functional decline. Code 99491 is reported when 30 minutes of physician or other qualified health care professional personal time is spent in care management activities. Do not report 99490 in the same month as 99491.', CAST(N'2019-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99491', 43509500, -2, 0, 0, 0, 0, 0, 364635, 30, 999, 1, 4, 0, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'925b83de0af94ad1baf2a2a5685bf08f', 1, 0, -1, N'99460  Initial hospital or birthing center care, per day, for evaluation and management of normal newborn infant', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99460', 30104510, -2, 0, 1, 1, -1, 0, 29, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'943c15bb763f46b39efd3cd33bb959f9', 1, 1, -1, N'99479  Subsequent intensive care, per day, for the evaluation and management of the recovering very low birth weight infant (present body weight 1500-2500 grams)', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99479', 30604694, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9483db1b04c84b638b748dacc3761a84', 1, 1, -1, N'99291 Critical care, evaluation and management of the critically ill or critically injured patient; first 30-74 minutes. For inpatient critical care services provided to patients 72 months of age or younger, see pediatric critical care codes 99471-99476 or neonatal critical care codes 99468, 99469. For transport services of critically ill or critically injured pediatric patients 24 months of age or younger, see 99466, 99467.', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99291', 16002000, -2, 0, -1, -1, -1, 2190, 364635, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9515b0e183a44365a454c8674471d90f1', 0, 1, -1, N'99211 Office or other outpatient visit for the evaluation and management of an established patient that may not require the presence of a physician or other qualified health care professional', CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99211', 10001005, -2, 0, -1, -1, 0, 0, 364635, 0, 9, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9515b0e183a44365a454c8674471d90f10', 1, 1, 70, N'99492 Initial psychiatric collaborative care management, first 70 minutes in the first calendar month of behavioral health care manager activities, in consultation with a psychiatric consultant, and directed by the treating physician or other qualified health care professional, with the following required elements: outreach to and engagement in treatment of a patient directed by the treating physician or other qualified health care professional, initial assessment of the patient, including administration of validated rating scales, with the development of an individualized treatment plan, review by the psychiatric consultant with modifications of the plan if recommended, entering patient in a registry and tracking patient follow-up and progress using the registry, with appropriate documentation, and participation in weekly caseload consultation with the psychiatric consultant, and provision of brief interventions using evidence-based techniques such as behavioral activation, motivational interviewing, and other focused treatment strategies.', CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99492', 43751000, -2, 0, 0, 0, 0, 0, 364635, 36, 999, 8, 5, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9515b0e183a44365a454c8674471d90f11', 1, 1, 60, N'99493 Subsequent psychiatric collaborative care management, first 60 minutes in a subsequent month of behavioral health care manager activities, in consultation with a psychiatric consultant, and directed by the treating physician or other qualified health care professional, with the following required elements: tracking patient follow-up and progress using the registry, with appropriate documentation, participation in weekly caseload consultation with the psychiatric consultant, ongoing collaboration with and coordination of the patient''s mental health care with the treating physician or other qualified health care professional and any other treating mental health providers, additional review of progress and recommendations for changes in treatment, as indicated, including medications, based on recommendations provided by the psychiatric consultant, provision of brief interventions using evidence-based techniques such as behavioral activation, motivational interviewing, and other focused treatment strategies, monitoring of patient outcomes using validated rating scales, and relapse prevention planning with patients as they achieve remission of symptoms and/or other treatment goals and are prepared for discharge from active treatment.', CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99493', 43752000, -2, 0, 0, 0, 0, 0, 364635, 31, 999, 9, 7, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9515b0e183a44365a454c8674471d90f2', 0, 1, -1, N'99211 Office or other outpatient visit for the evaluation and management of an established patient that may not require the presence of a physician or other qualified health care professional', CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99211', 10001005, -2, 0, -1, -1, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9515b0e183a44365a454c8674471d90f3', 1, 1, -1, N'99424 Principal care management services, for a single high-risk disease, with the following required elements: one complex chronic condition expected to last at least 3 months, and that places the patient at significant risk of hospitalization, acute exacerbation/decompensation, functional decline, or death, the condition requires development, monitoring, or revision of disease-specific care plan, the condition requires frequent adjustments in the medication regimen and/or the management of the condition is unusually complex due to comorbidities, ongoing communication and care coordination between relevant practitioners furnishing care; first 30 minutes provided personally by a physician or other qualified health care professional, per calendar month.', CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99424', 43509710, 0, 0, 0, 0, 0, 0, 364635, 30, 999, 21, 5, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9515b0e183a44365a454c8674471d90f4', 1, 1, -1, N'99426 Principal care management services, for a single high-risk disease, with the following required elements: one complex chronic condition expected to last at least 3 months, and that places the patient at significant risk of hospitalization, acute exacerbation/decompensation, functional decline, or death, the condition requires development, monitoring, or revision of disease-specific care plan, the condition requires frequent adjustments in the medication regimen and/or the management of the condition is unusually complex due to comorbidities, ongoing communication and care coordination between relevant practitioners furnishing care; first 30 minutes of clinical staff time directed by physician or other qualified health care professional, per calendar month.', CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99426', 43509720, 0, 0, 0, 0, 0, 0, 364635, 30, 999, 21, 5, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9515b0e183a44365a454c8674471d90f5', 1, 1, 50, N'99483 Assessment of and care planning for a patient with cognitive impairment, requiring an independent historian, in the office or other outpatient, home or domiciliary or rest home, with all of the following required elements: Cognition-focused evaluation including a pertinent history and examination, Medical decision making of moderate or high complexity, Functional assessment (eg, basic and instrumental activities of daily living), including decision-making capacity, Use of standardized instruments for staging of dementia (eg, functional assessment staging test [FAST], clinical dementia rating [CDR]), Medication reconciliation and review for high-risk medications, Evaluation for neuropsychiatric and behavioral symptoms, including depression, including use of standardized screening instrument(s), Evaluation of safety (eg, home), including motor vehicle operation, Identification of caregiver(s), caregiver knowledge, caregiver needs, social supports, and the willingness of caregiver to take on caregiving tasks, Development, updating or revision, or review of an Advance Care Plan, Creation of a written care plan, including initial plans to address any neuropsychiatric symptoms, neuro-cognitive symptoms, functional limitations, and referral to community resources as needed (eg, rehabilitation services, adult day programs, support groups) shared with the patient and/or caregiver with initial education and support. Typically, 50 minutes are spent face-to-face with the patient and/or family or caregiver.', CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99483', 4325, -2, 1, -1, -1, 3, 0, 364635, 0, 999, 10, 9, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9515b0e183a44365a454c8674471d90f6', 1, 1, -1, N'99484 Care management services for behavioral health conditions, at least 20 minutes of clinical staff time, directed by a physician or other qualified health care professional, per calendar month, with the following required elements: initial assessment or follow-up monitoring, including the use of applicable validated rating scales, behavioral health care planning in relation to behavioral/psychiatric health problems, including revision for patients who are not progressing or whose status changes, facilitating and coordinating treatment such as psychotherapy, pharmacotherapy, counseling and/or psychiatric consultation, and continuity of care with a designated member of the care team.', CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99484', 4550, -2, 0, -1, -1, -1, 0, 364635, 20, 999, 11, 4, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9515b0e183a44365a454c8674471d90f7', 1, 1, -4, N'99487 Complex chronic care management services with the following required elements: multiple (two or more) chronic conditions expected to last at least 12 months, or until the death of the patient, chronic conditions that place the patient at significant risk of death, acute exacerbation/decompensation, or functional decline, comprehensive care plan established, implemented, revised, or monitored, moderate or high complexity medical decision making; first 60 minutes of clinical staff time directed by a physician or other qualified health care professional, per calendar month.', CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99487', 43509600, -2, 1, -1, -1, 3, 0, 364635, 60, 999, 2, 3, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9515b0e183a44365a454c8674471d90f8', 1, 1, -1, N'99490 Chronic care management services with the following required elements: multiple (two or more) chronic conditions expected to last at least 12 months, or until the death of the patient, chronic conditions that place the patient at significant risk of death, acute exacerbation/decompensation, or functional decline, comprehensive care plan established, implemented, revised, or monitored; first 20 minutes of clinical staff time directed by a physician or other qualified health care professional, per calendar month.', CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99490', 43509510, -2, 0, 0, 0, 0, 0, 364635, 20, 999, 1, 3, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9515b0e183a44365a454c8674471d90f9', 1, 1, -1, N'99491 Chronic care management services with the following required elements: multiple (two or more) chronic conditions expected to last at least 12 months, or until the death of the patient, chronic conditions that place the patient at significant risk of death, acute exacerbation/decompensation, or functional decline, comprehensive care plan established, implemented, revised, or monitored; first 30 minutes provided personally by a physician or other qualified health care professional, per calendar month.', CAST(N'2022-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99491', 43509520, -2, 0, 0, 0, 0, 0, 364635, 30, 999, 1, 3, 0, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'95760bae88a945e5a87a202b17b0d250', 0, 1, 60, N'99337 Domiciliary rest home visit for the evaluation and management of an established patient, which requires these 2 key components: a comprehensive interval history, a comprehensive examination, and medical decision making of high complexity. Counseling and/or coordination of care with other physicians, other qualified health care professionals, or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs. Usually, the presenting problem(s) are of moderate to high severity. The patient may be unstable or may have developed a significant new problem requiring immediate physician attention.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99337', 21003100, -2, 2, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'964525f6d0064cc0952c892ee5d513fa', 1, 1, -1, N'90880  Hypnotherapy', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90880', 37007200, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'964dfa91bed74c8398b73098731ec36a', 1, 1, -1, N'G0402 IPPE (Welcome to Medicare)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2017-12-31T23:59:00.000' AS DateTime), N'G0402', 28003870, -2, 1, 4, -1, -1, 0, 364635, 0, 999, 35, 1, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'96827dac91de42e8ada636060630607b', 1, 1, 70, N'99492 Initial psychiatric collaborative care management, first 70 minutes in the first calendar month of behavioral health care manager activities, in consultation with a psychiatric consultant, and directed by the treating physician or other qualified health care professional, with the following required elements: outreach to and engagement in treatment of a patient directed by the treating physician or other qualified health care professional; initial assessment of the patient, including administration of validated rating scales, with the development of an individualized treatment plan; review by the psychiatric consultant with modifications of the plan if recommended; entering patient in a registry and tracking patient follow-up and progress using the registry, with appropriate documentation, and participation in weekly caseload consultation with the psychiatric consultant; and provision of brief interventions using evidence-based techniques such as behavioral activation, motivational interviewing, and other focused treatment strategies.', CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2021-12-31T23:59:00.000' AS DateTime), N'99492', 43751000, -2, 0, 0, 0, 0, 0, 364635, 36, 999, 8, 5, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9687eef2dccb469ab11d828660da9b67', 0, 1, 60, N'99350 Home visit for the evaluation and management of an established patient, which requires two of these three key components:  a comprehensive interval history, a comprehensive examination, and a medical decision making of moderate to high complexity.  Usually, the presenting problem(s) are of moderate to high severity.  The patient may be unstable or may have developed a significant new problem requiring immediate physician attention.  Physicians typically spend 60 minutes face-to-face with the patient and/or family.', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99350', 23003200, -2, 2, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'96e980fdf2d046da909ffbf6b2d5bb10', 1, 1, -1, N'99455  Work related or medical disability examination by the treating physician that includes:  completion of a medical history commensurate with the patient''s condition;  performance of an examination commensurate with the patient''s condition; formulation of a diagnosis, assessment of capabilities and stability, and calculation of impairment; development of future medical treatment plan; and completion of necessary documentation/certificates and report.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99455', 43504400, -2, 3, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'96f76f2b442e4b6088d1af1d63cb013f', 1, 1, -1, N'90807  Individual psychotherapy, insight oriented, behavior modifying and/or supportive, in an office or outpatient facility with medical evaluation and management services, approximately 45 - 50 minutes face-to-face with the patient.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2009-12-31T23:59:00.000' AS DateTime), N'90807', 33005400, -2, 0, 0, 0, 0, 0, 364635, 36, 65, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9736ac4c17304bbba7f6985865f9fa20', 0, 1, 0, N'99495  Transitional Care Management Services with the following required elements:  1, 0)  Communication (direct contact, telephone, electronic) with the patient and/or caregiver within 2 business days of discharge, 2, 0) Medical decision making of at least moderate complexity during the service period, 3, 0) Face-to-face visit, within 14 calendar days', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99495', 44009400, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9814bf1f85f246f1ad03db4d9bde0155', 1, 1, -1, N'99401  Preventive medicine counseling and/or risk factor reduction intervention(s) provided to an individual (separate procedure);  approximately 15 minutes', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99401', 38953900, -2, 0, -1, -1, -1, 0, 364635, 8, 22, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'98a02d2b05b7441e93654cab3cc2dd95', 1, 1, 80, N'99254 Initial inpatient consultation for a new or established patient, which requires these three key components:  a comprehensive history, a comprehensive examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate to high severity. Physicians typically spend 80 minutes at the bedside and on the patient''s hospital floor or unit.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99254', 13001800, -2, 3, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'991fb952296d4c2da762621a6a379f80', 1, 1, -1, N'98925  Osteopathic manipulative treatment (OMT) is a form of manual treatment applied by a physician to eliminate or alleviate somatic dysfunction and related disorders.  This treatment may be accomplished by a variety of techniques. (OMT); one to two body regions involved', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98925', 39008200, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9945b9784c9b43089c172a72407de77a', 1, 0, -1, N'99431  History and examination of the normal newborn infant, initiation of diagnostic and treatment programs and preparation of hospital records.  (This code should also be used for birthing room deliveries.)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99431', 29004170, -2, 2, 1, 1, 999, 0, 365, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9a3a2a3b1f5d457e86ce13c750f55bb9', 1, 1, -1, N'99466  Critical care services delivered by a physician, face-to-face, during an interfacility transport of critically ill or critically injured pediactric patient, 24 months of age or less; first 30-74 minutes of hands-on care during transport.', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99466', 3020, -2, 0, 0, 0, 0, 0, 730, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9a9c9158adc043ea96fff15a848b895b', 1, 1, 30, N'99218 Initial observation care, per day, for the evaluation and management of a patient which requires these three key components: a detailed or comprehensive history, a detailed or comprehensive examination, and medical decision making that is straightforward or of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission to "observation status" are of low severity.', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2017-12-31T23:59:00.000' AS DateTime), N'99218', 11001100, -2, 3, 3, 3, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9c3ef5d24e214c71bdc51163b27332c5', 1, 1, -1, N'99408 Alcohol and/or substance (other than tobacco) abuse structured screening (eg, AUDIT, DAST), and brief intervention (SBI) services; 15 to 30 minutes (Do not report services of less than 15 minutes with 99408, 0) (Do not report 99408, 99409 in conjunction with 99420, 0) (Use 99408, 99409 only for initial screening and brief intervention)', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99408', 38953920, -2, 0, -1, -1, -1, 0, 364635, 15, 30, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9cb3fec66edc408e94f30dd62cc47e98', 1, 1, 70, N'99220 Initial observation care, per day, for the evaluation and management of a patient, which requires these three key components: a comprehensive history;  a comprehensive examination; and  medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission to "observation status" are of high severity.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'99220', 11001100, -2, 3, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9d6d667ad0f4468abcb8dccee18665f6', 1, 0, -1, N'92002  Intermediate ophthalmological services, new patient.  Medical examination and evaluation with initiation of diagnostic and treatment program.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'92002', 32005100, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9d89167469d6493a90fabbc7654a861e', 1, 1, -1, N'99420  Administration and interpretation of health risk assessment instrument (e.g., health hazard appraisal)', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2016-12-31T23:59:00.000' AS DateTime), N'99420', 40504100, -2, 0, -1, -1, -1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9dd35706c6ab4b6ea7ca327600d05fd1', 1, 1, 15, N'99224 Subsequent observation care, per day, for the evaluation and management of a patient, which requires at least 2 of these 3 key components: Problem focused interval history; Problem focused examination; Medical decision making that is straightforward or of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs. Usually, the patient is stable, recovering, or improving. Physicians typically spend 15 minutes at the bedside and on the patient''s hospital floor or unit.', CAST(N'2011-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'99224', 11001150, -2, 2, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9e5caf16b15544ee85f6933b15e9d882', 1, 1, 15, N'99241 Office consultation for a new or established patient, which requires these three key components:  a problem focused history, problem focused examination, and straightforward medical decision making.  Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are self limited or minor. Physicians typically spend 15 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99241', 13001700, -2, 3, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9ee18f63f3684b6aa73dfd0e32ccd32b', 1, 1, -1, N'99364  Anticoagulant management for an outpatient taking warfarin, physician review and interpretation of International Normalized Ratio (INR) testing, patient instructions, dosage adjustments (as needed), and ordering of additional tests; initial 90 days of therapy (must include a minimum of 8 INR measurements) each subsequent 90 days of therapy (must include a minimum of 3 INR measurements)', CAST(N'2007-01-01T00:00:00.000' AS DateTime), CAST(N'2007-12-31T23:59:00.000' AS DateTime), N'99364', 26503560, -2, 0, -1, -1, -1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9f65c4ebb5454bdc907a14f790fcfd1d', 1, 1, -1, N'99403  Preventive medicine counseling and/or risk factor reduction intervention(s) provided to an individual (separate procedure);  approximately 45 minutes', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99403', 38953900, -2, 0, -1, -1, -1, 0, 364635, 38, 52, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'9fcb3ff579c24dd29bb157a40cf66894', 0, 1, -1, N'92014  Comprehensive ophthalmological services, established patient.  Medical examination and evaluation with initiation or continuation of diagnostic and treatment program, one or more visits.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'92014', 32005200, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a0a48a5e5c30408f8577aa474ea878e6', 1, 1, 0, N'Interprofessional telephone/Internet assessment and management service provided by a consultative physician including a verbal and written report to the patient''s treating/requesting physician or other qualified health care professional; 5-10 minutes of medical consultative discussion and review', CAST(N'2014-01-01T00:00:00.000' AS DateTime), CAST(N'2018-12-31T23:59:00.000' AS DateTime), N'99446', 29509500, -2, 0, 0, 0, 0, 0, 364635, 5, 10, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a0caa4d39c7a4ee09b41fff785d0eecb', 0, 1, 0, N'99495  Transitional Care Management Services with the following required elements:  1, 0)  Communication (direct contact, telephone, electronic) with the patient and/or caregiver within 2 business days of discharge, 2, 0) Medical decision making of at least moderate complexity during the service period, 3, 0) Face-to-face visit, within 14 calendar days', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99495', 44009300, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a104ea194660459bb8644f0998cb39a1', 1, 1, 30, N'99221 Initial hospital care, per day, for the evaluation and management of a patient, which requires these three key components: a detailed or comprehensive history, a detailed or comprehensive examination, and medical decision making that is straightforward or of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission are of low severity. Physicians typically spend 30 minutes at the bedside and on the patient''s hospital floor or unit.', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99221', 12001200, -2, 3, 3, 3, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a18df38fce99490c96bef2e40936f3e0', 1, 1, -1, N'99368  Medical team conference with interdisciplinary team of health care professionals, patient and/or family not present, 30 minutes or more; participation by nonphysician qualified health care professional', CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99368', 26003570, -2, 0, -1, -1, -1, 0, 364635, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a19657bb98a440fabb98ed34b85ac604', 1, 1, 40, N'99252 Initial inpatient consultation for a new or established patient, which requires these three key components:  an expanded problem focused history, an expanded problem focused examination, and straightforward medical decision making.  Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of low severity. Physicians typically spend 40 minutes at the bedside and on the patient''s hospital floor or unit.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99252', 13001800, -2, 3, 2, 2, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a1b1aa3ab43c4b588671d770a25325d6', 1, 1, 55, N'99253 Initial inpatient consultation for a new or established patient, which requires these three key components:  a detailed history, a detailed examination, and medical decision making of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate severity. Physicians typically spend 55 minutes at the bedside and on the patient''s hospital floor or unit.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99253', 13001850, -2, 3, 3, 3, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a1ca8cebdc274affa88cdfd81cc01906', 1, 1, 35, N'99305 Initial nursing facility care, per day, for the evaluation and management of a patient which requires these three key components: a comprehensive history, a comprehensive examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission are of moderate severity.', CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99305', 20002780, -2, 3, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a2a054bfbb3f4cf999c54200be37b675', 1, 1, 30, N'99242 Office consultation for a new or established patient, which requires these three key components:  an expanded problem focused history, an expanded problem focused examination, and straightforward medical decision making.  Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of low severity. Physicians typically spend 30 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99242', 13001700, -2, 3, 2, 2, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a2b19b716890498f86d3fc8b7ba1c002', 1, 1, 0, N'Interprofessional telephone/Internet/electronic health record assessment and management service provided by a consultative physician including a written report to the patient''s treating/requesting physician or other qualified health care professional; 5-10 minutes of medical consultative discussion time', CAST(N'2019-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99451', 29509510, -2, 0, 0, 0, 0, 0, 364635, 5, 999, 13, 1, 1, -1, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a2ba3af1bb1044cf97fd6fee8471770e', 1, 1, -1, N'99355 Prolonged physician service (outpatient) duration: 165-194 minutes', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T23:59:00.000' AS DateTime), N'99354/99355x4', 24003300, -2, 0, -1, -1, -1, 0, 364635, 165, 999, NULL, NULL, NULL, -1, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a2d34065788d450086b7c8f45f5b2d4a', 1, 1, -1, N'99404  Preventive medicine counseling and/or risk factor reduction intervention(s) provided to an individual (separate procedure);  approximately 60 minutes', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99404', 38953900, -2, 0, -1, -1, -1, 0, 364635, 53, 999, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a30b2bdd27174fee9f58bd00a3bcd17d', 1, 1, -1, N'90824  Individual psychotherapy, interactive, using play equipment, physical devices, language interpreter, or other mechanisms of non-verbal communication, in an inpatient hospital, partial hospital or residential care setting, approximately 20 to 30 minutes face-to-face with the patient with medical evaluation and management services.', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90824', 34006000, -2, 0, 0, 0, 0, 0, 364635, 20, 44, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a325e87c9e3a42ab89bb838885c08510', 1, 1, -1, N'90817  Individual psychotherapy, insight oriented, behavior and/or supportive, in an inpatient hospital, partial hospital or residential care setting, approximately 20 to 30 minutes face-to-face with the patient with medical evaluation and management services', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2009-12-31T23:59:00.000' AS DateTime), N'90817', 34005800, -2, 0, 0, 0, 0, 0, 364635, 20, 35, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a372133ec85d4be1ac0fc78c00ad4197', 1, 1, -1, N'99411  Preventive medicine counseling and/or risk factor reduction intervention(s) provided to individuals in a group setting (separate procedure); approximately 30 minutes', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2007-12-31T23:59:00.000' AS DateTime), N'99411', 28004000, -2, 0, -1, -1, -1, 0, 364635, 0, 30, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a592dbc7f6c447c796488ac9b49e0781', 1, 1, -1, N'99476  Subsequent inpatient pediatric critical care, per day, for the evaluation and management of a critically ill infant or young child, 2 through 5 years of age.', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99476', 30554688, -2, 0, 0, 0, 0, 730, 2190, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a595d32d95fd4ef88e9c838e6bcc252a', 0, 1, 40, N'99215 Office or other outpatient visit for the evaluation and management of an established patient, which requires at least two of these three key components:  a comprehensive history, a comprehensive examination, and medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate to high severity. Physicians typically spend 40 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99215', 1000, -2, 2, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a607ac897c8c43469559877561b82358', 1, 1, -1, N'99299 Subsequent intensive care, per day, for the evaluation and management of the recovering low birth weight infant (present body weight of 1500-2500 grams).  Infants with present body weight of 1500-2500 grams who are not critically ill but continue to require intensive cardiac and respiratory monitoring, continuous and/or frequent vital sign monitoring, heat maintenance, enteral and/or parenteral nutritional adjustments, laboratory and oxygen monitoring, and constant observation by the health care team under direct physician supervision.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99299', 19002600, -2, 0, -1, -1, -1, 0, 365, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a650ede84d944658b787d55c716e96e0', 1, 0, -1, N'92004  Comprehensive ophthalmological services, new patient.  Medical examination and evaluation with initiation of diagnostic and treatment program, one or more visits.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'92004', 32005200, -2, 0, 0, 0, 0, 0, 364635, 0, 0, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a7766dedfdd8431db18dcca51544aa76', 1, 1, 55, N'99253 Initial inpatient consultation for a new or established patient, which requires these three key components:  a detailed history, a detailed examination, and medical decision making of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate severity. Physicians typically spend 55 minutes at the bedside and on the patient''s hospital floor or unit.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99253', 13001800, -2, 3, 3, 3, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a7dc79bc555648b6bccae90ce57045b9', 1, 1, -1, N'99456  Work related or medical disability examination by other than the treating physician that includes:  completion of a medical history commensurate with the patient''s condition;  performance of an examination commensurate with the patient''s condition; formulation of a diagnosis, assessment of capabilities and stability, and calculation of impairment; development of future medical treatment plan; and completion of necessary documentation/certificates and report.', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99456', 30004500, -2, 3, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a816613a3bc7485a91d8101be19464f3', 1, 1, 15, N'99308 Subsequent nursing facility care, per day, for the evaluation and management of a patient, which requires at least two of these three key components:  an expanded problem focused interval history, an expanded problem focused examination, and medical decision making of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the patient is responding inadequately to therapy or has developed a minor complication.', CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99308', 20002900, -2, 2, 2, 2, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a8a00aedeee041b7a2cb566a3c102967', 1, 0, -1, N'99387  Initial comprehensive preventive medicine evaluation and management of an individual including an AGE and GENDER APPROPRIATE HISTORY, EXAMINATION, counseling/anticipatory guidance/risk factor reduction interventions, and the ordering of appropriate immunization(s), laboratory/diagnostic procedures, new patient;  age 65 years and older.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99387', 28003840, -2, 0, -1, -1, -1, 23725, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 7)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a9043f5d662b4e09aad97524bf9852a7', 1, 1, -1, N'90808  Individual psychotherapy, insight oriented, behavior modifying and/or supportive, in an office or outpatient facility, approximately 75 - 80 minutes face-to-face with the patient.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2009-12-31T23:59:00.000' AS DateTime), N'90808', 33005300, -2, 0, 0, 0, 0, 0, 364635, 66, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a918f2540bd04ec0b363e4fc587c0bbf', 0, 1, -1, N'99397  Periodic comprehensive preventive medicine reevaluation and management of an individual including an AGE and GENDER APPROPRIATE HISTORY, EXAMINATION, counseling/anticipatory guidance/risk factor reduction interventions, and the ordering of appropriate immunization(s), laboratory/diagnostic procedures, established patient;  65 years and over', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99397', 28003850, -2, 0, -1, -1, -1, 23725, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 7)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'a9ab82c37f3f4f2eb28e25070a4f9091', 1, 0, -1, N'99463  Initial hospital or birthing center care, per day, for evaluation and management of normal newborn infant admitted and discharged on the same date.  (For newborn hospital discharge services provided on a date subsequent to the admission date, see 99238, 99239, 0)', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99463', 30104540, -2, 0, 1, 1, -1, 0, 29, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'aa70b1e17faa48cdad098967d0708f8c', 1, 1, -1, N'99380  Physician supervision of a nursing facility patient (patient not present) requiring complex and multidisciplinary care modalities involving regular physician development an/or revision of care plans, review of subsequent reports of patient status, review of related laboratory and other studies, communication (including telephone calls) with other health care professionals involved in patient''s care, integration of new information into the medical treatment plan and/or adjustment of medical therapy, within a calendar month; 30 minutes or more', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99380', 27003830, -2, 0, -1, -1, -1, 0, 364635, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'aaa8c19eebb74dc2b7bf379bbc7d37cb', 1, 0, -1, N'99465 Delivery/birthing room resuscitation, provision of positive pressure ventilation and/or chest compressions in the presence of acute inadequate ventilation and/or cardiac output. (Do not report 99465 in conjunction with 99460, 99468, 99477, 0) (Do not report 99465 in conjunction with 99464, 0) (Procedures that are performed as a necessary part of the resuscitation [eg, intubation, vascular lines] are reported separately in addition to 99465.  In order to report these procedures, they must be performed as a necessary component of the resuscitation and not as a convenience before admission to the neonatal intensive care unit)', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99465', 30104560, -2, 0, -1, -1, -1, 0, 28, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'ab222da2565e492b806fc507e5e3f649', 1, 1, -1, N'99364  Anticoagulant management for an outpatient taking warfarin, physician review and interpretation of International Normalized Ratio (INR) testing, patient instructions, dosage adjustments (as needed), and ordering of additional tests; initial 90 days of therapy (must include a minimum of 8 INR measurements) each subsequent 90 days of therapy (must include a minimum of 3 INR measurements)', CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99364', 26503530, -2, 0, -1, -1, -1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'ab3e98dbe41f422c86a47b488f5efaee', 1, 1, 50, N'99483 Assessment of and care planning for a patient with cognitive impairment, requiring an independent historian, in the office or other outpatient, home or domiciliary or rest home, with all of the following required elements: Cognition-focused evaluation including a pertinent history and examination; Medical decision making of moderate or high complexity; Functional assessment (eg, basic and instrumental activities of daily living), including decision-making capacity; Use of standardized instruments for staging of dementia (eg, functional assessment staging test [FAST], clinical dementia rating [CDR]); Medication reconciliation and review for high-risk medications; Evaluation for neuropsychiatric and behavioral symptoms, including depression, including use of standardized screening instrument(s); Evaluation of safety (eg, home), including motor vehicle operation; Identification of caregiver(s), caregiver knowledge, caregiver needs, social supports, and the willingness of caregiver to take on caregiving tasks; Development, updating or revision, or review of an Advance Care Plan; Creation of a written care plan, including initial plans to address any neuropsychiatric symptoms, neuro-cognitive symptoms, functional limitations, and referral to community resources as needed (eg, rehabilitation services, adult day programs, support groups) shared with the patient and/or caregiver with initial education and support. Typically, 50 minutes are spent face-to-face with the patient and/or family or caregiver.', CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2021-12-31T23:59:00.000' AS DateTime), N'99483', 4325, -2, 1, -1, -1, 3, 0, 364635, 0, 999, 10, 9, 0, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'abf106d6564b4e80bc7f021b22cc90cd', 1, 1, 30, N'99242 Office consultation for a new or established patient, which requires these three key components:  an expanded problem focused history, an expanded problem focused examination, and straightforward medical decision making.  Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of low severity. Physicians typically spend 30 minutes face-to-face with the patient and/or family.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99242', 13001750, -2, 3, 2, 2, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'ac57d1f08ebd4db7a3bf4e2fccd9f7b2', 1, 1, -1, N'99355 Prolonged physician service (outpatient) duration: 105-134 minutes', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T23:59:00.000' AS DateTime), N'99354/99355x2', 24003300, -2, 0, -1, -1, -1, 0, 364635, 105, 134, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'ac8ed66ee7de4891a1a6a28cac2b4aff', 1, 1, -1, N'99354  Prolonged physician service in the office or other outpatient setting requiring direct (face-to-face) patient contact beyond the usual service (e.g., prolonged care and treatment of an acute asthmatic patient in an outpatient setting); first hour', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99354', 24003300, -2, 0, -1, -1, -1, 0, 364635, 0, 60, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'acf6b992ab6b469d8cf3a18ec106a46e', 0, 1, 40, N'99336 Domiciliary rest home visit for the evaluation and management of an established patient, which requires these 2 key components: a detailed interval history, a detailed examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other physicians, other qualified health care professionals, or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs. Usually, the presenting problem(s) are of moderate to high severity.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99336', 21003100, -2, 2, 3, 3, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'ad5f2f26d78a482496668461b639c14b', 1, 1, -1, N'99455  Work related or medical disability examination by the treating physician that includes:  completion of a medical history commensurate with the patient''s condition;  performance of an examination commensurate with the patient''s condition; formulation of a diagnosis, assessment of capabilities and stability, and calculation of impairment; development of future medical treatment plan; and completion of necessary documentation/certificates and report.', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99455', 30004400, -2, 3, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'ae07febecf8e40b892e52b497ada6c83', 1, 1, -1, N'99379  Physician supervision of a nursing facility patient (patient not present) requiring complex and multidisciplinary care modalities involving regular physician development an/or revision of care plans, review of subsequent reports of patient status, review of related laboratory and other studies, communication (including telephone calls) with other health care professionals involved in patient''s care, integration of new information into the medical treatment plan and/or adjustment of medical therapy, within a calendar month; 15 - 29 minutes', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99379', 27003830, -2, 0, -1, -1, -1, 0, 364635, 15, 29, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'ae1714f9713340e6981b698c617d63d4', 1, 0, -1, N'99432  Normal newborn care in other than hospital or birthing room setting, including physical examination of baby and conference(s) with parent(s)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99432', 29004180, -2, 1, -1, 1, -1, 0, 365, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'af67500357a1492dac47ac43cbebcf64', 1, 1, -1, N'99355 Prolonged physician service (outpatient) duration: 135-164 minutes', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T23:59:00.000' AS DateTime), N'99354/99355x3', 24003300, -2, 0, -1, -1, -1, 0, 364635, 135, 164, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'afe7ca7ed7a4439bbeb964b5c598f444', 1, 1, -1, N'99406 Smoking and tobacco use cessation counseling visit; intermediate, greater than 3 minutes up to 10 minutes', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99406', 38953910, -2, 0, -1, -1, -1, 0, 364635, 3, 10, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b031292daf304bfcb3c8280e92fb745c', 1, 1, -1, N'99358  Prolonged evaluation and management service before and/or after direct (Face-to-Face) patient care (e.g., review of extensive records and tests, communication with other professionals and/or the patient/family); first hour', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99358', 25003300, -2, 0, -1, -1, -1, 0, 364635, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b0401fd747444269876a733169c39c44', 1, 1, -1, N'90865  Narcosynthesis for psychiatric diagnostic and therapeutic purposes (eg, sodium amobarbital (Amytal) interview)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90865', 37006800, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b195222a435f40e389281a83d82b7f0a', 1, 1, -1, N'98941  Chiropractic Manipulative Treatment (CMT) is a form of manual treatment to influence joint and neurophysiological function.  This treatment may be accomplished using a variety of techniques.  (CMT); spinal, three to four regions', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'98941', 40008800, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b19de90d0e524a798d6d03b82e43df23', 1, 1, -1, N'99300 Subsequent intensive care, per day, for the evaluation and management of the recovering infant (present body weight of 2501-5000 grams)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99300', 19002700, -2, 0, -1, -1, -1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b1c129e7a32d429fa524958c12784a5c', 1, 1, 45, N'99306 Initial nursing facility care, per day, for the evaluation and management of a patient, which requires these three key components: a comprehensive history, a comprehensive examination, and medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission are of high severity.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99306', 27802785, -2, 3, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b1f24aa458d047a79f85c1293b3de403', 0, 1, 0, N'99444 Online evaluation and management service provided by a physician to an established patient, guardian, or health care provider not originating from a related E.M service provided within the previous 7 days, using the Internet or similar electronic communications network. (Do not report 99444 when using 99339-99340, 99374-99380 for the same communication(s)) (Do not report 99444 for anticoagulation management when reporting 99363, 99364, 0) (Do not report 99444 during the same month with 99487-99489, 0) (Do not report 99444 when performed during the service time of codes 99495 or 99496, 0)', CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2019-12-31T23:59:00.000' AS DateTime), N'99444', 29504255, -2, 0, -1, -1, -1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b1fff6fc0f254374ac565427c8b9ed6e', 1, 1, -1, N'90849  Multiple-family group psychotherapy', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'90849', 36006400, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b26ab258b45342feb8f51a3f35d254b2', 1, 0, 75, N'99328 Domiciliary rest home visit for the evaluation and management of a new patient, which requires these 3 key components: a comprehensive history, a comprehensive examination, and medical decision making of high complexity. Counseling and/or coordination of care with other physicians, other qualified health care professionals, or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs. Usually, the patient is unstable or has developed a significant new problem requiring immediate physician attention.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99328', 21003050, -2, 3, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b356fc9cc6374d7ba6e6540f089f0bff', 1, 1, -1, N'99450  Basic life and/or disability examination that includes, height, weight and blood pressure;  completion of a medical history following a life insurance pro forma; collection of blood sample and/or urinalysis complying with "chain of custody" protocols; and  completion of necessary documentation/certificates', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99450', 30004300, -2, 3, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b48c4bd674564c6c90953cc750f09ef3', 1, 1, -1, N'99456  Work related or medical disability examination by other than the treating physician that includes:  completion of a medical history commensurate with the patient''s condition;  performance of an examination commensurate with the patient''s condition; formulation of a diagnosis, assessment of capabilities and stability, and calculation of impairment; development of future medical treatment plan; and completion of necessary documentation/certificates and report.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2008-12-31T23:59:00.000' AS DateTime), N'99456', 30004600, -2, 3, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b506b4a030ad462b8f420216f3878438', 0, 1, 25, N'99214 Office or other outpatient visit for the evaluation and management of an established patient, which requires at least two of these three key components:  a detailed history, a detailed examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate to high severity. Physicians typically spend 25 minutes face-to-face with the patient and/or family.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2020-12-31T23:59:00.000' AS DateTime), N'99214', 10001005, -2, 2, 3, 3, 3, 0, 364635, 0, 999, NULL, NULL, NULL, 25, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b5bf7d7d6bb5420e961352cfd928f48d', 1, 1, 53, N'Psychotherapy, 60 minutes with patient and/or family member. For add-on code 90838 go to Other Services and input code in Procedures.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2016-12-31T23:59:00.000' AS DateTime), N'90837', 35003545, -2, 0, 0, 0, 0, 0, 364635, 53, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b60393002a7943cfb83fc4e07b77e4f1', 1, 1, -1, N'99307 Subsequent nursing facility care, per day, for the evaluation and management of a patient, which requires at least two of these three key components:  a problem focused interval history;  a problem focused examination;  straightforward medical decision making.  Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the patient is stable, recovering, or improving.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2007-12-31T23:59:00.000' AS DateTime), N'99307', 20002900, -2, 2, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b658b862e0db4ce9a65f02d1a8e48dc1', 1, 1, 0, N'Remote physiologic monitoring treatment management services, 20 minutes or more of clinical staff/physician/other qualified health care professional time in a calendar month requiring interactive communication with the patient/caregiver during the month', CAST(N'2019-01-01T00:00:00.000' AS DateTime), CAST(N'2019-12-31T23:59:00.000' AS DateTime), N'99457', 29509700, -2, 0, 0, 0, 0, 0, 364635, 20, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b734ad94788746cab4ce74d56fc43ad7', 0, 1, 11, N'99442 Telephone evaluation and management service provided by a physician to an established patient, parent, or guardian not originating from a related E/M service provided within the previous 7 days nor leading to an E/M service or procedure within the next 24 hours or soonest available appointment; 11-20 minutes of medical discussion', CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2019-12-31T23:59:00.000' AS DateTime), N'99442', 29504250, -2, 0, -1, -1, -1, 0, 364635, 11, 20, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b74f5048510e49809584084a6fd5759d', 1, 1, -1, N'90812  Individual psychotherapy, interactive, using play equipment, physical devices, language interpreter, or other mechanisms of non-verbal communication, in an office or outpatient facility, approximately 45 - 50 minutes face-to-face with the patient.', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90812', 33005500, -2, 0, 0, 0, 0, 0, 364635, 45, 74, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b85254e9853b454294507698dbc295a4', 1, 0, -1, N'99382  Initial comprehensive preventive medicine evaluation and management of an individual including an AGE and GENDER APPROPRIATE HISTORY, EXAMINATION, counseling/anticipatory guidance/risk factor reduction interventions, and the ordering of appropriate immunization(s), laboratory/diagnostic procedures, new patient; early childhood (age 1 through 4 years)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99382', 28003840, -2, 0, -1, -1, -1, 365, 1825, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b945f342e28342919ea5115c2c2f3689', 1, 1, 15, N'G0406  Follow-up inpatient telehealth consultation, limited, physicians typically spend 15 minutes communicating with the patient via telehealth.', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0406', 46004620, -2, 3, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b945f342e28342919ea5115c2c2f3690', 1, 1, 25, N'G0407  Follow-up inpatient telehealth consultation, intermediate, physicians typically spend 25 minutes communicating with the patient via telehealth.', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0407', 46004620, -2, 3, 2, 2, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b945f342e28342919ea5115c2c2f3691', 1, 1, 35, N'G0408  Follow-up inpatient telehealth consultation, complex, physicians typically spend 35 minutes communicating with the patient via telehealth.', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0408', 46004620, -2, 3, 3, 3, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b945f342e28342919ea5115c2c2f3692', 1, 1, 30, N'G0425  Telehealth consultation, emergency department or initial inpatient, typically 30 minutes communicating with the patient via telehealth.', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0425', 46004610, -2, 3, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b945f342e28342919ea5115c2c2f3693', 1, 1, 50, N'G0426  Telehealth consultation, emergency department or initial inpatient, typically 50 minutes communicating with the patient via telehealth.', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0426', 46004610, -2, 3, 3, 3, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b945f342e28342919ea5115c2c2f3694', 1, 1, 70, N'G0427  Telehealth consultation, emergency department or initial inpatient, typically 70 minutes communicating with the patient via telehealth.', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0427', 46004610, -2, 3, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b945f342e28342919ea5115c2c2f3695', 1, 1, -1, N'G0508  Telehealth consultation, critical care, initial, physicians typically spend 60 minutes communicating with the patient and providers via telehealth.', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0508', 47004710, -2, 0, 0, 0, 0, 0, 364635, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b945f342e28342919ea5115c2c2f3696', 1, 1, -1, N'G0509  Telehealth consultation, critical care, subsequent, physicians typically spend 50 minutes communicating with the patient and providers via telehealth.', CAST(N'2017-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'G0509', 47004720, -2, 0, 0, 0, 0, 0, 364635, 25, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'b9fff91543db4daf9c2f7795da7260e7', 0, 1, 25, N'99214 Office or other outpatient visit for the evaluation and management of an established patient, which requires at least two of these three key components:  a detailed history, a detailed examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate to high severity. Physicians typically spend 25 minutes face-to-face with the patient and/or family.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99214', 1000, -2, 2, 3, 3, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'ba0b1bce9c384b36a320194745cd22c6', 1, 1, -1, N'99360 Standby service, requiring prolonged physician attendance, each 30 minutes (e.g., operative standby, standby for frozen section, for cesarean/high risk delivery, for monitoring EEG)  (99360 may be reported in addition to 99431, 99440 as appropriate) (For hospital mandated on call service, see 99026, 99027, 0) (99360 may be reported in addition to 99460, 99465 as appropriate) (99360 may not be reported in addition to 99464, 0)', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99360', 2550, -2, 0, -1, -1, -1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
COMMIT TRANSACTION Trans1;
GO
BEGIN TRANSACTION Trans1;
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'bae8c40d96b64f6a993b3a70695f7d22', 1, 1, -1, N'99377  Physician supervision of a hospice patient (patient not present) requiring complex and multidisciplinary care modalities involving regular physician development and/or revision of care plans, review of subsequent reports of patient status, review of subsequent reports of patient status, review of related laboratory and other studies, communication (including telephone calls) with other health care professionals involved in patient''s care, integration of new information into the medical treatment plan and/or adjustment of medical therapy, within a calendar month; 15 - 29 minutes', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99377', 27003820, -2, 0, -1, -1, -1, 0, 364635, 15, 29, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'bb1f509a83164c21ad52e16bc2456c04', 1, 0, 60, N'99327 Domiciliary rest home visit for the evaluation and management of a new patient, which requires these 3 key components: a comprehensive history, a comprehensive examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other physicians, other qualified health care professionals, or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs. Usually, the presenting problem(s) are of high severity.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99327', 21003050, -2, 3, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'bb5a80bb24ca494399c83ef928c23981', 1, 1, 40, N'99243 Office consultation for a new or established patient, which requires these three key components:  a detailed history, a detailed examination, and medical decision making of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate severity. Physicians typically spend 40 minutes face-to-face with the patient and/or family.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99243', 13001750, -2, 3, 3, 3, 2, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'bba38e6df60e491994691d10eecbdfa61', 1, 0, 60, N'99205  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99205', 1000, -2, 0, -1, -1, -1, 0, 364635, 60, 999, 28, 2, 0, 74, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'bba38e6df60e491994691d10eecbdfa610', 0, 1, 54, N'99215  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99215', 1000, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 28, 1, 1, 54, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'bba38e6df60e491994691d10eecbdfa62', 1, 0, 60, N'99205  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99205', 1000, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 28, 2, 0, 74, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'bba38e6df60e491994691d10eecbdfa63', 1, 0, 60, N'99205  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99205', 1000, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 28, 0, 1, 74, 1, 0, 1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'bba38e6df60e491994691d10eecbdfa64', 1, 0, 74, N'99205  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99205', 1000, -2, 0, -1, -1, -1, 0, 364635, 60, 999, 28, 1, 1, 74, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'bba38e6df60e491994691d10eecbdfa65', 1, 0, 74, N'99205  Office or other outpatient visit for the evaluation and management of a new patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 60 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99205', 1000, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 28, 1, 1, 74, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'bba38e6df60e491994691d10eecbdfa66', 0, 1, 40, N'99215  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99215', 1000, -2, 0, -1, -1, -1, 0, 364635, 40, 999, 28, 2, 0, 54, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'bba38e6df60e491994691d10eecbdfa67', 0, 1, 40, N'99215  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99215', 1000, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 28, 2, 0, 54, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'bba38e6df60e491994691d10eecbdfa68', 0, 1, 40, N'99215  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99215', 1000, -2, 1, -1, -1, 4, 0, 364635, 0, 999, 28, 0, 1, 54, 1, 0, 1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'bba38e6df60e491994691d10eecbdfa69', 0, 1, 54, N'99215  Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 40 minutes must be met or exceeded.', CAST(N'2024-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99215', 1000, -2, 0, -1, -1, -1, 0, 364635, 40, 999, 28, 1, 1, 54, 1, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'bbad81231f4f44cf89cbe9e544d2c4a9', 0, 1, 15, N'99334 Domiciliary rest home visit for the evaluation and management of an established patient, which requires these 2 key components: a problem focused interval history, a problem focused examination, and straightforward medical decision making. Counseling and/or coordination of care with other physicians, other qualified health care professionals, or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs. Usually, the presenting problem(s) are self-limited or minor.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99334', 21003100, -2, 2, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'bbf0f2c1cf9048f28f0b1a9c32b34a8d', 1, 1, -1, N'90804  Individual psychotherapy, insight oriented, behavior modifying and/or supportive, in an office or outpatient facility, approximately 20 - 30 minutes face-to-face with the patient.', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90804', 33005300, -2, 0, 0, 0, 0, 0, 364635, 20, 44, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'bd781b42908b44a78a7a41f3549f482f', 1, 1, -1, N'99357 Prolonged physician service (inpatient) duration: 105-134 minutes', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T23:59:00.000' AS DateTime), N'99356/99357x2', 24003400, -2, 0, -1, -1, -1, 0, 364635, 105, 134, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'be25d2a88b4242369b94907887e47a6e', 1, 1, -1, N'99361  Medical conference by a physician with interdisciplinary team of health professionals or representatives of community agencies to coordinate activities of patient care (patient not present) approximately 30 minutes', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2007-12-31T23:59:00.000' AS DateTime), N'99361', 26003500, -2, 0, -1, -1, -1, 0, 999, 0, 40, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'be3589fe5a9447fface8e120293b4f8a', 1, 1, -1, N'99360 Standby service, requiring prolonged physician attendance, each 30 minutes (e.g., operative standby, standby for frozen section, for cesarean/high risk delivery, for monitoring EEG)  (99360 may be reported in addition to 99431, 99440 as appropriate) (For hospital mandated on call service, see 99026, 99027, 0) (99360 may be reported in addition to 99460, 99465 as appropriate) (99360 may not be reported in addition to 99464, 0)', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99360', 25003400, -2, 0, -1, -1, -1, 0, 364635, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'beadc1d178e64416a87a2dda02d60070', 1, 1, -1, N'99358  Prolonged evaluation and management service before and/or after direct (Face-to-Face) patient care (e.g., review of extensive records and tests, communication with other professionals and/or the patient/family); first hour', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99358', 2500, -2, 0, -1, -1, -1, 0, 364635, 30, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'bff23c0892c14119b45b106c6466f63a', 1, 1, -1, N'99217 Observation care discharge day management (This code is to be utilized by the physician to report all services provided to a patient on discharge from outpatient hospital "observation status" if the discharge is on other than the initial date of "observation status." To report services to a patient designated as "observation status" or "inpatient status" and discharged on the same date, use the codes for Observation or Inpatient Care Services [including Admission and Discharge Services, 99234-99236 as appropriate.])', CAST(N'2018-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99217', 11001010, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c0366ff7ba884d46b652d5deaed1ccec', 1, 1, 0, N'99495  Transitional Care Management Services with the following required elements:  1, 0)  Communication (direct contact, telephone, electronic) with the patient and/or caregiver within 2 business days of discharge, 2, 0) Medical decision making of at least moderate complexity during the service period, 3, 0) Face-to-face visit, within 14 calendar days', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2017-12-31T23:59:00.000' AS DateTime), N'99495', 44009400, -2, 1, -1, -1, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c073c1938d5848f0a193342c0bee1abf', 1, 0, 45, N'99326 Domiciliary rest home visit for the evaluation and management of a new patient, which requires these 3 key components: a detailed history, a detailed examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other physicians, other qualified health care professionals, or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs. Usually, the presenting problem(s) are of moderate to high severity.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99326', 21003050, -2, 3, 3, 3, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c0a1b765ea6848d0ac5bdd9cdb80f153', 1, 1, 15, N'99407 Smoking and tobacco use cessation counseling visit; intensive, greater than 10 minutes (Do not report 99407 in conjunction with 99406, 0)', CAST(N'2008-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99407', 28003910, -2, 0, 0, 0, 0, 0, 364635, 11, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c0a1fa3e724048989792edc8c36e4179', 1, 1, -1, N'99284 Emergency department visit for the evaluation and management of a patient, which requires these three key components: a detailed history, a detailed examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of high severity, and require urgent evaluation by the physician but do not pose an immediate significant threat to life or physiologic function.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99284', 14001890, -2, 3, 3, 3, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c0a93961ca404bcfa215de3b9c451a58', 1, 1, -1, N'Procedure', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'Procedure', 4200, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c23c7d71d9b14ce3b40c197e5cb2281f', 1, 1, -1, N'90826  Individual psychotherapy, interactive, using play equipment, physical devices, language interpreter, or other mechanisms of non-verbal communication, in an inpatient hospital, partial hospital or residential care setting, approximately 45 to 50 minutes face-to-face with the patient', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90826', 34005900, -2, 0, 0, 0, 0, 0, 364635, 45, 74, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c2919e76b4354a01a51f6e1c4cf08782', 1, 1, 60, N'99244 Office consultation for a new or established patient, which requires these three key components:  a comprehensive history, a comprehensive examination, and medical decision making of moderate complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of moderate to high severity. Physicians typically spend 60 minutes face-to-face with the patient and/or family.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99244', 13001750, -2, 3, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c373da331a3f4c148601569947f53e4d', 1, 1, 30, N'99218 Initial observation care, per day, for the evaluation and management of a patient which requires these three key components: a detailed or comprehensive history;  a detailed or comprehensive examination; and medical decision making that is straightforward or of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the problem(s) requiring admission to "observation status" are of low severity.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'99218', 11001100, -2, 3, 3, 3, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c38c15f9710447c7b982a6c15863b223', 1, 1, 50, N'99235 Observation or inpatient hospital care, for the evaluation and management of a patient including admission and discharge on the same date, which requires these 3 key components: a comprehensive history, a comprehensive exam, and medical decision making that is moderate complexity.', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99235', 12001400, -2, 3, 4, 4, 3, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c5d9677602e84a8f95a91944fe4b7371', 1, 1, -1, N'99354 Prolonged service in the office or other outpatient setting requiring direct patient contact beyond the usual service; first hour', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T23:59:00.000' AS DateTime), N'99354', 24003300, -2, 0, -1, -1, -1, 0, 364635, 30, 74, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c5e3b8a1495b4f30b4cd68534647d98a', 1, 1, -1, N'90819  Individual psychotherapy, insight oriented, behavior and/or supportive, in an inpatient hospital, partial hospital or residential care setting, approximately 45 to 50 minutes face-to-face with the patient with medical evaluation and management services', CAST(N'2010-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90819', 34005800, -2, 0, 0, 0, 0, 0, 364635, 45, 74, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c6cc0656b84f40958d1f4261904e8f51', 1, 1, -1, N'99310  Subsequent nursing facility care, per day, for the evaluation and management of a patient.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2007-12-31T23:59:00.000' AS DateTime), N'99310', 20002900, -2, 2, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 4)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c77d46ad328c48cfb74a562d017b2252', 1, 1, -1, N'99363 Anticoagulant management for an outpatient taking warfarin, physician review and interpretation of International Normalized Ratio (INR) testing, patient instructions, dosage adjustment (as needed), and ordering of additional tests; initial 90 days of therapy (must include a minimum of 8 INR measurements)', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2017-12-31T23:59:00.000' AS DateTime), N'99363', 26003600, -2, 0, -1, -1, -1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c7d16f2190aa47fa9be9428219d72796', 0, 1, 0, N'99496  Transitional Care Management Services with the following required elements:  1, 0)  Communication (direct contact, telephone, electronic) with the patient and/or caregiver within 2 business days of discharge, 2, 0) Medical decision making of high complexity during the service period, 3, 0) Face-to-face visit, within 7 calendar days of discharge. (Do not report 90951-90970, 98960-98962, 9866-98969, 99071, 99078, 99080, 99090, 99091, 99339, 99340, 99358, 99359, 99363, 99364, 99366-99368, 99374-99380, 99441-99444, 99487-99489, 99605-99607 when performed during the service time of codes 99495 or 99496, 0)', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99496', 44009400, -2, 1, -1, -1, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c80067a025f54d56937bf4f7d5a975ba', 1, 1, 55, N'99236 Observation or inpatient hospital care, for the evaluation and management of a patient including admission and discharge on the same date which requires these three key components: a comprehensive history, a comprehensive examination, and  medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually the presenting problem(s) requiring admission are of high severity.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99236', 1250, -2, 3, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c806cd9540bd48fa99e1f17793b006e8', 1, 1, -1, N'99285 Emergency department visit for the evaluation and management of a patient, which requires these three key components within the constraints imposed by the urgency of the patient''s clinical condition and/or mental status:  a comprehensive history, a comprehensive examination, and medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the presenting problem(s) are of high severity and pose an immediate significant threat to life or physiologic function.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99285', 14001890, -2, 3, 4, 4, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 5)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c80db0f238f34e70ba961524f01b5b76', 1, 1, 35, N'99233 Subsequent hospital care, per day, for the evaluation and management of a patient, which requires at least two of these three key components: a detailed interval history, a detailed examination, and medical decision making of high complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the patient is unstable or has developed a significant complication or a significant new problem. Physicians typically spend 35 minutes at the bedside and on the patient''s hospital floor or unit.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99233', 12001300, -2, 2, 3, 3, 4, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c8878916daa4470b96cd5887da774eb8', 1, 1, -1, N'99403  Preventive medicine counseling and/or risk factor reduction intervention(s) provided to an individual (separate procedure);  approximately 45 minutes', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99403', 28003900, -2, 0, -1, -1, -1, 0, 364635, 41, 55, NULL, NULL, NULL, -1, 0, -1, -1, 3)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c94f4f8b8de6444288b00e7759c298bf', 1, 1, -1, N'90862  Pharmacologic management, including prescription, use, and review of medication with no more than minimal medical psychotherapy', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2012-12-31T23:59:00.000' AS DateTime), N'90862', 37006700, -2, 0, 0, 0, 0, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c97fabbfe5d9429ab3fdd8a3c4c6492c', 0, 1, 15, N'99347 Home visit for the evaluation and management of an established patient, which requires two of these three key components:  a problem focused interval history, a problem focused examination, and a straightforward medical decision making.  Usually, the presenting problem(s) are self-limited or minor.  Physicians typically spend 15 minutes face-to-face with the patient and/or family.', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99347', 23003200, -2, 2, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'c9f463769f8841449306aa90aa7344eb', 1, 1, -1, N'90791 Psychiatric diagnostic evaluation', CAST(N'2013-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'90791', 35007800, -2, 2, 2, 1, 999, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'ca379b42aa6d42fa9cd15a2883583947', 1, 1, -1, N'99357 Prolonged physician service (inpatient) duration: 75-104 minutes', CAST(N'2009-01-01T00:00:00.000' AS DateTime), CAST(N'2013-12-31T23:59:00.000' AS DateTime), N'99356/99357x1', 24003400, -2, 0, -1, -1, -1, 0, 364635, 75, 104, NULL, NULL, NULL, -1, 0, -1, -1, 2)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'ca654d2f65794543b3d9fb98912f4ac9', 1, 1, 15, N'99231 Subsequent hospital care, per day, for the evaluation and management of a patient, which requires at least two of these three key components: a problem focused interval history, a problem focused examination, and medical decision making that is straightforward or of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or family''s needs.  Usually, the patient is stable, recovering or improving. Physicians typically spend 15 minutes at the bedside and on the patient''s hospital floor or unit.', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2022-12-31T23:59:00.000' AS DateTime), N'99231', 12001300, -2, 2, 1, 1, 1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'cabfbe9ef5d84a96861ad57582a4a5d6', 1, 1, -1, N'99429  Unlisted preventive medicine service', CAST(N'1996-01-01T00:00:00.000' AS DateTime), CAST(N'2014-12-31T23:59:00.000' AS DateTime), N'99429', 28004110, -2, 0, -1, -1, -1, 0, 364635, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'cb123444726f4f8e8e7588e52324cc3e', 1, 0, -1, N'99465 Delivery/birthing room resuscitation, provision of positive pressure ventilation and/or chest compressions in the presence of acute inadequate ventilation and/or cardiac output. (Do not report 99465 in conjunction with 99460, 99468, 99477, 0) (Do not report 99465 in conjunction with 99464, 0) (Procedures that are performed as a necessary part of the resuscitation [eg, intubation, vascular lines] are reported separately in addition to 99465.  In order to report these procedures, they must be performed as a necessary component of the resuscitation and not as a convenience before admission to the neonatal intensive care unit)', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99465', 30124560, -2, 0, -1, -1, -1, 0, 29, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'cb342761e7c74e9ea771404757e7bb59', 1, 0, -1, N'99464  Attendance at delivery (when requested by delivering physician) and initial stabilization of newborn.  
(99464 may be reported in conjunction with 99460, 99468, 99477, 0)
(Do not report 99464 in conjunction with 99465, 0)', CAST(N'2015-01-01T00:00:00.000' AS DateTime), CAST(N'2026-12-31T23:59:00.000' AS DateTime), N'99464', 30124550, -2, 0, -1, -1, -1, 0, 29, 0, 999, NULL, NULL, NULL, -1, 0, -1, -1, 1)
INSERT [dbo].[CPTCodes] ([MasterID], [New], [Established], [TypicalTimeSpent], [Description], [BeginDate], [EndDate], [Code], [ServiceTypeID], [SubServiceTypeID], [KeyComponents], [HistoryLevel], [ExamLevel], [DecisionLevel], [AgeLow], [AgeHigh], [TimeLow], [TimeHigh], [QuestionTypeID], [NumYes], [NumNo], [TypicalClinical], [AppropriateHistoryExam], [MaxYes], [MaxNo], [VarianceValue]) VALUES (N'cb5470cecf724389b40718145d4d8e70', 1, 1, 25, N'99304 Initial nursing facility care, per day, for the evaluation and management of a patient which requires these three key components: a detailed or comprehensive history, a detailed or comprehensive examination, and medical decision making that is straightforward or of low complexity. Counseling and/or coordination of care with other providers or agencies are provided consistent with the nature of the problem(s) and the patient''s and/or fam